/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.transports.netty;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.hornetq.integration.transports.netty.HornetQFrameDecoder;
import org.hornetq.integration.transports.netty.HornetQFrameDecoder2;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.BufferDecoder;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.ssl.SslHandler;

public class ChannelPipelineSupport {
    private ChannelPipelineSupport() {
    }

    public static void addCodecFilter(ProtocolType protocol, ChannelPipeline pipeline, BufferDecoder decoder) {
        assert (pipeline != null);
        if (protocol == ProtocolType.CORE) {
            pipeline.addLast("decoder", (ChannelHandler)new HornetQFrameDecoder2());
        } else {
            pipeline.addLast("decoder", (ChannelHandler)new HornetQFrameDecoder(decoder));
        }
    }

    public static void addSSLFilter(ChannelPipeline pipeline, SSLContext context, boolean client) throws Exception {
        SSLEngine engine = context.createSSLEngine();
        engine.setUseClientMode(client);
        if (client) {
            engine.setWantClientAuth(true);
        }
        SslHandler handler = new SslHandler(engine);
        pipeline.addLast("ssl", (ChannelHandler)handler);
    }
}

