/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.transports.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.remoting.impl.ssl.SSLSupport;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.server.management.NotificationService;
import org.hornetq.integration.transports.netty.ChannelPipelineSupport;
import org.hornetq.integration.transports.netty.HornetQChannelHandler;
import org.hornetq.integration.transports.netty.HttpAcceptorHandler;
import org.hornetq.integration.transports.netty.HttpKeepAliveRunnable;
import org.hornetq.integration.transports.netty.NettyAcceptorFactory;
import org.hornetq.integration.transports.netty.NettyConnection;
import org.hornetq.integration.transports.netty.TransportConstants;
import org.hornetq.spi.core.protocol.ProtocolType;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.BufferDecoder;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.TypedProperties;
import org.hornetq.utils.VersionLoader;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.local.DefaultLocalServerChannelFactory;
import org.jboss.netty.channel.local.LocalAddress;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.VirtualExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAcceptor
implements Acceptor {
    static final Logger log = Logger.getLogger(NettyAcceptor.class);
    private ChannelFactory channelFactory;
    private volatile ChannelGroup serverChannelGroup;
    private volatile ChannelGroup channelGroup;
    private ServerBootstrap bootstrap;
    private final BufferHandler handler;
    private final BufferDecoder decoder;
    private final ConnectionLifeCycleListener listener;
    private final boolean sslEnabled;
    private final boolean httpEnabled;
    private final long httpServerScanPeriod;
    private final long httpResponseTime;
    private final boolean useNio;
    private final boolean useInvm;
    private final ProtocolType protocol;
    private final String host;
    private final int port;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final boolean tcpNoDelay;
    private final int tcpSendBufferSize;
    private final int tcpReceiveBufferSize;
    private final HttpKeepAliveRunnable httpKeepAliveRunnable;
    private final ConcurrentMap<Object, Connection> connections = new ConcurrentHashMap<Object, Connection>();
    private final Executor threadPool;
    private NotificationService notificationService;
    private VirtualExecutorService bossExecutor;
    private boolean paused;

    public NettyAcceptor(Map<String, Object> configuration, BufferHandler handler, BufferDecoder decoder, ConnectionLifeCycleListener listener, Executor threadPool, ScheduledExecutorService scheduledThreadPool) {
        this.handler = handler;
        this.decoder = decoder;
        this.listener = listener;
        this.sslEnabled = ConfigurationHelper.getBooleanProperty((String)"ssl-enabled", (boolean)false, configuration);
        this.httpEnabled = ConfigurationHelper.getBooleanProperty((String)"http-enabled", (boolean)false, configuration);
        if (this.httpEnabled) {
            this.httpServerScanPeriod = ConfigurationHelper.getLongProperty((String)"http-server-scan-period", (long)5000L, configuration);
            this.httpResponseTime = ConfigurationHelper.getLongProperty((String)"http-response-time", (long)10000L, configuration);
            this.httpKeepAliveRunnable = new HttpKeepAliveRunnable();
            ScheduledFuture<?> future = scheduledThreadPool.scheduleAtFixedRate(this.httpKeepAliveRunnable, this.httpServerScanPeriod, this.httpServerScanPeriod, TimeUnit.MILLISECONDS);
            this.httpKeepAliveRunnable.setFuture(future);
        } else {
            this.httpServerScanPeriod = 0L;
            this.httpResponseTime = 0L;
            this.httpKeepAliveRunnable = null;
        }
        this.useNio = ConfigurationHelper.getBooleanProperty((String)"use-nio", (boolean)true, configuration);
        this.useInvm = ConfigurationHelper.getBooleanProperty((String)"use-invm", (boolean)false, configuration);
        String protocolStr = ConfigurationHelper.getStringProperty((String)"protocol", (String)TransportConstants.DEFAULT_PROTOCOL, configuration);
        this.protocol = ProtocolType.valueOf((String)protocolStr.toUpperCase());
        this.host = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", configuration);
        this.port = ConfigurationHelper.getIntProperty((String)"port", (int)5445, configuration);
        if (this.sslEnabled) {
            this.keyStorePath = ConfigurationHelper.getStringProperty((String)"key-store-path", (String)"hornetq.keystore", configuration);
            this.keyStorePassword = ConfigurationHelper.getStringProperty((String)"key-store-password", (String)"secureexample", configuration);
            this.trustStorePath = ConfigurationHelper.getStringProperty((String)"trust-store-path", (String)"hornetq.truststore", configuration);
            this.trustStorePassword = ConfigurationHelper.getStringProperty((String)"trust-store-password", (String)"secureexample", configuration);
        } else {
            this.keyStorePath = null;
            this.keyStorePassword = null;
            this.trustStorePath = null;
            this.trustStorePassword = null;
        }
        this.tcpNoDelay = ConfigurationHelper.getBooleanProperty((String)"tcp-no-delay", (boolean)true, configuration);
        this.tcpSendBufferSize = ConfigurationHelper.getIntProperty((String)"tcp-send-buffer-size", (int)32768, configuration);
        this.tcpReceiveBufferSize = ConfigurationHelper.getIntProperty((String)"tcp-receive-buffer-size", (int)32768, configuration);
        this.threadPool = threadPool;
    }

    public synchronized void start() throws Exception {
        SSLContext context;
        if (this.channelFactory != null) {
            return;
        }
        this.bossExecutor = new VirtualExecutorService(this.threadPool);
        VirtualExecutorService workerExecutor = new VirtualExecutorService(this.threadPool);
        this.channelFactory = this.useInvm ? new DefaultLocalServerChannelFactory() : (this.useNio ? new NioServerSocketChannelFactory((Executor)this.bossExecutor, (Executor)workerExecutor) : new OioServerSocketChannelFactory((Executor)this.bossExecutor, (Executor)workerExecutor));
        this.bootstrap = new ServerBootstrap(this.channelFactory);
        if (this.sslEnabled) {
            try {
                context = SSLSupport.createServerContext((String)this.keyStorePath, (String)this.keyStorePassword, (String)this.trustStorePath, (String)this.trustStorePassword);
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException("Unable to create NettyAcceptor for " + this.host + ":" + this.port);
                ise.initCause(e);
                throw ise;
            }
        } else {
            context = null;
        }
        ChannelPipelineFactory factory = new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                if (NettyAcceptor.this.sslEnabled) {
                    ChannelPipelineSupport.addSSLFilter(pipeline, context, false);
                }
                if (NettyAcceptor.this.httpEnabled) {
                    pipeline.addLast("httpRequestDecoder", (ChannelHandler)new HttpRequestDecoder());
                    pipeline.addLast("httpResponseEncoder", (ChannelHandler)new HttpResponseEncoder());
                    pipeline.addLast("httphandler", (ChannelHandler)new HttpAcceptorHandler(NettyAcceptor.this.httpKeepAliveRunnable, NettyAcceptor.this.httpResponseTime));
                }
                ChannelPipelineSupport.addCodecFilter(NettyAcceptor.this.protocol, pipeline, NettyAcceptor.this.decoder);
                pipeline.addLast("handler", (ChannelHandler)new HornetQServerChannelHandler(NettyAcceptor.this.channelGroup, NettyAcceptor.this.handler, new Listener()));
                return pipeline;
            }
        };
        this.bootstrap.setPipelineFactory(factory);
        this.bootstrap.setOption("child.tcpNoDelay", (Object)this.tcpNoDelay);
        if (this.tcpReceiveBufferSize != -1) {
            this.bootstrap.setOption("child.receiveBufferSize", (Object)this.tcpReceiveBufferSize);
        }
        if (this.tcpSendBufferSize != -1) {
            this.bootstrap.setOption("child.sendBufferSize", (Object)this.tcpSendBufferSize);
        }
        this.bootstrap.setOption("reuseAddress", (Object)true);
        this.bootstrap.setOption("child.reuseAddress", (Object)true);
        this.bootstrap.setOption("child.keepAlive", (Object)true);
        this.channelGroup = new DefaultChannelGroup("hornetq-accepted-channels");
        this.serverChannelGroup = new DefaultChannelGroup("hornetq-acceptor-channels");
        this.startServerChannels();
        this.paused = false;
        if (!"3.1.5.GA-r1772".equals(VersionLoader.getVersion().getNettyVersion())) {
            log.warn((Object)("Unexpected Netty Version was expecting " + VersionLoader.getVersion().getNettyVersion() + " using " + "3.1.5.GA-r1772"));
        }
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(NettyAcceptorFactory.class.getName()));
            props.putSimpleStringProperty(new SimpleString("host"), new SimpleString(this.host));
            props.putIntProperty(new SimpleString("port"), this.port);
            Notification notification = new Notification(null, NotificationType.ACCEPTOR_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
        log.info((Object)"Started Netty Acceptor version 3.1.5.GA-r1772");
    }

    private void startServerChannels() {
        String[] hosts;
        for (String h : hosts = TransportConfiguration.splitHosts((String)this.host)) {
            Object address = this.useInvm ? new LocalAddress(h) : new InetSocketAddress(h, this.port);
            Channel serverChannel = this.bootstrap.bind((SocketAddress)address);
            this.serverChannelGroup.add((Object)serverChannel);
        }
    }

    public synchronized void stop() {
        if (this.channelFactory == null) {
            return;
        }
        this.serverChannelGroup.close().awaitUninterruptibly();
        if (this.httpKeepAliveRunnable != null) {
            this.httpKeepAliveRunnable.close();
        }
        this.serverChannelGroup.close().awaitUninterruptibly();
        ChannelGroupFuture future = this.channelGroup.close().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            log.warn((Object)"channel group did not completely close");
            for (Channel channel : future.getGroup()) {
                if (!channel.isBound()) continue;
                log.warn((Object)(channel + " is still connected to " + channel.getRemoteAddress()));
            }
        }
        this.channelFactory.releaseExternalResources();
        this.channelFactory = null;
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("factory"), new SimpleString(NettyAcceptorFactory.class.getName()));
            props.putSimpleStringProperty(new SimpleString("host"), new SimpleString(this.host));
            props.putIntProperty(new SimpleString("port"), this.port);
            Notification notification = new Notification(null, NotificationType.ACCEPTOR_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.paused = false;
    }

    public boolean isStarted() {
        return this.channelFactory != null;
    }

    public void pause() {
        if (this.paused) {
            return;
        }
        if (this.channelFactory == null) {
            return;
        }
        ChannelGroupFuture future = this.serverChannelGroup.unbind().awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            log.warn((Object)"server channel group did not completely unbind");
            for (Channel channel : future.getGroup()) {
                if (!channel.isBound()) continue;
                log.warn((Object)(channel + " is still bound to " + channel.getRemoteAddress()));
            }
        }
        this.bossExecutor.shutdown();
        try {
            this.bossExecutor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.paused = true;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    private class Listener
    implements ConnectionLifeCycleListener {
        private Listener() {
        }

        public void connectionCreated(Connection connection, ProtocolType protocol) {
            if (NettyAcceptor.this.connections.putIfAbsent(connection.getID(), connection) != null) {
                throw new IllegalArgumentException("Connection already exists with id " + connection.getID());
            }
            NettyAcceptor.this.listener.connectionCreated(connection, NettyAcceptor.this.protocol);
        }

        public void connectionDestroyed(Object connectionID) {
            if (NettyAcceptor.this.connections.remove(connectionID) != null) {
                NettyAcceptor.this.listener.connectionDestroyed(connectionID);
            }
        }

        public void connectionException(final Object connectionID, final HornetQException me) {
            new Thread(){

                public void run() {
                    NettyAcceptor.this.listener.connectionException(connectionID, me);
                }
            }.start();
        }
    }

    @ChannelPipelineCoverage(value="one")
    private final class HornetQServerChannelHandler
    extends HornetQChannelHandler {
        HornetQServerChannelHandler(ChannelGroup group, BufferHandler handler, ConnectionLifeCycleListener listener) {
            super(group, handler, listener);
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            new NettyConnection(e.getChannel(), new Listener());
            SslHandler sslHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class);
            if (sslHandler != null) {
                sslHandler.handshake(e.getChannel()).addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            HornetQServerChannelHandler.this.active = true;
                        } else {
                            future.getChannel().close();
                        }
                    }
                });
            } else {
                this.active = true;
            }
        }
    }
}

