/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.console;

import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JTextArea;
import org.hortonmachine.gui.console.ConsoleMessageFilter;

public class CustomOutputStream
extends OutputStream {
    private JTextArea textArea;
    private final StringBuilder sb = new StringBuilder();

    public CustomOutputStream(JTextArea textArea) {
        this.textArea = textArea;
    }

    @Override
    public void write(int b) throws IOException {
        char c = (char)b;
        if (c == '\r') {
            return;
        }
        if (c == '\n') {
            String text = this.sb.toString();
            if (!ConsoleMessageFilter.doRemove(text)) {
                this.textArea.append(text);
                this.textArea.append("\n");
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            }
            this.sb.setLength(0);
        } else {
            this.sb.append(c);
        }
    }
}

