/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.spatialtoolbox.core;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Collection;
import oms3.Access;
import oms3.annotations.Description;
import oms3.annotations.Unit;
import org.hortonmachine.gui.spatialtoolbox.core.AnnotationUtilities;
import org.hortonmachine.gui.spatialtoolbox.core.FieldData;

public class SpatialToolboxUtils {
    private static final String NO_DOCUMENTATION_AVAILABLE = "<b>NO DOCUMENTATION AVAILABLE</b>";
    private static final String STAGEHTMLDOCS = "stagehtmldocs";
    private static final String NEWLINE = "\n";
    private static final String HTMLNEWLINE = "<br>";
    private static final String DOCSSUFFIX = ".html";

    public static boolean isFieldExceptional(FieldData inputData) {
        return inputData.guiHints != null && inputData.guiHints.equals("filespathlist");
    }

    private static void collectParameters(StringBuilder sbTmp, Collection<Access> accessList) throws Exception {
        for (Access access : accessList) {
            Field field = access.getField();
            String fieldName = field.getName();
            Description descriptionAnnot = field.getAnnotation(Description.class);
            if (fieldName.equals("pm")) continue;
            Object fieldDescription = " - ";
            if (descriptionAnnot != null) {
                Unit unitAnn;
                fieldDescription = AnnotationUtilities.getLocalizedDescription(descriptionAnnot);
                if (fieldDescription == null) {
                    fieldDescription = " - ";
                }
                if ((unitAnn = field.getAnnotation(Unit.class)) != null) {
                    fieldDescription = (String)fieldDescription + " [" + unitAnn.value() + "]";
                }
            }
            sbTmp.append("<tr>").append(NEWLINE);
            sbTmp.append("<td width=\"40%\"> <b>").append(fieldName).append("</b> </td><td width=\"60%\"> ");
            sbTmp.append((String)fieldDescription).append(" </td>").append(NEWLINE);
            sbTmp.append("</tr>").append(NEWLINE);
        }
    }

    private static void toTable(StringBuilder sbToAppendTo, StringBuilder tableContentSb, String tableTitle) {
        if (tableContentSb.length() > 0) {
            sbToAppendTo.append("<h3>" + tableTitle + "</h3>").append(NEWLINE);
            sbToAppendTo.append("<table width=\"100%\" border=\"1\" cellpadding=\"10\">").append(NEWLINE);
            sbToAppendTo.append((CharSequence)tableContentSb);
            sbToAppendTo.append("</table>").append(NEWLINE);
        }
    }

    private static String getStatusString(int statusValue) {
        switch (statusValue) {
            case 40: {
                return "CERTIFIED";
            }
            case 10: {
                return "DRAFT";
            }
            case 5: {
                return "EXPERIMENTAL";
            }
            case 20: {
                return "TESTED";
            }
            case 30: {
                return "VALIDATED";
            }
        }
        return "DRAFT";
    }

    public static boolean isGrass(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        File cellFolderFile = file.getParentFile();
        File mapsetFile = cellFolderFile.getParentFile();
        File windFile = new File(mapsetFile, "WIND");
        return cellFolderFile.getName().toLowerCase().equals("cell") && windFile.exists();
    }
}

