/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapLayerListEvent;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.swing.JMapFrame;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.osm.OSMService;
import org.geotools.tile.util.TileLayer;
import org.hortonmachine.gears.io.rasterreader.OmsRasterReader;
import org.hortonmachine.gears.io.vectorreader.OmsVectorReader;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.utils.PreferencesHandler;
import org.hortonmachine.gears.utils.SldUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gears.utils.style.StyleUtilities;
import org.hortonmachine.gui.settings.SettingsController;
import org.hortonmachine.gui.utils.GuiUtilities;
import org.hortonmachine.gui.utils.ImageCache;
import org.hortonmachine.gui.utils.RasterInfoLayer;
import org.opengis.feature.type.FeatureType;

public class HMMapframe
extends JMapFrame {
    private MapContent content;
    private RasterInfoLayer rasterInfoLayer = new RasterInfoLayer();

    public HMMapframe(String title) {
        this.content = new MapContent();
        this.content.setTitle(title);
        this.setMapContent(this.content);
    }

    public void addLayer(SimpleFeatureCollection featureCollection) {
        FeatureLayer fl = this.makeFeatureLayer(featureCollection);
        this.addLayer((Layer)fl);
    }

    public void setLayer(SimpleFeatureCollection featureCollection) {
        FeatureLayer fl = this.makeFeatureLayer(featureCollection);
        this.setLayer((Layer)fl);
    }

    public void addLayer(SimpleFeatureCollection featureCollection, Style style) {
        FeatureLayer fl = new FeatureLayer((FeatureCollection)featureCollection, style);
        this.addLayer((Layer)fl);
    }

    public void setLayer(SimpleFeatureCollection featureCollection, Style style) {
        FeatureLayer fl = new FeatureLayer((FeatureCollection)featureCollection, style);
        this.setLayer((Layer)fl);
    }

    public void addLayer(Layer layer) {
        this.content.addLayer(layer);
    }

    public void removeLayer(Layer layer) {
        if (layer != null) {
            this.content.layers().removeIf(l -> l.getTitle().equals(layer.getTitle()));
            this.getMapPane().layerRemoved(new MapLayerListEvent(this.content, layer, 0));
        }
    }

    public void addLayerBottom(Layer layer) {
        this.content.addLayer(layer);
        int index = this.content.layers().indexOf(layer);
        this.content.moveLayer(index, 0);
        this.getMapPane().layerMoved(new MapLayerListEvent(this.content, layer, 0));
    }

    public void setLayer(Layer layer) {
        List layers = this.content.layers();
        for (Layer l : layers) {
            this.content.removeLayer(l);
        }
        this.content.addLayer(layer);
    }

    public List<Layer> getLayers() {
        return this.content.layers();
    }

    private FeatureLayer makeFeatureLayer(SimpleFeatureCollection featureCollection) {
        Style style = StyleUtilities.createDefaultStyle((SimpleFeatureCollection)featureCollection);
        FeatureLayer fl = new FeatureLayer((FeatureCollection)featureCollection, style);
        return fl;
    }

    public static HMMapframe openFiles(File[] files) {
        File[] openFolder;
        String title = "HM Viewer ";
        HMMapframe mapFrame = HMMapframe.getBaseFrame(title, false);
        ArrayList<File> rasterFiles = new ArrayList<File>();
        ArrayList<File> vectorFiles = new ArrayList<File>();
        HMMapframe.getFiles(files, rasterFiles, vectorFiles);
        if (rasterFiles.isEmpty() && vectorFiles.isEmpty() && (openFolder = GuiUtilities.showOpenFolderDialog(null, "Select folder to show", false, PreferencesHandler.getLastFile())) != null && openFolder.length > 0) {
            HMMapframe.getFiles(openFolder, rasterFiles, vectorFiles);
        }
        SwingUtilities.invokeLater(() -> {
            GridCoverageLayer layer;
            Style style;
            Object styleFile;
            if (!rasterFiles.isEmpty()) {
                for (File rasterFile : rasterFiles) {
                    try {
                        GridCoverage2D raster = OmsRasterReader.readRaster((String)rasterFile.getAbsolutePath());
                        styleFile = FileUtilities.substituteExtention((File)rasterFile, (String)"sld");
                        style = ((File)styleFile).exists() ? SldUtilities.getStyleFromFile((File)styleFile) : SldUtilities.getStyleFromRasterFile((File)rasterFile);
                        layer = new GridCoverageLayer(raster, style, rasterFile.getName());
                        mapFrame.addLayer((Layer)layer);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            if (!vectorFiles.isEmpty()) {
                for (File vectorFile : vectorFiles) {
                    try {
                        SimpleFeatureCollection fc = OmsVectorReader.readVector((String)vectorFile.getAbsolutePath());
                        styleFile = FileUtilities.substituteExtention((File)vectorFile, (String)"sld");
                        style = ((File)styleFile).exists() ? SldUtilities.getStyleFromFile((File)styleFile) : SLD.createSimpleStyle((FeatureType)fc.getSchema());
                        layer = new FeatureLayer((FeatureCollection)fc, style, vectorFile.getName());
                        mapFrame.addLayer((Layer)layer);
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
            }
            DefaultComboBoxModel<String> layersComboModel = new DefaultComboBoxModel<String>();
            layersComboModel.addElement("");
            HashMap<String, GridCoverageLayer> name2Layermap = new HashMap<String, GridCoverageLayer>();
            List<Layer> layers = mapFrame.getLayers();
            for (Layer layer2 : layers) {
                if (!(layer2 instanceof GridCoverageLayer)) continue;
                layersComboModel.addElement(layer2.getTitle());
                name2Layermap.put(layer2.getTitle(), (GridCoverageLayer)layer2);
            }
            JComboBox layersCombo = new JComboBox(layersComboModel);
            layersCombo.setSelectedIndex(0);
            layersCombo.addActionListener(e -> {
                GridCoverageLayer layer = mapFrame.rasterInfoLayer.getRasterLayer();
                mapFrame.removeLayer((Layer)layer);
                String layerName = (String)layersCombo.getSelectedItem();
                if (layerName.length() == 0) {
                    mapFrame.rasterInfoLayer.setRasterLayer(null);
                } else {
                    GridCoverageLayer gridCoverageLayer = (GridCoverageLayer)name2Layermap.get(layerName);
                    mapFrame.rasterInfoLayer.setRasterLayer(gridCoverageLayer);
                    mapFrame.addLayer((Layer)mapFrame.rasterInfoLayer);
                }
            });
            mapFrame.getToolBar().add(layersCombo);
        });
        return mapFrame;
    }

    private static void getFiles(File[] inputFiles, List<File> rasterFiles, List<File> vectorFiles) {
        if (inputFiles == null) {
            return;
        }
        for (File inputFile : inputFiles) {
            if (inputFile.exists()) {
                if (inputFile.isDirectory()) {
                    Object[] rasterFilesTmp = inputFile.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return HMConstants.isRaster((File)new File(dir, name));
                        }
                    });
                    Arrays.sort(rasterFilesTmp);
                    rasterFiles.addAll(Arrays.asList(rasterFilesTmp));
                    Object[] vectorFilesTmp = inputFile.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return HMConstants.isVector((File)new File(dir, name));
                        }
                    });
                    Arrays.sort(vectorFilesTmp);
                    vectorFiles.addAll(Arrays.asList(vectorFilesTmp));
                    continue;
                }
                if (HMConstants.isRaster((File)inputFile)) {
                    rasterFiles.add(inputFile);
                    continue;
                }
                if (!HMConstants.isVector((File)inputFile)) continue;
                vectorFiles.add(inputFile);
                continue;
            }
            if (inputFile.getParentFile().exists()) {
                String fileName = inputFile.getName();
                inputFile.getParentFile().listFiles((dir, name) -> name.matches(fileName));
                continue;
            }
            File file = new File(".");
            String name2 = inputFile.getName();
            File dataFile = new File(file, name2);
            if (!dataFile.exists()) continue;
            if (HMConstants.isRaster((File)inputFile)) {
                rasterFiles.add(inputFile);
                continue;
            }
            if (!HMConstants.isVector((File)inputFile)) continue;
            vectorFiles.add(inputFile);
        }
    }

    private static HMMapframe getBaseFrame(String title, boolean exitOnClose) {
        ImageIcon icon = new ImageIcon(ImageCache.getInstance().getBufferedImage("hm150.png"));
        final HMMapframe mapFrame = new HMMapframe(title);
        mapFrame.setIconImage(icon.getImage());
        mapFrame.enableToolBar(true);
        mapFrame.enableStatusBar(true);
        mapFrame.enableLayerTable(true);
        mapFrame.enableTool(new JMapFrame.Tool[]{JMapFrame.Tool.PAN, JMapFrame.Tool.ZOOM, JMapFrame.Tool.RESET, JMapFrame.Tool.INFO});
        if (exitOnClose) {
            mapFrame.setDefaultCloseOperation(3);
        } else {
            mapFrame.setDefaultCloseOperation(2);
        }
        mapFrame.setSize(1200, 900);
        mapFrame.setVisible(true);
        JToolBar toolBar = mapFrame.getToolBar();
        toolBar.add(new AbstractAction("Add OSM background", ImageCache.getInstance().getImage("globe.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                String baseURL = "http://tile.openstreetmap.org/";
                OSMService service = new OSMService("OpenStreetMap", baseURL);
                TileLayer layer = new TileLayer((TileService)service);
                layer.setTitle("OpenStreetMap");
                mapFrame.addLayerBottom((Layer)layer);
            }
        });
        return mapFrame;
    }

    public static HMMapframe openFrame(boolean exitOnClose) {
        return HMMapframe.getBaseFrame("HM Viewer", exitOnClose);
    }

    public static void main(String[] args) {
        GuiUtilities.setDefaultLookAndFeel();
        ArrayList<File> files = new ArrayList<File>();
        for (String filePath : args) {
            File openFile = new File(filePath);
            files.add(openFile);
        }
        if (!files.isEmpty()) {
            HMMapframe mf = HMMapframe.openFiles(files.toArray(new File[0]));
            SettingsController.applySettings((Component)((Object)mf));
            mf.setDefaultCloseOperation(3);
        } else {
            GuiUtilities.showWarningMessage(null, "No data folder supplied!");
        }
    }
}

