/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils;

import java.awt.Component;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.hortonmachine.dbs.log.Logger;
import org.hortonmachine.gears.libs.modules.HMFileFilter;
import org.hortonmachine.gui.spatialtoolbox.SpatialtoolboxController;
import org.hortonmachine.gui.utils.GuiBridgeHandler;
import org.hortonmachine.gui.utils.RunnableWithParameters;

public class DefaultGuiBridgeImpl
implements GuiBridgeHandler {
    private Component rootComponent;
    private File libsFolder;

    public DefaultGuiBridgeImpl() {
        this.rootComponent = null;
    }

    public DefaultGuiBridgeImpl(Component rootComponent) {
        this.rootComponent = rootComponent;
    }

    protected Component getRootComponent() {
        return this.rootComponent;
    }

    private String translate(String message) {
        return message;
    }

    private String translate(String message, String[] args) {
        return message;
    }

    public int confirmDialog(final String message, final String title, final int optionType, final int messageType) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            @Override
            public void run() {
                this.returnValue = JOptionPane.showConfirmDialog(DefaultGuiBridgeImpl.this.getRootComponent(), message, title, optionType, messageType);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.INSTANCE.insertError("", "Can't show input dialog '" + message + "'.", (Throwable)e);
            }
        }
        return (Integer)runnable.getReturnValue();
    }

    public String inputDialog(final String message, final String title, final int messageType, final String initialValue) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            @Override
            public void run() {
                this.returnValue = JOptionPane.showInputDialog(DefaultGuiBridgeImpl.this.getRootComponent(), DefaultGuiBridgeImpl.this.translate(message), DefaultGuiBridgeImpl.this.translate(title), messageType, null, null, initialValue);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.INSTANCE.insertError("", "Can't show input dialog '" + message + "'.", (Throwable)e);
            }
        }
        return (String)runnable.getReturnValue();
    }

    public String inputDialog(final String message, final String title) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            @Override
            public void run() {
                this.returnValue = JOptionPane.showInputDialog(DefaultGuiBridgeImpl.this.getRootComponent(), DefaultGuiBridgeImpl.this.translate(message), DefaultGuiBridgeImpl.this.translate(title), 3, null, null, null);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.INSTANCE.insertError("", "Can't show input dialog '" + message + "'.", (Throwable)e);
            }
        }
        return (String)runnable.getReturnValue();
    }

    @Override
    public void messageDialog(String message, String title, int messageType) {
        this.messageDialog(message, null, title, messageType);
    }

    @Override
    public void messageDialog(final String message, final String[] messageArgs, final String title, final int messageType) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultGuiBridgeImpl.this.messageDialog(message, messageArgs, title, messageType);
                    }
                });
            }
            catch (Exception e) {
                Logger.INSTANCE.insertError("", "Can't show message dialog '" + message, (Throwable)e);
            }
            return;
        }
        if (message == null) {
            Logger.INSTANCE.insertInfo("", "message is null, message dialog not show.");
            return;
        }
        JOptionPane.showMessageDialog(this.getRootComponent(), this.translate(message, messageArgs), this.translate(title), messageType);
    }

    public File[] showChooserDialog(final String title, final int type, final int selectionMode, final boolean multiselection, final File initialPath, final FileFilter filter, final boolean fileHidingEnabled) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            @Override
            public void run() {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle(title);
                fc.setDialogType(type);
                fc.setFileSelectionMode(selectionMode);
                fc.setMultiSelectionEnabled(multiselection);
                fc.setCurrentDirectory(initialPath);
                fc.setFileFilter(filter);
                fc.setFileHidingEnabled(fileHidingEnabled);
                boolean isSave = false;
                int r = 1;
                switch (type) {
                    case 1: {
                        r = fc.showSaveDialog(DefaultGuiBridgeImpl.this.getRootComponent());
                        isSave = true;
                        break;
                    }
                    default: {
                        r = fc.showOpenDialog(DefaultGuiBridgeImpl.this.getRootComponent());
                    }
                }
                if (r != 0) {
                    this.returnValue = null;
                    return;
                }
                if (filter != null) {
                    ArrayList<File> allowedFiles = new ArrayList<File>();
                    if (fc.isMultiSelectionEnabled()) {
                        File[] selectedFiles;
                        for (File selectedFile : selectedFiles = fc.getSelectedFiles()) {
                            if (!filter.accept(selectedFile)) continue;
                            allowedFiles.add(selectedFile);
                        }
                    } else {
                        File selectedFile = fc.getSelectedFile();
                        String absolutePath = selectedFile.getAbsolutePath();
                        int indexOf = absolutePath.indexOf("#");
                        if (indexOf > 0) {
                            absolutePath = absolutePath.substring(0, indexOf);
                        }
                        File checkSelectedFile = new File(absolutePath);
                        if (isSave && !filter.accept(checkSelectedFile)) {
                            Object[] allowedExtensions = null;
                            if (filter instanceof HMFileFilter) {
                                HMFileFilter hmfilter = (HMFileFilter)filter;
                                allowedExtensions = hmfilter.getAllowedExtensions();
                            }
                            Object msg = "The used extension is not supported.";
                            if (allowedExtensions != null) {
                                msg = (String)msg + " Supported extensions are: " + Arrays.toString(allowedExtensions);
                            }
                            DefaultGuiBridgeImpl.this.messageDialog((String)msg, "WARNING", 2);
                            allowedFiles = null;
                            this.returnValue = null;
                        }
                        if (filter.accept(checkSelectedFile) && allowedFiles != null) {
                            allowedFiles.add(selectedFile);
                        }
                    }
                    if (allowedFiles != null && allowedFiles.size() > 0) {
                        this.returnValue = allowedFiles.toArray(new File[0]);
                    }
                } else if (fc.isMultiSelectionEnabled()) {
                    File[] selectedFiles;
                    this.returnValue = selectedFiles = fc.getSelectedFiles();
                } else {
                    File selectedFile = fc.getSelectedFile();
                    this.returnValue = new File[]{selectedFile};
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.INSTANCE.insertError("", "Can't show chooser dialog '" + title + "'.", (Throwable)e);
            }
        }
        return (File[])runnable.getReturnValue();
    }

    @Override
    public File[] showOpenDirectoryDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 0, 1, false, initialPath, null, true);
    }

    @Override
    public File[] showOpenFileDialog(String title, File initialPath, FileFilter filter) {
        return this.showChooserDialog(title, 0, 0, false, initialPath, filter, true);
    }

    @Override
    public File[] showSaveFileDialog(String title, File initialPath, FileFilter filter) {
        return this.showChooserDialog(title, 1, 0, false, initialPath, filter, true);
    }

    @Override
    public Point2D getWorldPoint(int x, int y) {
        return null;
    }

    @Override
    public String promptForCrs() {
        return null;
    }

    @Override
    public boolean supportsMapContext() {
        return false;
    }

    @Override
    public HashMap<String, String> getSpatialToolboxPreferencesMap() {
        Preferences preferences = Preferences.userRoot().node("/org/hortonmachine/gui");
        String debug = preferences.get("jgt_prefs_debug", "false");
        String heap = preferences.get("jgt_prefs_heap", "64");
        HashMap<String, String> prefsMap = new HashMap<String, String>();
        prefsMap.put("jgt_prefs_debug", debug);
        prefsMap.put("jgt_prefs_heap", heap);
        return prefsMap;
    }

    @Override
    public void setSpatialToolboxPreferencesMap(HashMap<String, String> prefsMap) {
        Preferences preferences = Preferences.userRoot().node("/org/hortonmachine/gui");
        String debug = prefsMap.get("jgt_prefs_debug");
        String heap = prefsMap.get("jgt_prefs_heap");
        preferences.put("jgt_prefs_debug", debug);
        preferences.put("jgt_prefs_heap", heap);
    }

    @Override
    public HashMap<String, String> getGeopaparazziProjectViewerPreferencesMap() {
        Preferences preferences = Preferences.userRoot().node("/org/hortonmachine/gui");
        String lastPath = preferences.get("jgt_last_projects_path", "");
        HashMap<String, String> prefsMap = new HashMap<String, String>();
        prefsMap.put("jgt_last_projects_path", lastPath);
        return prefsMap;
    }

    @Override
    public void setGeopaparazziProjectViewerPreferencesMap(HashMap<String, String> prefsMap) {
        Preferences preferences = Preferences.userRoot().node("/org/hortonmachine/gui");
        String lastPath = prefsMap.get("jgt_last_projects_path");
        preferences.put("jgt_last_projects_path", lastPath);
    }

    @Override
    public void setLibsFolder(File libsFolder) {
        this.libsFolder = libsFolder;
    }

    @Override
    public File getLibsFolder() {
        return this.libsFolder;
    }

    @Override
    public JFrame showWindow(JComponent component, String windowTitle) {
        JFrame frame = new JFrame(windowTitle);
        Class<SpatialtoolboxController> class1 = SpatialtoolboxController.class;
        ImageIcon icon = new ImageIcon(class1.getResource("/org/hortonmachine/images/hm150.png"));
        frame.setIconImage(icon.getImage());
        frame.getContentPane().add((Component)component, "Center");
        frame.pack();
        frame.setVisible(true);
        return frame;
    }
}

