/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.console;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LogConsoleView
extends JPanel {
    JButton clearButton = new JButton();
    JButton copyButton = new JButton();
    JButton stopButton = new JButton();
    JTextArea logArea = new JTextArea();

    public LogConsoleView() {
        this.initializePanel();
    }

    void addFillComponents(Container panel, int[] cols, int[] rows) {
        int index;
        Dimension filler = new Dimension(10, 10);
        boolean filled_cell_11 = false;
        CellConstraints cc = new CellConstraints();
        if (cols.length > 0 && rows.length > 0 && cols[0] == 1 && rows[0] == 1) {
            panel.add(Box.createRigidArea(filler), cc.xy(1, 1));
            filled_cell_11 = true;
        }
        for (index = 0; index < cols.length; ++index) {
            if (cols[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(cols[index], 1));
        }
        for (index = 0; index < rows.length; ++index) {
            if (rows[index] == 1 && filled_cell_11) continue;
            panel.add(Box.createRigidArea(filler), cc.xy(1, rows[index]));
        }
    }

    public ImageIcon loadImage(String imageName) {
        try {
            ClassLoader classloader = this.getClass().getClassLoader();
            URL url = classloader.getResource(imageName);
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                return icon;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException("Unable to load image: " + imageName);
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation orientation) {
        super.applyComponentOrientation(orientation);
    }

    public JPanel createPanel() {
        JPanel jpanel1 = new JPanel();
        FormLayout formlayout1 = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:GROW(1.0),FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:GROW(1.0),CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cc = new CellConstraints();
        jpanel1.setLayout((LayoutManager)formlayout1);
        this.clearButton.setActionCommand("Clear");
        this.clearButton.setName("clearButton");
        this.clearButton.setText("Clear");
        this.clearButton.setToolTipText("Clear the console");
        jpanel1.add((Component)this.clearButton, cc.xy(2, 2));
        this.copyButton.setActionCommand("Copy");
        this.copyButton.setName("copyButton");
        this.copyButton.setText("Copy");
        this.copyButton.setToolTipText("Copy the log text to the clipboard");
        jpanel1.add((Component)this.copyButton, cc.xy(4, 2));
        this.stopButton.setActionCommand("Stop");
        this.stopButton.setName("stopButton");
        this.stopButton.setText("Stop");
        this.stopButton.setToolTipText("Stops the process if the module supports it");
        jpanel1.add((Component)this.stopButton, cc.xy(6, 2));
        this.logArea.setEditable(false);
        this.logArea.setName("logArea");
        JScrollPane jscrollpane1 = new JScrollPane();
        jscrollpane1.setViewportView(this.logArea);
        jscrollpane1.setVerticalScrollBarPolicy(20);
        jscrollpane1.setHorizontalScrollBarPolicy(30);
        jpanel1.add((Component)jscrollpane1, cc.xywh(2, 4, 6, 15));
        this.addFillComponents(jpanel1, new int[]{1, 2, 3, 4, 5, 6, 7, 8}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19});
        return jpanel1;
    }

    protected void initializePanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createPanel(), "Center");
    }
}

