/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.console;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.hortonmachine.gears.utils.processes.ELogStyle;
import org.hortonmachine.gears.utils.processes.IProcessListener;
import org.hortonmachine.gui.console.ConsoleMessageFilter;
import org.hortonmachine.gui.console.ProcessLogConsoleView;
import org.hortonmachine.gui.utils.GuiUtilities;

public class ProcessLogConsoleController
extends ProcessLogConsoleView
implements IProcessListener {
    private static final long serialVersionUID = 1L;
    private String processName;
    private Process process;
    private Runnable finishRunnable;
    private StyledDocument doc;
    private JTextPane logPane;
    private JScrollPane scrollPane;

    public ProcessLogConsoleController() {
        this.init();
    }

    private void init() {
        Class<ProcessLogConsoleController> class1 = ProcessLogConsoleController.class;
        ImageIcon trashIcon = new ImageIcon(class1.getResource("/org/hortonmachine/images/trash.gif"));
        ImageIcon copyIcon = new ImageIcon(class1.getResource("/org/hortonmachine/images/copy_edit.gif"));
        ImageIcon stopIcon = new ImageIcon(class1.getResource("/org/hortonmachine/images/progress_stop.gif"));
        this.logPane = new JTextPane();
        this.scrollPane = new JScrollPane(this.logPane);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.doc = this.logPane.getStyledDocument();
        this.logPane.setEditable(false);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ProcessLogConsoleController.this.logPane.getDocument().remove(0, ProcessLogConsoleController.this.logPane.getDocument().getLength());
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.clearButton.setIcon(trashIcon);
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtilities.copyToClipboard(ProcessLogConsoleController.this.logPane.getText());
            }
        });
        this.copyButton.setIcon(copyIcon);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcessLogConsoleController.this.stopButton.setEnabled(false);
                ProcessLogConsoleController.this.killProcess();
            }
        });
        this.stopButton.setIcon(stopIcon);
        this.setPreferredSize(new Dimension(480, 320));
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ProcessLogConsoleController.this.stopLogging();
            }
        });
    }

    protected void killProcess() {
        if (this.process != null) {
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void beginProcess(Process process, String name) {
        this.process = process;
        this.processName = name;
    }

    public void finishProcess() {
        this.stopButton.setEnabled(false);
        if (this.finishRunnable != null) {
            this.finishRunnable.run();
        }
    }

    public void stopLogging() {
    }

    public JComponent asJComponent() {
        return this;
    }

    public void onMessage(String message, ELogStyle style) {
        try {
            if (this.doc != null && !ConsoleMessageFilter.doRemove(message)) {
                this.doc.insertString(this.doc.getLength(), message + "\n", style.getAttributeSet());
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
    }

    public void onProcessStopped() {
        this.finishProcess();
    }

    public void addFinishRunnable(Runnable finishRunnable) {
        this.finishRunnable = finishRunnable;
    }
}

