/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils.executor;

import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.hortonmachine.gears.ui.progress.IProgressPrinter;
import org.hortonmachine.gears.ui.progress.ProgressUpdate;

public abstract class HMExecutor
extends SwingWorker<Void, ProgressUpdate>
implements IProgressPrinter {
    protected int w = 600;
    protected int h = 120;
    protected IProgressPrinter progress;

    public void setProgressPrinter(IProgressPrinter progress) {
        this.progress = progress;
    }

    @Override
    protected void process(List<ProgressUpdate> chunks) {
        ProgressUpdate update = chunks.get(chunks.size() - 1);
        this.progress.publish(update);
    }

    @Override
    protected Void doInBackground() {
        try {
            this.backGroundWork();
        }
        catch (Exception e) {
            this.publish(new ProgressUpdate(e.getMessage()));
        }
        return null;
    }

    public abstract void backGroundWork() throws Exception;

    public void publish(ProgressUpdate update) {
        super.publish(update);
    }

    @Override
    public void done() {
        try {
            this.get();
            this.progress.done();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }
}

