/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils.monitor;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;

public abstract class HMProgressMonitorDialog
implements PropertyChangeListener {
    protected ProgressMonitor progressMonitor;
    protected BackgroundTask task;
    private Component parent;
    protected StringBuilder finalInfoSb = new StringBuilder();
    protected StringBuilder finalErrorSb = new StringBuilder();

    public HMProgressMonitorDialog(Component parent, String title, int workLoad) {
        this.parent = parent;
        this.progressMonitor = new ProgressMonitor(parent, title, "", 0, workLoad);
        this.progressMonitor.setProgress(0);
    }

    public void run() {
        this.task = new BackgroundTask();
        this.task.addPropertyChangeListener(this);
        this.task.execute();
    }

    public abstract void processInBackground() throws Exception;

    public abstract void postDoneInUi();

    protected boolean isCancelled() {
        return this.task.isCancelled();
    }

    public void setProgressText(String text) {
        this.task.firePropertyChange("progressText", "", text);
    }

    public void setProgress(int progress) {
        this.progressMonitor.setProgress(progress);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressMonitor.setProgress(progress);
            if ((this.progressMonitor.isCanceled() || this.task.isDone()) && this.progressMonitor.isCanceled()) {
                this.task.cancel(true);
            }
        }
        if ("progressText" == evt.getPropertyName()) {
            String progressText = (String)evt.getNewValue();
            this.progressMonitor.setNote(progressText);
            if ((this.progressMonitor.isCanceled() || this.task.isDone()) && this.progressMonitor.isCanceled()) {
                this.task.cancel(true);
            }
        }
    }

    public static void main(String[] args) {
        final JFrame jframe = new JFrame("Dummy frame");
        jframe.setDefaultCloseOperation(3);
        jframe.pack();
        jframe.setLocationRelativeTo(null);
        jframe.setVisible(true);
        HMProgressMonitorDialog monitor = new HMProgressMonitorDialog(jframe, "Progress", 100){

            @Override
            public void processInBackground() throws Exception {
                Random random = new Random();
                int progress = 0;
                this.progressMonitor.setProgress(0);
                try {
                    while (progress < 100 && !this.isCancelled()) {
                        Thread.sleep(random.nextInt(1000));
                        this.progressMonitor.setProgress(Math.min(progress += random.nextInt(10), 100));
                        this.setProgressText("Blah: " + progress);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            @Override
            public void postDoneInUi() {
                JOptionPane.showMessageDialog(jframe, "DONE!", "INFO", 1);
            }
        };
        monitor.run();
    }

    class BackgroundTask
    extends SwingWorker<Void, Void> {
        BackgroundTask() {
        }

        @Override
        public Void doInBackground() {
            try {
                HMProgressMonitorDialog.this.processInBackground();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public void done() {
            HMProgressMonitorDialog.this.progressMonitor.close();
            if (HMProgressMonitorDialog.this.finalErrorSb.length() > 0) {
                JOptionPane.showMessageDialog(HMProgressMonitorDialog.this.parent, HMProgressMonitorDialog.this.finalErrorSb.toString(), "ERROR", 0);
            } else if (HMProgressMonitorDialog.this.finalInfoSb.length() > 0) {
                JOptionPane.showMessageDialog(HMProgressMonitorDialog.this.parent, HMProgressMonitorDialog.this.finalInfoSb.toString(), "INFO", 1);
            }
            HMProgressMonitorDialog.this.postDoneInUi();
        }
    }
}

