/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.spatialtoolbox;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oms3.annotations.Out;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.swing.JMapFrame;
import org.hortonmachine.dbs.log.Logger;
import org.hortonmachine.gears.io.geopaparazzi.geopap4.ETimeUtilities;
import org.hortonmachine.gears.io.rasterreader.OmsRasterReader;
import org.hortonmachine.gears.io.vectorreader.OmsVectorReader;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.DataUtilities;
import org.hortonmachine.gears.utils.PreferencesHandler;
import org.hortonmachine.gears.utils.SldUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gui.console.ProcessLogConsoleController;
import org.hortonmachine.gui.spatialtoolbox.SpatialtoolboxView;
import org.hortonmachine.gui.spatialtoolbox.core.HortonmachineModulesManager;
import org.hortonmachine.gui.spatialtoolbox.core.ModuleDescription;
import org.hortonmachine.gui.spatialtoolbox.core.ParametersPanel;
import org.hortonmachine.gui.spatialtoolbox.core.SpatialToolboxConstants;
import org.hortonmachine.gui.spatialtoolbox.core.StageScriptExecutor;
import org.hortonmachine.gui.spatialtoolbox.core.ViewerFolder;
import org.hortonmachine.gui.spatialtoolbox.core.ViewerModule;
import org.hortonmachine.gui.utils.DefaultGuiBridgeImpl;
import org.hortonmachine.gui.utils.GuiBridgeHandler;
import org.hortonmachine.gui.utils.GuiUtilities;
import org.hortonmachine.gui.utils.HMMapframe;
import org.hortonmachine.gui.utils.ImageCache;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpatialtoolboxController
extends SpatialtoolboxView
implements GuiUtilities.IOnCloseListener {
    private static final long serialVersionUID = 1L;
    protected ParametersPanel pPanel;
    protected HashMap<String, String> prefsMap = new HashMap();
    private GuiBridgeHandler guiBridge;

    public SpatialtoolboxController(GuiBridgeHandler guiBridge) {
        this.guiBridge = guiBridge;
        this.setPreferredSize(new Dimension(900, 600));
        HashMap<String, String> prefsMapTmp = guiBridge.getSpatialToolboxPreferencesMap();
        if (prefsMapTmp != null) {
            this.prefsMap = prefsMapTmp;
        }
        this.init();
    }

    protected void preInit() {
    }

    private void init() {
        this.preInit();
        Class<SpatialtoolboxController> class1 = SpatialtoolboxController.class;
        ImageIcon processingIcon = new ImageIcon(class1.getResource("/org/hortonmachine/images/processingregion.png"));
        ImageIcon startIcon = new ImageIcon(class1.getResource("/org/hortonmachine/images/start.gif"));
        ImageIcon runScriptIcon = new ImageIcon(class1.getResource("/org/hortonmachine/images/run_script.gif"));
        ImageIcon generateScriptIcon = new ImageIcon(class1.getResource("/org/hortonmachine/images/generate_script.gif"));
        ImageIcon trashIcon = new ImageIcon(class1.getResource("/org/hortonmachine/images/trash.gif"));
        final ImageIcon categoryIcon = new ImageIcon(class1.getResource("/org/hortonmachine/images/category.gif"));
        final ImageIcon moduleIcon = new ImageIcon(class1.getResource("/org/hortonmachine/images/module.gif"));
        final ImageIcon moduleExpIcon = new ImageIcon(class1.getResource("/org/hortonmachine/images/module_exp.gif"));
        ImageIcon worldIcon = ImageCache.getInstance().getImage("browser.gif");
        this._parametersPanel.setLayout(new BorderLayout());
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                SpatialtoolboxController.this.onClose();
            }
        });
        this.pPanel = new ParametersPanel(this.guiBridge);
        this.addMouseListenerToContext(this.pPanel);
        this.pPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JScrollPane scrollpane = new JScrollPane(this.pPanel);
        scrollpane.setVerticalScrollBarPolicy(20);
        scrollpane.setHorizontalScrollBarPolicy(30);
        this._parametersPanel.add((Component)scrollpane, "Center");
        this._processingRegionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this._processingRegionButton.setIcon(processingIcon);
        this._processingRegionButton.setVisible(false);
        this._startButton.setToolTipText("Start the current module.");
        this._startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProcessLogConsoleController logConsole = new ProcessLogConsoleController();
                SpatialtoolboxController.this.guiBridge.showWindow(logConsole.asJComponent(), "Spatial Toolbox Log");
                try {
                    SpatialtoolboxController.this.runModuleInNewJVM(logConsole);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this._startButton.setIcon(startIcon);
        this._runScriptButton.setToolTipText("Run a script from file.");
        this._runScriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File[] loadFiles = SpatialtoolboxController.this.guiBridge.showOpenFileDialog("Load script", PreferencesHandler.getLastFile(), null);
                if (loadFiles != null && loadFiles.length > 0) {
                    try {
                        PreferencesHandler.setLastPath((String)loadFiles[0].getAbsolutePath());
                        String readFile = FileUtilities.readFile((File)loadFiles[0]);
                        ProcessLogConsoleController logConsole = new ProcessLogConsoleController();
                        SpatialtoolboxController.this.guiBridge.showWindow(logConsole.asJComponent(), "Console Log");
                        StageScriptExecutor exec = new StageScriptExecutor(SpatialtoolboxController.this.guiBridge.getLibsFolder());
                        exec.addProcessListener(logConsole);
                        String logLevel = SpatialtoolboxController.this._debugCheckbox.isSelected() ? SpatialToolboxConstants.LOGLEVEL_GUI_ON : SpatialToolboxConstants.LOGLEVEL_GUI_OFF;
                        String ramLevel = SpatialtoolboxController.this._heapCombo.getSelectedItem().toString();
                        String sessionId = "File: " + loadFiles[0].getName() + " - " + ETimeUtilities.INSTANCE.TIMESTAMPFORMATTER_LOCAL.format(new Date());
                        Process process = exec.exec(sessionId, readFile, logLevel, ramLevel, null);
                        logConsole.beginProcess(process, sessionId);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        SpatialtoolboxController.this.guiBridge.messageDialog("ERROR", "an error occurred while running the script: " + e1.getMessage(), 0);
                    }
                }
            }
        });
        this._runScriptButton.setIcon(runScriptIcon);
        this._generateScriptButton.setToolTipText("Save the current module as a script to file.");
        this._generateScriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleDescription module = SpatialtoolboxController.this.pPanel.getModule();
                HashMap<String, Object> fieldName2ValueHolderMap = SpatialtoolboxController.this.pPanel.getFieldName2ValueHolderMap();
                List<String> outputFieldNames = SpatialtoolboxController.this.pPanel.getOutputFieldNames();
                HashMap<String, String> outputStringsMap = new HashMap<String, String>();
                Class<?> moduleClass = module.getModuleClass();
                StringBuilder scriptBuilder = SpatialtoolboxController.this.getScript(fieldName2ValueHolderMap, outputFieldNames, outputStringsMap, moduleClass);
                File[] saveFiles = SpatialtoolboxController.this.guiBridge.showSaveFileDialog("Save script", PreferencesHandler.getLastFile(), null);
                if (saveFiles != null && saveFiles.length > 0) {
                    try {
                        PreferencesHandler.setLastPath((String)saveFiles[0].getAbsolutePath());
                        FileUtilities.writeFile((String)scriptBuilder.toString(), (File)saveFiles[0]);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this._generateScriptButton.setIcon(generateScriptIcon);
        this._viewDataButton.setToolTipText("View all data used by the module in a simple viewer and check the CRS.");
        this._viewDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HashMap<String, Object> fieldName2ValueHolderMap = SpatialtoolboxController.this.pPanel.getFieldName2ValueHolderMap();
                ArrayList<File> files = new ArrayList<File>();
                for (Object value : fieldName2ValueHolderMap.values()) {
                    File possibleFile;
                    JTextField field;
                    String possiblePath;
                    if (!(value instanceof JTextField) || (possiblePath = (field = (JTextField)value).getText().trim()).length() <= 0 || !(possibleFile = new File(possiblePath)).exists() || possibleFile.isDirectory()) continue;
                    files.add(possibleFile);
                }
                SpatialtoolboxController.this.showInMapFrame(files);
            }
        });
        this._viewDataButton.setIcon(worldIcon);
        this._clearFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpatialtoolboxController.this._filterField.setText("");
                SpatialtoolboxController.this.layoutTree(false);
            }
        });
        this._clearFilterButton.setIcon(trashIcon);
        this._loadExperimentalCheckbox.setSelected(true);
        this._loadExperimentalCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpatialtoolboxController.this.layoutTree(true);
            }
        });
        boolean doDebug = false;
        String debugStr = this.prefsMap.get("jgt_prefs_debug");
        if (debugStr != null && debugStr.trim().length() > 0) {
            doDebug = Boolean.parseBoolean(debugStr);
        }
        this._debugCheckbox.setSelected(doDebug);
        this._heapCombo.setModel(new DefaultComboBoxModel<String>(SpatialToolboxConstants.HEAPLEVELS));
        String heapStr = this.prefsMap.get("jgt_prefs_heap");
        if (heapStr == null) {
            heapStr = SpatialToolboxConstants.HEAPLEVELS[0];
        }
        this._heapCombo.setSelectedItem(heapStr);
        this._debugCheckbox.addActionListener(e -> {
            this.prefsMap.put("jgt_prefs_debug", "" + this._debugCheckbox.isSelected());
            this.guiBridge.setSpatialToolboxPreferencesMap(this.prefsMap);
        });
        this._heapCombo.addActionListener(e -> {
            String ramLevel = this._heapCombo.getSelectedItem().toString();
            this.prefsMap.put("jgt_prefs_heap", ramLevel);
            this.guiBridge.setSpatialToolboxPreferencesMap(this.prefsMap);
        });
        this._filterField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SpatialtoolboxController.this.layoutTree(true);
            }
        });
        try {
            this._modulesTree.setCellRenderer(new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                    if (value instanceof Modules) {
                        this.setIcon(categoryIcon);
                    } else if (value instanceof ViewerFolder) {
                        this.setIcon(categoryIcon);
                    } else if (value instanceof ViewerModule) {
                        if (this.isExperimental(value)) {
                            this.setIcon(moduleExpIcon);
                        } else {
                            this.setIcon(moduleIcon);
                        }
                    }
                    return this;
                }

                private boolean isExperimental(Object node) {
                    ViewerModule module;
                    ModuleDescription md;
                    return node instanceof ViewerModule && (md = (module = (ViewerModule)node).getModuleDescription()).getStatus() == ModuleDescription.Status.experimental;
                }
            });
            this._modulesTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent evt) {
                    TreePath[] paths = evt.getPaths();
                    for (int i = 0; i < paths.length; ++i) {
                        Object lastPathComponent = paths[i].getLastPathComponent();
                        if (lastPathComponent instanceof ViewerModule) {
                            ViewerModule module = (ViewerModule)lastPathComponent;
                            ModuleDescription moduleDescription = module.getModuleDescription();
                            SpatialtoolboxController.this.pPanel.setModule(moduleDescription);
                            SpatialtoolboxController.this._parametersPanel.validate();
                            SpatialtoolboxController.this._parametersPanel.repaint();
                            break;
                        }
                        if (!(lastPathComponent instanceof ViewerFolder)) continue;
                        SpatialtoolboxController.this.pPanel.setModule(null);
                        SpatialtoolboxController.this._parametersPanel.validate();
                        SpatialtoolboxController.this._parametersPanel.repaint();
                        break;
                    }
                }
            });
            this.layoutTree(false);
        }
        catch (Exception e1) {
            Logger.INSTANCE.insertError("", "Error", (Throwable)e1);
        }
    }

    private void showInMapFrame(List<File> dataFiles) {
        String crsStr;
        boolean isOk;
        ArrayList<FeatureLayer> featureLayers = new ArrayList<FeatureLayer>();
        ArrayList<GridCoverageLayer> rasterLayers = new ArrayList<GridCoverageLayer>();
        TreeSet<String> crsSet = new TreeSet<String>();
        block4: for (File file : dataFiles) {
            String[] supportedVectorExtensions;
            String name = file.getName().toLowerCase();
            for (String ext : supportedVectorExtensions = HMConstants.SUPPORTED_VECTOR_EXTENSIONS) {
                if (!name.endsWith(ext)) continue;
                try {
                    SimpleFeatureCollection fc = OmsVectorReader.readVector((String)file.getAbsolutePath());
                    File styleFile = FileUtilities.substituteExtention((File)file, (String)"sld");
                    Style style = styleFile.exists() ? SldUtilities.getStyleFromFile((File)styleFile) : SLD.createSimpleStyle((FeatureType)fc.getSchema());
                    FeatureLayer layer = new FeatureLayer((FeatureCollection)fc, style);
                    featureLayers.add(layer);
                    CoordinateReferenceSystem crs = ((SimpleFeatureType)fc.getSchema()).getCoordinateReferenceSystem();
                    String epsg = CrsUtilities.getCodeFromCrs((CoordinateReferenceSystem)crs);
                    crsSet.add(epsg);
                    break;
                }
                catch (Exception e) {
                    Logger.INSTANCE.insertError(null, "Can't load feature layer: " + file.getName(), (Throwable)e);
                }
            }
            String[] supportedRasterExtensions = HMConstants.SUPPORTED_RASTER_EXTENSIONS;
            for (String ext : supportedRasterExtensions) {
                if (!name.endsWith(ext)) continue;
                try {
                    GridCoverage2D raster = OmsRasterReader.readRaster((String)file.getAbsolutePath());
                    File styleFile = FileUtilities.substituteExtention((File)file, (String)"sld");
                    Style style = styleFile.exists() ? SldUtilities.getStyleFromFile((File)styleFile) : SldUtilities.getStyleFromRasterFile((File)file);
                    GridCoverageLayer layer = new GridCoverageLayer(raster, style);
                    rasterLayers.add(layer);
                    CoordinateReferenceSystem crs = raster.getCoordinateReferenceSystem();
                    String epsg = CrsUtilities.getCodeFromCrs((CoordinateReferenceSystem)crs);
                    crsSet.add(epsg);
                    continue block4;
                }
                catch (Exception e) {
                    Logger.INSTANCE.insertError(null, "Can't load raster layer: " + file.getName(), (Throwable)e);
                }
            }
        }
        if ((featureLayers.size() > 0 || rasterLayers.size() > 0) && (isOk = GuiUtilities.showYesNoDialog(this.pPanel, "Found the following CRS in the data: \n" + (crsStr = crsSet.stream().collect(Collectors.joining("\n")))))) {
            Class<SpatialtoolboxController> class1 = SpatialtoolboxController.class;
            ImageIcon icon = new ImageIcon(class1.getResource("/org/hortonmachine/images/hm150.png"));
            HMMapframe mapFrame = new HMMapframe("Module dataset viewer");
            mapFrame.setIconImage(icon.getImage());
            mapFrame.enableToolBar(true);
            mapFrame.enableStatusBar(true);
            mapFrame.enableLayerTable(true);
            mapFrame.enableTool(new JMapFrame.Tool[]{JMapFrame.Tool.PAN, JMapFrame.Tool.ZOOM, JMapFrame.Tool.RESET});
            mapFrame.setDefaultCloseOperation(2);
            mapFrame.setSize(900, 600);
            for (Layer layer : rasterLayers) {
                mapFrame.addLayer(layer);
            }
            for (Layer layer : featureLayers) {
                mapFrame.addLayer(layer);
            }
            mapFrame.setVisible(true);
        }
    }

    private void layoutTree(boolean expandNodes) {
        TreeMap<String, List<ModuleDescription>> availableModules = HortonmachineModulesManager.getInstance().getModulesMap();
        List<ViewerFolder> viewerFolders = ViewerFolder.hashmap2ViewerFolders(availableModules, this._filterField.getText(), this._loadExperimentalCheckbox.isSelected());
        Modules modules = new Modules();
        modules.viewerFolders = viewerFolders;
        ObjectTreeModel model = new ObjectTreeModel();
        model.setRoot(modules);
        this._modulesTree.setModel(model);
        if (expandNodes) {
            this.expandAllNodes(this._modulesTree, 0, this._modulesTree.getRowCount());
        }
    }

    private void expandAllNodes(JTree tree, int startingIndex, int rowCount) {
        for (int i = startingIndex; i < rowCount; ++i) {
            tree.expandRow(i);
        }
        if (tree.getRowCount() != rowCount) {
            this.expandAllNodes(tree, rowCount, tree.getRowCount());
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public void onClose() {
        String ramLevel = this._heapCombo.getSelectedItem().toString();
        this.prefsMap.put("jgt_prefs_debug", "" + this._debugCheckbox.isSelected());
        this.prefsMap.put("jgt_prefs_heap", ramLevel);
        this.guiBridge.setSpatialToolboxPreferencesMap(this.prefsMap);
        this.removeMouseListenerFromContext(this.pPanel);
        if (this.pPanel != null) {
            this.pPanel.freeResources();
        }
    }

    private void runModuleInNewJVM(ProcessLogConsoleController logConsole) throws Exception {
        ModuleDescription module = this.pPanel.getModule();
        HashMap<String, Object> fieldName2ValueHolderMap = this.pPanel.getFieldName2ValueHolderMap();
        List<String> outputFieldNames = this.pPanel.getOutputFieldNames();
        final HashMap<String, String> outputStringsMap = new HashMap<String, String>();
        Class<?> moduleClass = module.getModuleClass();
        StringBuilder scriptBuilder = this.getScript(fieldName2ValueHolderMap, outputFieldNames, outputStringsMap, moduleClass);
        StageScriptExecutor exec = new StageScriptExecutor(this.guiBridge.getLibsFolder());
        exec.addProcessListener(logConsole);
        Runnable finishRunnable = new Runnable(){

            @Override
            public void run() {
                for (Map.Entry outputStringFieldEntry : outputStringsMap.entrySet()) {
                    try {
                        String value = (String)outputStringFieldEntry.getValue();
                        File file = new File(value);
                        if (!file.exists()) continue;
                        if (DataUtilities.isSupportedVectorExtension((String)value)) {
                            SpatialtoolboxController.this.loadVectorLayer(file);
                            continue;
                        }
                        if (!DataUtilities.isSupportedRasterExtension((String)value)) continue;
                        SpatialtoolboxController.this.loadRasterLayer(file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        logConsole.addFinishRunnable(finishRunnable);
        String logLevel = this._debugCheckbox.isSelected() ? SpatialToolboxConstants.LOGLEVEL_GUI_ON : SpatialToolboxConstants.LOGLEVEL_GUI_OFF;
        String ramLevel = this._heapCombo.getSelectedItem().toString();
        String sessionId = moduleClass.getSimpleName() + " " + ETimeUtilities.INSTANCE.TIMESTAMPFORMATTER_LOCAL.format(new Date());
        Process process = exec.exec(sessionId, scriptBuilder.toString(), logLevel, ramLevel, null);
        logConsole.beginProcess(process, sessionId);
    }

    private StringBuilder getScript(HashMap<String, Object> fieldName2ValueHolderMap, List<String> outputFieldNames, HashMap<String, String> outputStringsMap, Class<?> moduleClass) {
        Field[] fields;
        String canonicalName = moduleClass.getCanonicalName();
        String simpleName = moduleClass.getSimpleName();
        String objectName = "_" + simpleName.toLowerCase();
        StringBuilder scriptBuilder = new StringBuilder();
        scriptBuilder.append(canonicalName).append(" ").append(objectName).append(" = new ").append(canonicalName).append("();\n");
        for (Map.Entry<String, Object> entry : fieldName2ValueHolderMap.entrySet()) {
            try {
                String fieldName = entry.getKey();
                String value = this.stringFromObject(entry.getValue());
                if (value.trim().length() == 0) continue;
                value = FileUtilities.replaceBackSlashesWithSlashes((String)value);
                scriptBuilder.append(objectName).append(".").append(fieldName).append(" = ");
                Field field = moduleClass.getField(fieldName);
                field.setAccessible(true);
                Class<Object> type = field.getType();
                if (type.isAssignableFrom(String.class)) {
                    scriptBuilder.append("\"\"\"").append(value).append("\"\"\"");
                    if (outputFieldNames.contains(fieldName)) {
                        outputStringsMap.put(fieldName, value);
                    }
                } else if (type.isAssignableFrom(Double.TYPE)) {
                    scriptBuilder.append(value);
                } else if (type.isAssignableFrom(Double.class)) {
                    scriptBuilder.append(value);
                } else if (type.isAssignableFrom(Integer.TYPE)) {
                    scriptBuilder.append(value);
                } else if (type.isAssignableFrom(Integer.class)) {
                    scriptBuilder.append(value);
                } else if (type.isAssignableFrom(Long.TYPE)) {
                    scriptBuilder.append(value);
                } else if (type.isAssignableFrom(Long.class)) {
                    scriptBuilder.append(value);
                } else if (type.isAssignableFrom(Float.TYPE)) {
                    scriptBuilder.append(value);
                } else if (type.isAssignableFrom(Float.class)) {
                    scriptBuilder.append(value);
                } else if (type.isAssignableFrom(Short.TYPE)) {
                    scriptBuilder.append(value);
                } else if (type.isAssignableFrom(Short.class)) {
                    scriptBuilder.append(value);
                } else if (type.isAssignableFrom(Boolean.TYPE)) {
                    scriptBuilder.append(value);
                } else if (type.isAssignableFrom(Boolean.class)) {
                    scriptBuilder.append(value);
                } else {
                    Logger.INSTANCE.insertInfo("", "NOT SUPPORTED TYPE: " + type);
                }
                scriptBuilder.append(";\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        scriptBuilder.append(objectName).append(".process();\n");
        scriptBuilder.append("println \"\"\n");
        scriptBuilder.append("println \"\"\n");
        for (Field field : fields = moduleClass.getDeclaredFields()) {
            try {
                if (!field.isAnnotationPresent(Out.class)) continue;
                String fieldName = field.getName();
                field.setAccessible(true);
                Class<?> type = field.getType();
                this.dumpSimpleOutputs(objectName, type, fieldName, scriptBuilder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return scriptBuilder;
    }

    private void dumpSimpleOutputs(String objectName, Class<?> type, String fieldName, StringBuilder scriptSb) {
        scriptSb.append("println \"\"\n");
        scriptSb.append("println \"\"\n");
        if (type.isAssignableFrom(String.class) || type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class) || type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class) || type.isAssignableFrom(Float.TYPE) || type.isAssignableFrom(Float.class) || type.isAssignableFrom(Short.TYPE) || type.isAssignableFrom(Short.class) || type.isAssignableFrom(Boolean.TYPE) || type.isAssignableFrom(Boolean.class)) {
            scriptSb.append("println \"");
            scriptSb.append(fieldName);
            scriptSb.append(" = \" + ");
            scriptSb.append(objectName).append(".").append(fieldName);
            scriptSb.append("\n");
        }
        scriptSb.append("println \"\"\n\n");
        if (type.isAssignableFrom(double[][].class) || type.isAssignableFrom(float[][].class) || type.isAssignableFrom(int[][].class)) {
            String ifString = "if( " + objectName + "." + fieldName + " != null ) {\n";
            scriptSb.append(ifString);
            String typeStr = null;
            if (type.isAssignableFrom(double[][].class)) {
                typeStr = "double[][]";
            } else if (type.isAssignableFrom(float[][].class)) {
                typeStr = "float[][]";
            } else if (type.isAssignableFrom(int[][].class)) {
                typeStr = "int[][]";
            }
            scriptSb.append("println \"");
            scriptSb.append(fieldName);
            scriptSb.append("\"\n");
            scriptSb.append("println \"-----------------------------------\"\n");
            scriptSb.append(typeStr);
            scriptSb.append(" matrix = ");
            scriptSb.append(objectName + "." + fieldName);
            scriptSb.append("\n");
            scriptSb.append("for( int i = 0; i < matrix.length; i++ ) {\n");
            scriptSb.append("for( int j = 0; j < matrix[0].length; j++ ) {\n");
            scriptSb.append("print matrix[i][j] + \" \";\n");
            scriptSb.append("}\n");
            scriptSb.append("println \" \";\n");
            scriptSb.append("}\n");
            scriptSb.append("}\n");
            scriptSb.append("\n");
        } else if (type.isAssignableFrom(double[].class) || type.isAssignableFrom(float[].class) || type.isAssignableFrom(int[].class)) {
            String ifString = "if( " + objectName + "." + fieldName + " != null ) {\n";
            scriptSb.append(ifString);
            String typeStr = null;
            if (type.isAssignableFrom(double[].class)) {
                typeStr = "double[]";
            } else if (type.isAssignableFrom(float[].class)) {
                typeStr = "float[]";
            } else if (type.isAssignableFrom(int[].class)) {
                typeStr = "int[]";
            }
            scriptSb.append("println \"");
            scriptSb.append(fieldName);
            scriptSb.append("\"\n");
            scriptSb.append("println \"-----------------------------------\"\n");
            scriptSb.append(typeStr);
            scriptSb.append(" array = ");
            scriptSb.append(objectName);
            scriptSb.append(".");
            scriptSb.append(fieldName);
            scriptSb.append("\n");
            scriptSb.append("for( int i = 0; i < array.length; i++ ) {\n");
            scriptSb.append("println array[i] + \" \";\n");
            scriptSb.append("}\n");
            scriptSb.append("}\n");
            scriptSb.append("\n");
        }
        scriptSb.append("println \" \"\n\n");
    }

    public static Method getMethodAnnotatedWith(Class<?> klass, Class<? extends Annotation> annotation) {
        Method[] allMethods;
        for (Method method : allMethods = klass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(annotation)) continue;
            return method;
        }
        return null;
    }

    private String stringFromObject(Object value) throws Exception {
        if (value instanceof JTextField) {
            JTextField tf = (JTextField)value;
            return tf.getText();
        }
        if (value instanceof JTextArea) {
            JTextArea tf = (JTextArea)value;
            return tf.getText();
        }
        if (value instanceof JCheckBox) {
            JCheckBox tf = (JCheckBox)value;
            return tf.isSelected() ? "true" : "false";
        }
        if (value instanceof JComboBox) {
            JComboBox tf = (JComboBox)value;
            String comboItem = tf.getSelectedItem().toString();
            String layersString = this.getFromLayers(comboItem);
            if (layersString != null) {
                return layersString;
            }
            return comboItem;
        }
        return null;
    }

    protected String getFromLayers(String comboItem) {
        return null;
    }

    protected void addMouseListenerToContext(MouseListener mouseListener) {
    }

    protected void removeMouseListenerFromContext(MouseListener mouseListener) {
    }

    public void isVisibleTriggered() {
    }

    protected void loadRasterLayer(File file) {
    }

    protected void loadVectorLayer(File file) {
    }

    @Override
    public boolean canCloseWithoutPrompt() {
        return false;
    }

    public static void main(String[] args) throws Exception {
        GuiUtilities.setDefaultLookAndFeel();
        File libsFile = null;
        try {
            String libsPath = args[0];
            libsFile = new File(libsPath);
        }
        catch (Exception libsPath) {
            // empty catch block
        }
        if (libsFile == null || !libsFile.exists() || !libsFile.isDirectory()) {
            Logger.INSTANCE.insertWarning("", "The libraries folder is missing or not properly set.");
            libsFile = new File("/home/hydrologis/development/hortonmachine-git/extras/deploy/libs");
            if (!libsFile.exists()) {
                libsFile = new File("/Users/hydrologis/development/hortonmachine-git/extras/deploy/libs");
            }
        }
        Logger.INSTANCE.insertInfo("", "Libraries folder used: " + libsFile.getAbsolutePath());
        HortonmachineModulesManager.getInstance().init();
        DefaultGuiBridgeImpl gBridge = new DefaultGuiBridgeImpl();
        gBridge.setLibsFolder(libsFile);
        SpatialtoolboxController controller = new SpatialtoolboxController(gBridge);
        JFrame frame = gBridge.showWindow(controller.asJComponent(), "The HortonMachine Spatial Toolbox");
        GuiUtilities.setDefaultFrameIcon(frame);
        GuiUtilities.addClosingListener(frame, controller);
    }

    class ObjectTreeModel
    implements TreeModel {
        private Modules root = null;
        private EventListenerList listenerList = new EventListenerList();

        public void setRoot(Modules v) {
            Modules oldRoot = v;
            this.root = v;
            this.fireTreeStructureChanged(oldRoot);
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof Modules) {
                Modules modules = (Modules)parent;
                return modules.viewerFolders.size();
            }
            if (parent instanceof ViewerFolder) {
                ViewerFolder folder = (ViewerFolder)parent;
                return folder.getModules().size() + folder.getSubFolders().size();
            }
            if (parent instanceof List) {
                List list = (List)parent;
                return list.size();
            }
            return 0;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof Modules) {
                Modules modules = (Modules)parent;
                return modules.viewerFolders.get(index);
            }
            if (parent instanceof ViewerFolder) {
                ViewerFolder folder = (ViewerFolder)parent;
                int modulesSize = folder.getModules().size();
                if (index < modulesSize) {
                    return folder.getModules().get(index);
                }
                return folder.getSubFolders().get(index -= modulesSize);
            }
            if (parent instanceof List) {
                List list = (List)parent;
                Object item = list.get(index);
                return item;
            }
            return null;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            int n = this.getChildCount(parent);
            for (int i = 0; i < n; ++i) {
                if (!this.getChild(parent, i).equals(child)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getChildCount(node) == 0;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(TreeModelListener.class, l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(TreeModelListener.class, l);
        }

        protected void fireTreeStructureChanged(Object oldRoot) {
            TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{oldRoot});
            EventListener[] listeners = this.listenerList.getListeners(TreeModelListener.class);
            for (int i = 0; i < listeners.length; ++i) {
                ((TreeModelListener)listeners[i]).treeStructureChanged(event);
            }
        }
    }

    class Modules {
        List<ViewerFolder> viewerFolders;

        Modules() {
        }

        public String toString() {
            if (this.viewerFolders != null && !this.viewerFolders.isEmpty()) {
                return "Modules";
            }
            return "No modules found";
        }
    }
}

