/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.settings;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.io.File;
import java.nio.charset.Charset;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.hortonmachine.dbs.log.Logger;
import org.hortonmachine.dbs.log.PreferencesDb;
import org.hortonmachine.dbs.utils.DbsUtilities;
import org.hortonmachine.gears.utils.PreferencesHandler;
import org.hortonmachine.gui.settings.SettingsView;
import org.hortonmachine.gui.utils.DefaultGuiBridgeImpl;
import org.hortonmachine.gui.utils.GuiUtilities;
import org.hortonmachine.gui.utils.ImageCache;
import org.hortonmachine.ssh.ProxyEnabler;
import org.hortonmachine.ssh.SshUtilities;

public class SettingsController
extends SettingsView
implements GuiUtilities.IOnCloseListener {
    public SettingsController() {
        this.setPreferredSize(new Dimension(900, 400));
        this.fillFromPreferences();
    }

    private void fillFromPreferences() {
        String proxyCheck = PreferencesHandler.getPreference((String)"hm_pref_proxycheck", (String)"false");
        String proxyHost = PreferencesHandler.getPreference((String)"hm_pref_proxyhost", (String)"");
        String proxyPort = PreferencesHandler.getPreference((String)"hm_pref_proxyport", (String)"");
        String proxyUser = PreferencesHandler.getPreference((String)"hm_pref_proxyuser", (String)"");
        String proxyPwd = PreferencesHandler.getPreference((String)"hm_pref_proxypwd", (String)"");
        this._proxyCheckbox.setSelected(Boolean.parseBoolean(proxyCheck));
        this._proxyHostField.setText(proxyHost);
        this._proxyPortField.setText(proxyPort);
        this._proxyUserField.setText(proxyUser);
        this._proxyPasswordField.setText(proxyPwd);
        String shpCharset = PreferencesHandler.getPreference((String)"hm_pref_shp_charset", (String)"");
        this._charsetTextField.setText(shpCharset);
        ComponentOrientation co = PreferencesHandler.getComponentOrientation();
        this._orientationCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"LEFT_TO_RIGHT", "RIGHT_TO_LEFT"}));
        this._orientationCombo.setSelectedItem(co.isLeftToRight() ? "LEFT_TO_RIGHT" : "RIGHT_TO_LEFT");
        this._orientationCombo.addActionListener(e -> {
            String selection = (String)this._orientationCombo.getSelectedItem();
            if (selection != null) {
                PreferencesHandler.saveComponentOrientation((String)selection);
            }
        });
        GuiUtilities.setFolderBrowsingOnWidgets(this._preferencesDbPAth, this._preferencesDbButton, null);
        Preferences preferences = Preferences.userRoot().node("/org/hortonmachine/dbs");
        File baseFolder = PreferencesDb.getBaseFolder();
        String folderPath = preferences.get("hm_pref_preffolder", baseFolder.getAbsolutePath());
        this._preferencesDbPAth.setText(folderPath);
        String sshKeyPath = SshUtilities.getPreference((String)"HM_SSH_TOOLS_SSHKEYPATH", (String)"");
        this._sshKeyPathField.setText(sshKeyPath);
        GuiUtilities.setFileBrowsingOnWidgets(this._sshKeyPathField, this._sshKeyButton, null, null);
        String sshKeyPassphrase = SshUtilities.getPreference((String)"HM_SSH_TOOLS_SSHKEYPASSPHRASE", (String)"");
        this._sshKeyPassphraseField.setText(sshKeyPassphrase);
        String spatialiteLibsFolder = DbsUtilities.getPreference((String)"SPATIALITE_DYLIB_FOLDER", (String)"");
        this._spatialiteModPathField.setText(spatialiteLibsFolder);
        GuiUtilities.setFolderBrowsingOnWidgets(this._spatialiteModPathField, this._spatialiteModButton, null);
    }

    private void applySettingsAndSavePreferences() throws Exception {
        String sshPath;
        File sshFile;
        String folderPath;
        String charset = this._charsetTextField.getText();
        if (charset.trim().length() != 0) {
            if (!Charset.isSupported(charset)) {
                GuiUtilities.showWarningMessage(this, "Unsupported charset: " + charset);
            } else {
                PreferencesHandler.setPreference((String)"hm_pref_shp_charset", (String)charset);
            }
        } else {
            PreferencesHandler.setPreference((String)"hm_pref_shp_charset", (String)"");
        }
        boolean proxySelected = this._proxyCheckbox.isSelected();
        PreferencesHandler.setPreference((String)"hm_pref_proxycheck", (String)(proxySelected ? "true" : "false"));
        if (proxySelected) {
            String host = this._proxyHostField.getText();
            String port = this._proxyPortField.getText();
            String user = this._proxyUserField.getText();
            String pwd = this._proxyPasswordField.getText();
            PreferencesHandler.setPreference((String)"hm_pref_proxyhost", (String)host);
            PreferencesHandler.setPreference((String)"hm_pref_proxyport", (String)port);
            PreferencesHandler.setPreference((String)"hm_pref_proxyuser", (String)user);
            PreferencesHandler.setPreference((String)"hm_pref_proxypwd", (String)pwd);
        }
        if (new File(folderPath = this._preferencesDbPAth.getText()).exists()) {
            Preferences preferences = Preferences.userRoot().node("/org/hortonmachine/dbs");
            preferences.put("hm_pref_preffolder", folderPath);
        }
        if ((sshFile = new File(sshPath = this._sshKeyPathField.getText().trim())).exists() && sshFile.isFile()) {
            SshUtilities.setPreference((String)"HM_SSH_TOOLS_SSHKEYPATH", (String)sshPath);
        }
        String sshKeyPassphrase = this._sshKeyPassphraseField.getText().trim();
        SshUtilities.setPreference((String)"HM_SSH_TOOLS_SSHKEYPASSPHRASE", (String)sshKeyPassphrase);
        String spatialiteModField = this._spatialiteModPathField.getText();
        if (new File(spatialiteModField).exists() && new File(spatialiteModField).isDirectory()) {
            DbsUtilities.setPreference((String)"SPATIALITE_DYLIB_FOLDER", (String)spatialiteModField);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public boolean canCloseWithoutPrompt() {
        return true;
    }

    @Override
    public void onClose() {
        try {
            this.applySettingsAndSavePreferences();
        }
        catch (Exception e) {
            Logger.INSTANCE.insertError("SettingsController", "An error occurred while saving the settings", (Throwable)e);
        }
    }

    public static void applySettings(Component component) {
        String doProxy = PreferencesHandler.getPreference((String)"hm_pref_proxycheck", (String)"false");
        if (Boolean.parseBoolean(doProxy)) {
            String host = PreferencesHandler.getPreference((String)"hm_pref_proxyhost", (String)"");
            String port = PreferencesHandler.getPreference((String)"hm_pref_proxyport", (String)"");
            String user = PreferencesHandler.getPreference((String)"hm_pref_proxyuser", (String)"");
            String pwd = PreferencesHandler.getPreference((String)"hm_pref_proxypwd", (String)"");
            ProxyEnabler.enableProxy((String)host, (String)port, (String)user, (String)pwd, (String)"");
        }
        if (component != null) {
            ComponentOrientation co = PreferencesHandler.getComponentOrientation();
            GuiUtilities.applyComponentOrientation(component, co);
        }
    }

    public static void onCloseHandleSettings() {
    }

    public static void main(String[] args) throws Exception {
        GuiUtilities.setDefaultLookAndFeel();
        DefaultGuiBridgeImpl gBridge = new DefaultGuiBridgeImpl();
        SettingsController controller = new SettingsController();
        SettingsController.applySettings(controller);
        JFrame frame = gBridge.showWindow(controller.asJComponent(), "HortonMachine Settings");
        frame.setIconImage(ImageCache.getBuffered("hm150.png"));
        GuiUtilities.addClosingListener(frame, controller);
    }
}

