/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.hortonmachine.gears.utils.OsCheck;

public class GuiUtilities {
    public static final String LAST_PATH = "KEY_LAST_PATH";
    public static final String PREF_STRING_SEPARATORS = "@@@@";

    public static void centerOnScreen(Component component) {
        Dimension prefSize = component.getPreferredSize();
        Point parentLocation = new Point(0, 0);
        Dimension parentSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = parentLocation.x + (parentSize.width - prefSize.width) / 2;
        int y = parentLocation.y + (parentSize.height - prefSize.height) / 2;
        component.setLocation(x, y);
    }

    public static File getLastFile() {
        String userHome;
        Preferences preferences = Preferences.userRoot().node("/org/hortonmachine/gui");
        String lastPath = preferences.get(LAST_PATH, userHome = System.getProperty("user.home"));
        File file = new File(lastPath);
        if (!file.exists()) {
            return new File(userHome);
        }
        return file;
    }

    public static void setLastPath(String lastPath) {
        File file = new File(lastPath);
        if (!file.isDirectory()) {
            lastPath = file.getParentFile().getAbsolutePath();
        }
        Preferences preferences = Preferences.userRoot().node("/org/hortonmachine/gui");
        preferences.put(LAST_PATH, lastPath);
    }

    public static String getPreference(String preferenceKey, String defaultValue) {
        Preferences preferences = Preferences.userRoot().node("/org/hortonmachine/gui");
        String preference = preferences.get(preferenceKey, defaultValue);
        return preference;
    }

    public static String[] getPreference(String preferenceKey, String[] defaultValue) {
        Preferences preferences = Preferences.userRoot().node("/org/hortonmachine/gui");
        String preference = preferences.get(preferenceKey, "");
        String[] split = preference.split(PREF_STRING_SEPARATORS);
        return split;
    }

    public static void setPreference(String preferenceKey, String value) {
        Preferences preferences = Preferences.userRoot().node("/org/hortonmachine/gui");
        if (value != null) {
            preferences.put(preferenceKey, value);
        } else {
            preferences.remove(preferenceKey);
        }
    }

    public static void setPreference(String preferenceKey, String[] valuesArray) {
        Preferences preferences = Preferences.userRoot().node("/org/hortonmachine/gui");
        if (valuesArray != null) {
            String arrayToString = Stream.of(valuesArray).collect(Collectors.joining(PREF_STRING_SEPARATORS));
            preferences.put(preferenceKey, arrayToString);
        } else {
            preferences.remove(preferenceKey);
        }
    }

    public static void copyToClipboard(String text) {
        StringSelection selection = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    public static void openFile(File file) throws IOException {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            desktop.open(file);
        }
    }

    public static JDialog openDialogWithPanel(JPanel panel, String title, Dimension dimension) {
        JDialog f = new JDialog();
        f.add((Component)panel, "Center");
        f.setTitle(title);
        f.pack();
        if (dimension != null) {
            f.setSize(dimension);
        }
        f.setLocationRelativeTo(null);
        f.setVisible(true);
        f.setDefaultCloseOperation(2);
        return f;
    }

    public static String showInputDialog(Component parentComponent, String message, String defaultInput) {
        String answer = JOptionPane.showInputDialog(parentComponent, message, defaultInput);
        return answer;
    }

    public static String[] showMultiInputDialog(Component parentComponent, String title, String[] labels, String[] defaultValues, HashMap<String, String[]> fields2ValuesMap) {
        Component[] valuesFields = new Component[labels.length];
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String[] input = new String[labels.length];
        panel.setLayout(new GridLayout(labels.length, 2, 5, 5));
        for (int i = 0; i < labels.length; ++i) {
            String[] values;
            panel.add(new JLabel(labels[i]));
            boolean doneCombo = false;
            if (fields2ValuesMap != null && (values = fields2ValuesMap.get(labels[i])) != null) {
                JComboBox<String> valuesCombo;
                valuesFields[i] = valuesCombo = new JComboBox<String>(values);
                panel.add(valuesCombo);
                if (defaultValues != null) {
                    valuesCombo.setSelectedItem(defaultValues[i]);
                }
                doneCombo = true;
            }
            if (doneCombo) continue;
            valuesFields[i] = new JTextField();
            panel.add(valuesFields[i]);
            if (defaultValues == null) continue;
            ((JTextField)valuesFields[i]).setText(defaultValues[i]);
        }
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setPreferredSize(new Dimension(550, 300));
        int result = JOptionPane.showConfirmDialog(parentComponent, scrollPane, title, 2);
        if (result != 0) {
            return null;
        }
        for (int i = 0; i < labels.length; ++i) {
            if (valuesFields[i] instanceof JTextField) {
                JTextField textField = (JTextField)valuesFields[i];
                input[i] = textField.getText();
            }
            if (!(valuesFields[i] instanceof JComboBox)) continue;
            JComboBox combo = (JComboBox)valuesFields[i];
            input[i] = combo.getSelectedItem().toString();
        }
        return input;
    }

    public static String showComboDialog(Component parentComponent, String title, String message, String[] values) {
        String result = (String)JOptionPane.showInputDialog(parentComponent, message, title, 3, null, values, values[0]);
        return result;
    }

    public static void setDefaultLookAndFeel() {
        try {
            String name;
            OsCheck.OSType osType = OsCheck.getOperatingSystemType();
            switch (osType) {
                case Windows: {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        name = info.getName();
                        if (!"Windows".equalsIgnoreCase(name)) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        return;
                    }
                }
                case Linux: {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        name = info.getName();
                        if (!"GTK".equalsIgnoreCase(name) && !"GTK+".equalsIgnoreCase(name)) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        return;
                    }
                    break;
                }
            }
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                name = info.getName();
                if (!"Nimbus".equalsIgnoreCase(name)) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addClosingListener(final JFrame frame, final IOnCloseListener freeResourcesComponent) {
        WindowAdapter exitListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int confirm = JOptionPane.showOptionDialog(frame, "Are you sure you want to exit?", "Exit Confirmation", 0, 3, null, null, null);
                if (confirm == 0) {
                    freeResourcesComponent.onClose();
                    System.exit(0);
                }
            }
        };
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(exitListener);
    }

    public static void showInfoMessage(Component parentComponent, String title, String message) {
        if (title == null) {
            title = "INFO";
        }
        JOptionPane.showMessageDialog(parentComponent, message, title, 1);
    }

    public static void showWarningMessage(Component parentComponent, String title, String message) {
        if (title == null) {
            title = "WARNING";
        }
        JOptionPane.showMessageDialog(parentComponent, message, title, 2);
    }

    public static void showErrorMessage(Component parentComponent, String title, String message) {
        if (title == null) {
            title = "ERROR";
        }
        JOptionPane.showMessageDialog(parentComponent, message, title, 0);
    }

    public static interface IOnCloseListener {
        public void onClose();
    }
}

