/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.spatialtoolbox.core;

import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oms3.Access;
import oms3.ComponentAccess;
import oms3.annotations.Description;
import oms3.annotations.Label;
import oms3.annotations.Range;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.Modules;
import org.hortonmachine.dbs.log.Logger;
import org.hortonmachine.gears.JGrassGears;
import org.hortonmachine.gui.spatialtoolbox.core.AnnotationUtilities;
import org.hortonmachine.gui.spatialtoolbox.core.ModuleDescription;
import org.hortonmachine.hmachine.HortonMachine;
import org.hortonmachine.lesto.Lesto;

public class HortonmachineModulesManager {
    private static HortonmachineModulesManager modulesManager;
    private List<String> loadedJarsList = new ArrayList<String>();
    private List<String> modulesJarsList = new ArrayList<String>();
    private TreeMap<String, List<ModuleDescription>> modulesMap = new TreeMap();
    private URLClassLoader jarClassloader;

    private HortonmachineModulesManager() {
    }

    public static synchronized HortonmachineModulesManager getInstance() {
        if (modulesManager == null) {
            modulesManager = new HortonmachineModulesManager();
        }
        return modulesManager;
    }

    public TreeMap<String, List<ModuleDescription>> getModulesMap() {
        return this.modulesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        String name;
        TreeMap<String, List<ModuleDescription>> treeMap = this.modulesMap;
        synchronized (treeMap) {
            if (this.modulesMap.size() > 0) {
                return;
            }
        }
        LinkedHashMap moduleNames2Classes = Modules.getInstance().moduleName2Class;
        LinkedHashMap lestoModuleNames2Class = Lesto.getInstance().moduleName2Class;
        Logger.INSTANCE.insertDebug("", "init HortonMachine");
        HortonMachine.getInstance();
        Logger.INSTANCE.insertDebug("", "init JGrassGears");
        Map gearsModuleName2Class = JGrassGears.getInstance().moduleName2Class;
        Logger.INSTANCE.insertDebug("", "Collecting classes:");
        for (Map.Entry entry : lestoModuleNames2Class.entrySet()) {
            name = (String)entry.getKey();
            if (name.startsWith("Oms")) continue;
            Logger.INSTANCE.insertDebug("", "\t-> " + name);
            moduleNames2Classes.put(name, entry.getValue());
        }
        for (Map.Entry entry : gearsModuleName2Class.entrySet()) {
            name = (String)entry.getKey();
            if (name.startsWith("Oms")) continue;
            Logger.INSTANCE.insertDebug("", "\t-> " + name);
            moduleNames2Classes.put(name, entry.getValue());
        }
        Collection classesList = moduleNames2Classes.values();
        for (Class moduleClass : classesList) {
            try {
                Object access2;
                String uiHintStr;
                String simpleName = moduleClass.getSimpleName();
                UI uiHints = moduleClass.getAnnotation(UI.class);
                if (uiHints != null && (uiHintStr = uiHints.value()).contains("hide")) continue;
                Label category = moduleClass.getAnnotation(Label.class);
                String categoryStr = "Others";
                if (category != null && categoryStr.trim().length() > 1) {
                    categoryStr = category.value();
                }
                Description description = moduleClass.getAnnotation(Description.class);
                String descrStr = null;
                if (description != null) {
                    descrStr = description.value();
                }
                Status status = moduleClass.getAnnotation(Status.class);
                ModuleDescription module = new ModuleDescription(moduleClass, categoryStr, descrStr, status);
                Object newInstance = null;
                try {
                    newInstance = moduleClass.newInstance();
                }
                catch (Throwable e) {
                    continue;
                }
                try {
                    String e = module.getClassName();
                }
                catch (Exception e) {
                    // empty catch block
                }
                ComponentAccess cA = new ComponentAccess(newInstance);
                Collection inputs = cA.inputs();
                for (Object access2 : inputs) {
                    this.addInput((Access)access2, module);
                }
                Collection outputs = cA.outputs();
                access2 = outputs.iterator();
                while (access2.hasNext()) {
                    Access access3 = (Access)access2.next();
                    this.addOutput(access3, module);
                }
                if (categoryStr.equals("Grid Geometry Reader") || categoryStr.equals("Raster Reader") || categoryStr.equals("Raster Writer") || categoryStr.equals("Vector Reader") || categoryStr.equals("Vector Writer") || categoryStr.equals("Generic Reader") || categoryStr.equals("Generic Writer") || categoryStr.equals("HashMap Data Reader") || categoryStr.equals("HashMap Data Writer") || categoryStr.equals("List Data Reader") || categoryStr.equals("List Data Writer")) continue;
                List<ModuleDescription> modulesList4Category = this.modulesMap.get(categoryStr);
                if (modulesList4Category == null) {
                    modulesList4Category = new ArrayList<ModuleDescription>();
                    this.modulesMap.put(categoryStr, modulesList4Category);
                }
                modulesList4Category.add(module);
            }
            catch (NoClassDefFoundError e) {
                if (moduleClass == null) continue;
                Logger.INSTANCE.insertError("", "ERROR", e.getCause());
            }
        }
        Set<Map.Entry<String, List<ModuleDescription>>> entrySet = this.modulesMap.entrySet();
        for (Map.Entry<String, List<ModuleDescription>> entry : entrySet) {
            Collections.sort(entry.getValue(), new ModuleDescription.ModuleDescriptionNameComparator());
        }
    }

    private void addInput(Access access, ModuleDescription module) throws Exception {
        Range rangeAnn;
        Field field = access.getField();
        Description descriptionAnn = field.getAnnotation(Description.class);
        String descriptionStr = "No description available";
        if (descriptionAnn != null) {
            descriptionStr = AnnotationUtilities.getLocalizedDescription(descriptionAnn);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(descriptionStr);
        Unit unitAnn = field.getAnnotation(Unit.class);
        if (unitAnn != null) {
            sb.append(" [");
            sb.append(unitAnn.value());
            sb.append("]");
        }
        if ((rangeAnn = field.getAnnotation(Range.class)) != null) {
            sb.append(" [");
            sb.append(rangeAnn.min());
            sb.append(" ,");
            sb.append(rangeAnn.max());
            sb.append("]");
        }
        descriptionStr = sb.toString();
        String fieldName = field.getName();
        if (this.doIgnore(fieldName)) {
            return;
        }
        Class<?> fieldClass = field.getType();
        Object fieldValue = access.getFieldValue();
        String defaultValue = "";
        if (fieldValue != null) {
            defaultValue = fieldValue.toString();
        }
        UI uiHintAnn = field.getAnnotation(UI.class);
        String uiHint = null;
        if (uiHintAnn != null) {
            uiHint = uiHintAnn.value();
        }
        module.addInput(fieldName, fieldClass.getCanonicalName(), descriptionStr, defaultValue, uiHint);
    }

    private boolean doIgnore(String fieldName) {
        return fieldName.equals("doProcess");
    }

    private void addOutput(Access access, ModuleDescription module) throws Exception {
        Range rangeAnn;
        Field field = access.getField();
        Description descriptionAnn = field.getAnnotation(Description.class);
        String descriptionStr = "No description available";
        if (descriptionAnn != null) {
            descriptionStr = AnnotationUtilities.getLocalizedDescription(descriptionAnn);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(descriptionStr);
        Unit unitAnn = field.getAnnotation(Unit.class);
        if (unitAnn != null) {
            sb.append(" [");
            sb.append(unitAnn.value());
            sb.append("]");
        }
        if ((rangeAnn = field.getAnnotation(Range.class)) != null) {
            sb.append(" [");
            sb.append(rangeAnn.min());
            sb.append(" ,");
            sb.append(rangeAnn.max());
            sb.append("]");
        }
        descriptionStr = sb.toString();
        String fieldName = field.getName();
        if (this.doIgnore(fieldName)) {
            return;
        }
        Class<?> fieldClass = field.getType();
        Object fieldValue = access.getFieldValue();
        String defaultValue = "";
        if (fieldValue != null) {
            defaultValue = fieldValue.toString();
        }
        UI uiHintAnn = field.getAnnotation(UI.class);
        String uiHint = null;
        if (uiHintAnn != null) {
            uiHint = uiHintAnn.value();
        }
        module.addOutput(fieldName, fieldClass.getCanonicalName(), descriptionStr, defaultValue, uiHint);
    }
}

