/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.spatialtoolbox.core;

import groovy.ui.GroovyMain;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hortonmachine.dbs.log.Logger;
import org.hortonmachine.gears.libs.exceptions.ModelsUserCancelException;
import org.hortonmachine.gears.utils.processes.ELogStyle;
import org.hortonmachine.gears.utils.processes.IProcessListener;
import org.hortonmachine.gui.console.ConsoleMessageFilter;
import org.hortonmachine.gui.spatialtoolbox.core.SpatialToolboxConstants;

public class StageScriptExecutor {
    public static final String ORG_HORTONMACHINE_MODULES = "org.hortonmachine.modules";
    private List<IProcessListener> listeners = new ArrayList<IProcessListener>();
    private String classPath;
    private boolean isRunning = false;
    private String javaExec;
    private static String nl = "\n";
    private StringBuilder logBuilder = new StringBuilder();

    public StageScriptExecutor(File jgtLibsFolder) throws Exception {
        File[] groovyJarFiles;
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            File java = new File(javaHome, "bin/java");
            this.javaExec = java.exists() ? java.getAbsolutePath() : ((java = new File(javaHome, "bin/java.exe")).exists() ? java.getAbsolutePath() : null);
        }
        if (this.javaExec == null) {
            this.javaExec = "java";
        }
        if ((groovyJarFiles = jgtLibsFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().contains("groovy-");
            }
        })) != null && groovyJarFiles.length > 0) {
            String classpathJars;
            String groovyFiles = "";
            for (File file : groovyJarFiles) {
                groovyFiles = groovyFiles + file.getAbsolutePath() + File.pathSeparator;
            }
            this.classPath = classpathJars = "\"" + groovyFiles + jgtLibsFolder.getAbsolutePath() + "/*" + File.pathSeparator + ".\"";
        } else {
            this.classPath = "\"." + File.pathSeparator + jgtLibsFolder.getAbsolutePath() + File.separatorChar + "*\"";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process exec(String sessionId, String script, final String loggerLevelGui, String ramLevel, String encoding) throws Exception {
        String tempdir;
        File omsTmp;
        File scriptFile = new File(script);
        if (!scriptFile.exists()) {
            scriptFile = File.createTempFile("hm_script_", ".groovy");
            try (BufferedWriter bw = null;){
                bw = new BufferedWriter(new FileWriter(scriptFile));
                bw.write(script);
            }
        }
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = null;){
            br = new BufferedReader(new FileReader(scriptFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line).append(nl);
            }
        }
        script = sb.toString();
        if (!(omsTmp = new File((tempdir = System.getProperty("java.io.tmpdir")) + File.separator + "oms")).exists()) {
            omsTmp.mkdirs();
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.javaExec);
        String ramExpr = "-Xmx" + ramLevel + "m";
        arguments.add(ramExpr);
        if (encoding != null && encoding.length() > 0) {
            encoding = "-Dfile.encoding=" + encoding;
            arguments.add(encoding);
        }
        arguments.add("-cp");
        arguments.add(this.classPath);
        arguments.add(GroovyMain.class.getCanonicalName());
        arguments.add(scriptFile.getAbsolutePath());
        Logger.INSTANCE.insertDebug("", "Execution arguments:");
        for (String arg : arguments) {
            Logger.INSTANCE.insertDebug("", arg);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        final Process process = processBuilder.start();
        this.logBuilder.setLength(0);
        StringBuilder preCommentsBuilder = new StringBuilder();
        String processName = "Process started: " + SpatialToolboxConstants.dateTimeFormatterYYYYMMDDHHMMSS.format(new Date());
        preCommentsBuilder.append(processName);
        preCommentsBuilder.append(nl);
        if (loggerLevelGui.equals(SpatialToolboxConstants.LOGLEVEL_GUI_ON)) {
            preCommentsBuilder.append("------------------------------>8----------------------------" + nl);
            preCommentsBuilder.append("Launching command: " + nl);
            preCommentsBuilder.append("------------------" + nl);
            List<String> command = processBuilder.command();
            for (String arg : command) {
                preCommentsBuilder.append(arg);
                preCommentsBuilder.append(" ");
            }
            preCommentsBuilder.append("" + nl);
            preCommentsBuilder.append("(you can run the above from command line, customizing the content)" + nl);
            preCommentsBuilder.append("----------------------------------->8---------------------------------" + nl);
            preCommentsBuilder.append("" + nl);
            preCommentsBuilder.append("Script run: " + nl);
            preCommentsBuilder.append("-----------" + nl);
            preCommentsBuilder.append(script);
            preCommentsBuilder.append("" + nl);
            preCommentsBuilder.append("------------------------------>8----------------------------" + nl);
            preCommentsBuilder.append("" + nl);
        }
        this.printMessage(preCommentsBuilder.toString(), ELogStyle.COMMENT);
        this.isRunning = true;
        new Thread("StageScriptExecutor->" + processName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader br = null;
                try {
                    String line;
                    InputStream is = process.getInputStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        StageScriptExecutor.this.printMessage(line, ELogStyle.NORMAL);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StageScriptExecutor.this.printException(loggerLevelGui, e);
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    StageScriptExecutor.this.printMessage("Process finished: " + SpatialToolboxConstants.dateTimeFormatterYYYYMMDDHHMMSS.format(new Date()), ELogStyle.COMMENT);
                    StageScriptExecutor.this.isRunning = false;
                    StageScriptExecutor.this.updateListenersForModuleStop();
                }
            }
        }.start();
        new Thread("StageScriptExecutor->" + processName + " -> Console printer"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader br = null;
                try {
                    String line;
                    String userCanceled = ModelsUserCancelException.class.getCanonicalName();
                    InputStream is = process.getErrorStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        if (ConsoleMessageFilter.doRemove(line)) continue;
                        if (line.startsWith(userCanceled)) {
                            line = "Process cancelled by user.";
                        }
                        StageScriptExecutor.this.printMessage(line, ELogStyle.ERROR);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StageScriptExecutor.this.printException(loggerLevelGui, e);
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }.start();
        return process;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void addProcessListener(IProcessListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeProcessListener(IProcessListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private synchronized void printMessage(String message, ELogStyle style) {
        String[] split;
        for (String string : split = message.split(nl)) {
            for (IProcessListener listener : this.listeners) {
                listener.onMessage(string, style);
            }
        }
    }

    private void updateListenersForModuleStop() {
        for (IProcessListener listener : this.listeners) {
            listener.onProcessStopped();
        }
    }

    private void printException(String loggerLevelGui, Exception e) {
        if (loggerLevelGui.equals(SpatialToolboxConstants.LOGLEVEL_GUI_ON)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.printMessage(sw.toString(), ELogStyle.ERROR);
        } else {
            this.printMessage(e.getLocalizedMessage(), ELogStyle.ERROR);
        }
    }

    public void killProcess(Process process) {
        if (process != null) {
            process.destroy();
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

