/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.io.FilenameUtils;
import org.hortonmachine.dbs.log.Logger;
import org.hortonmachine.gears.utils.OsCheck;
import org.hortonmachine.gears.utils.PreferencesHandler;
import org.hortonmachine.gui.utils.ImageCache;
import org.hortonmachine.gui.utils.ImageViewer;
import org.hortonmachine.gui.utils.RunnableWithParameters;

public class GuiUtilities {
    public static void centerOnScreen(Component component) {
        Dimension prefSize = component.getPreferredSize();
        Point parentLocation = new Point(0, 0);
        Dimension parentSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = parentLocation.x + (parentSize.width - prefSize.width) / 2;
        int y = parentLocation.y + (parentSize.height - prefSize.height) / 2;
        component.setLocation(x, y);
    }

    public static void applyComponentOrientation(Component component, ComponentOrientation co) {
        component.applyComponentOrientation(co);
    }

    public static void copyToClipboard(String text) {
        StringSelection selection = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    public static String getFromClipboard() throws Exception {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        String string = (String)clipboard.getData(DataFlavor.stringFlavor);
        return string;
    }

    public static void openFile(File file) throws IOException {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            desktop.open(file);
        }
    }

    public static JDialog openDialogWithPanel(JPanel panel, String title, Dimension dimension, boolean modal) {
        JDialog f = new JDialog();
        f.add((Component)panel, "Center");
        f.setTitle(title);
        f.setIconImage(ImageCache.getInstance().getBufferedImage("hm150.png"));
        f.setModal(modal);
        f.pack();
        if (dimension != null) {
            f.setSize(dimension);
        }
        f.setLocationRelativeTo(null);
        f.setVisible(true);
        f.setDefaultCloseOperation(2);
        f.getRootPane().registerKeyboardAction(e -> f.dispose(), KeyStroke.getKeyStroke(27, 0), 2);
        return f;
    }

    public static void openDialogWithTable(String title, String[][] dataMatrix, String[] columnNames, Dimension dimension, boolean modal) {
        JTable table = new JTable(new DefaultTableModel(dataMatrix, columnNames));
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(table);
        tablePanel.add((Component)scroll, "Center");
        GuiUtilities.openDialogWithPanel(tablePanel, title, dimension, modal);
    }

    public static boolean openConfirmDialogWithPanel(Component parentComponent, JPanel panel, String title) {
        int result = JOptionPane.showConfirmDialog(parentComponent, panel, title, 2);
        return result == 0;
    }

    public static String showInputDialog(Component parentComponent, String message, String defaultInput) {
        String answer = JOptionPane.showInputDialog(parentComponent, message, defaultInput);
        return answer;
    }

    public static boolean showYesNoDialog(Component parentComponent, String message) {
        int answer = JOptionPane.showConfirmDialog(parentComponent, message, "", 0);
        return answer == 0;
    }

    public static String[] showMultiInputDialog(Component parentComponent, String title, String[] labels, String[] defaultValues, HashMap<String, String[]> fields2ValuesMap) {
        Component[] valuesFields = new Component[labels.length];
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(900, labels.length * 70));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String[] input = new String[labels.length];
        panel.setLayout(new GridLayout(labels.length, 2, 5, 5));
        for (int i = 0; i < labels.length; ++i) {
            String[] values;
            panel.add(new JLabel(labels[i]));
            boolean doneCombo = false;
            if (fields2ValuesMap != null && (values = fields2ValuesMap.get(labels[i])) != null) {
                JComboBox<String> valuesCombo;
                valuesFields[i] = valuesCombo = new JComboBox<String>(values);
                panel.add(valuesCombo);
                if (defaultValues != null) {
                    valuesCombo.setSelectedItem(defaultValues[i]);
                }
                doneCombo = true;
            }
            if (doneCombo) continue;
            valuesFields[i] = new JTextField();
            panel.add(valuesFields[i]);
            if (defaultValues == null) continue;
            ((JTextField)valuesFields[i]).setText(defaultValues[i]);
        }
        int result = JOptionPane.showConfirmDialog(parentComponent, panel, title, 2);
        if (result != 0) {
            return null;
        }
        for (int i = 0; i < labels.length; ++i) {
            if (valuesFields[i] instanceof JTextField) {
                JTextField textField = (JTextField)valuesFields[i];
                input[i] = textField.getText();
            }
            if (!(valuesFields[i] instanceof JComboBox)) continue;
            JComboBox combo = (JComboBox)valuesFields[i];
            input[i] = combo.getSelectedItem().toString();
        }
        return input;
    }

    public static String showComboDialog(Component parentComponent, String title, String message, String[] values, String selectedValue) {
        String result = (String)JOptionPane.showInputDialog(parentComponent, message, title, 3, null, values, selectedValue != null ? selectedValue : values[0]);
        return result;
    }

    public static void setDefaultLookAndFeel() {
        try {
            String name;
            OsCheck.OSType osType = OsCheck.getOperatingSystemType();
            switch (osType) {
                case Windows: {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        name = info.getName();
                        if (!"Windows".equalsIgnoreCase(name)) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        return;
                    }
                }
                case Linux: {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        name = info.getName();
                        if (!"GTK".equalsIgnoreCase(name) && !"GTK+".equalsIgnoreCase(name)) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        return;
                    }
                    break;
                }
            }
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                name = info.getName();
                if (!"Nimbus".equalsIgnoreCase(name)) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setDefaultFrameIcon(JFrame frame) {
        GuiUtilities.setDefaultFrameIcon(frame, null);
    }

    public static void setDefaultFrameIcon(JFrame frame, Image forceIcon) {
        if (forceIcon == null) {
            forceIcon = ImageCache.getBuffered("hm150.png");
        }
        frame.setIconImage(forceIcon);
        OsCheck.OSType osType = OsCheck.getOperatingSystemType();
        if (osType == OsCheck.OSType.MacOS) {
            try {
                Class<?> classFN = Class.forName("com.apple.eawt.Application", false, null);
                Method getAppMethod = classFN.getMethod("getApplication", new Class[0]);
                Object application = getAppMethod.invoke(null, new Object[0]);
                Method setDockIconMethod = classFN.getMethod("setDockIconImage", Image.class);
                setDockIconMethod.invoke(application, forceIcon);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void addClosingListener(final JFrame frame, final IOnCloseListener onCloseListener) {
        WindowAdapter exitListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!onCloseListener.canCloseWithoutPrompt()) {
                    int confirm = JOptionPane.showOptionDialog(frame, "Are you sure you want to exit?", "Exit Confirmation", 0, 3, null, null, null);
                    if (confirm == 0) {
                        onCloseListener.onClose();
                        System.exit(0);
                    }
                } else {
                    onCloseListener.onClose();
                    System.exit(0);
                }
            }
        };
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(exitListener);
    }

    public static void showInfoMessage(Component parentComponent, String message) {
        GuiUtilities.showInfoMessage(parentComponent, null, message);
    }

    public static void showInfoMessage(Component parentComponent, String title, String message) {
        if (title == null) {
            title = "INFO";
        }
        JOptionPane.showMessageDialog(parentComponent, message, title, 1);
    }

    public static void showWarningMessage(Component parentComponent, String message) {
        GuiUtilities.showWarningMessage(parentComponent, null, message);
    }

    public static void showWarningMessage(Component parentComponent, String title, String message) {
        if (title == null) {
            title = "WARNING";
        }
        JOptionPane.showMessageDialog(parentComponent, message, title, 2);
    }

    public static void showErrorMessage(Component parentComponent, String message) {
        GuiUtilities.showErrorMessage(parentComponent, null, message);
    }

    public static void handleError(Component parentComponent, Exception e) {
        String localizedMessage = e.getLocalizedMessage();
        if (!(localizedMessage != null && localizedMessage.trim().length() != 0 || (localizedMessage = e.getMessage()) != null && localizedMessage.trim().length() != 0)) {
            localizedMessage = "A not identified error occurred. The system didn't supply any further information.";
        }
        Logger.INSTANCE.insertError("GuiUtilities", localizedMessage, (Throwable)e);
        GuiUtilities.showErrorMessage(parentComponent, "ERROR", localizedMessage);
    }

    public static void showErrorMessage(Component parentComponent, String title, String message) {
        if (title == null) {
            title = "ERROR";
        }
        JOptionPane.showMessageDialog(parentComponent, message, title, 0);
    }

    public static void showImage(Component parentComponent, String title, BufferedImage image) {
        if (title == null) {
            title = "image";
        }
        ImageViewer.show(image, title, false);
    }

    public static void colorButton(JButton button, Color color, Integer size) {
        if (size == null) {
            size = 15;
        }
        BufferedImage bi = new BufferedImage(size, size, 1);
        Graphics2D gr = (Graphics2D)bi.getGraphics();
        gr.setColor(color);
        gr.fillRect(0, 0, size, size);
        gr.dispose();
        button.setIcon(new ImageIcon(bi));
    }

    public static void setFileBrowsingOnWidgets(JTextField pathTextField, JButton browseButton, final String[] allowedExtensions, Runnable postRunnable) {
        FileFilter filter = null;
        if (allowedExtensions != null) {
            filter = new FileFilter(){

                @Override
                public String getDescription() {
                    return Arrays.toString(allowedExtensions);
                }

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String name = f.getName();
                    for (String ext : allowedExtensions) {
                        if (!name.toLowerCase().endsWith(ext.toLowerCase())) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        FileFilter _filter = filter;
        browseButton.addActionListener(e -> {
            File lastFile = PreferencesHandler.getLastFile();
            File[] res = GuiUtilities.showOpenFilesDialog(browseButton, "Select file", false, lastFile, _filter);
            if (res != null && res.length == 1) {
                String absolutePath = res[0].getAbsolutePath();
                pathTextField.setText(absolutePath);
                PreferencesHandler.setLastPath((String)absolutePath);
            } else {
                pathTextField.setText("");
            }
            if (postRunnable != null) {
                postRunnable.run();
            }
        });
    }

    public static void setFolderBrowsingOnWidgets(JTextField pathTextField, JButton browseButton, Runnable postRunnable) {
        browseButton.addActionListener(e -> {
            File lastFile = PreferencesHandler.getLastFile();
            File[] res = GuiUtilities.showOpenFolderDialog(browseButton, "Select folder", false, lastFile);
            if (res != null && res.length == 1) {
                String absolutePath = res[0].getAbsolutePath();
                pathTextField.setText(absolutePath);
                PreferencesHandler.setLastPath((String)absolutePath);
                if (postRunnable != null) {
                    postRunnable.run();
                }
            }
        });
    }

    public static File[] showOpenFilesDialog(final Component parent, final String title, final boolean multiselection, final File initialPath, final FileFilter filter) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            @Override
            public void run() {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle(title);
                fc.setDialogType(0);
                fc.setFileSelectionMode(0);
                fc.setMultiSelectionEnabled(multiselection);
                fc.setCurrentDirectory(initialPath);
                if (filter != null) {
                    fc.setFileFilter(filter);
                }
                fc.setFileHidingEnabled(false);
                int r = fc.showOpenDialog(parent);
                if (r != 0) {
                    this.returnValue = null;
                    return;
                }
                if (fc.isMultiSelectionEnabled()) {
                    File[] selectedFiles;
                    this.returnValue = selectedFiles = fc.getSelectedFiles();
                } else {
                    File selectedFile = fc.getSelectedFile();
                    if (selectedFile != null && selectedFile.exists()) {
                        PreferencesHandler.setLastPath((String)selectedFile.getAbsolutePath());
                    }
                    this.returnValue = new File[]{selectedFile};
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.INSTANCE.insertError("", "Can't show chooser dialog '" + title + "'.", (Throwable)e);
            }
        }
        return (File[])runnable.getReturnValue();
    }

    public static File showSaveFileDialog(final Component parent, final String title, final File initialPath) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            @Override
            public void run() {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle(title);
                fc.setDialogType(1);
                fc.setFileSelectionMode(0);
                fc.setCurrentDirectory(initialPath);
                fc.setFileHidingEnabled(false);
                int r = fc.showOpenDialog(parent);
                if (r != 0) {
                    this.returnValue = null;
                    return;
                }
                File selectedFile = fc.getSelectedFile();
                if (selectedFile != null && selectedFile.getParentFile().exists()) {
                    PreferencesHandler.setLastPath((String)selectedFile.getParentFile().getAbsolutePath());
                }
                this.returnValue = selectedFile;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.INSTANCE.insertError("", "Can't show chooser dialog '" + title + "'.", (Throwable)e);
            }
        }
        return (File)runnable.getReturnValue();
    }

    public static File[] showOpenFolderDialog(final Component parent, final String title, final boolean multiselection, final File initialPath) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            @Override
            public void run() {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle(title);
                fc.setDialogType(0);
                fc.setFileSelectionMode(1);
                fc.setMultiSelectionEnabled(multiselection);
                fc.setCurrentDirectory(initialPath);
                fc.setFileHidingEnabled(false);
                int r = fc.showOpenDialog(parent);
                if (r != 0) {
                    this.returnValue = null;
                    return;
                }
                if (fc.isMultiSelectionEnabled()) {
                    File[] selectedFiles;
                    this.returnValue = selectedFiles = fc.getSelectedFiles();
                } else {
                    File selectedFile = fc.getSelectedFile();
                    if (selectedFile != null && selectedFile.exists()) {
                        PreferencesHandler.setLastPath((String)selectedFile.getAbsolutePath());
                    }
                    this.returnValue = new File[]{selectedFile};
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.INSTANCE.insertError("", "Can't show chooser dialog '" + title + "'.", (Throwable)e);
            }
        }
        return (File[])runnable.getReturnValue();
    }

    public static class ShpFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return "(*.shp) Shape files";
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return FilenameUtils.getExtension((String)file.getName().toLowerCase()).endsWith("shp");
        }
    }

    public static interface IOnCloseListener {
        public void onClose();

        public boolean canCloseWithoutPrompt();
    }
}

