/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.console;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.PrintStream;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.libs.monitor.PrintStreamProgressMonitor;
import org.hortonmachine.gui.console.CustomOutputStream;
import org.hortonmachine.gui.console.LogConsoleView;
import org.hortonmachine.gui.utils.GuiUtilities;
import org.hortonmachine.gui.utils.ImageCache;
import org.joda.time.DateTime;

public class LogConsoleController
extends LogConsoleView {
    private IHMProgressMonitor pm = null;
    private String processName;
    private PrintStream logAreaPrintStream;

    public LogConsoleController(IHMProgressMonitor pm) {
        if (pm != null) {
            this.pm = pm;
        }
        this.init();
    }

    private void init() {
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    LogConsoleController.this.logArea.getDocument().remove(0, LogConsoleController.this.logArea.getDocument().getLength());
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.clearButton.setIcon(ImageCache.getInstance().getImage("trash.gif"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtilities.copyToClipboard(LogConsoleController.this.logArea.getText());
            }
        });
        this.copyButton.setIcon(ImageCache.getInstance().getImage("copy_edit.gif"));
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LogConsoleController.this.pm != null) {
                    LogConsoleController.this.pm.setCanceled(true);
                }
                LogConsoleController.this.stopButton.setEnabled(false);
            }
        });
        this.stopButton.setIcon(ImageCache.getInstance().getImage("progress_stop.gif"));
        this.logAreaPrintStream = new PrintStream(new CustomOutputStream(this.logArea));
        if (this.pm == null) {
            this.pm = new PrintStreamProgressMonitor(this.logAreaPrintStream, this.logAreaPrintStream);
        }
        System.setOut(this.logAreaPrintStream);
        System.setErr(this.logAreaPrintStream);
        this.setPreferredSize(new Dimension(480, 320));
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                LogConsoleController.this.stopLogging();
            }
        });
    }

    public PrintStream getLogAreaPrintStream() {
        return this.logAreaPrintStream;
    }

    public void beginProcess(String name) {
        this.processName = name;
        System.out.println("Process " + name + " started at: " + new DateTime().toString(HMConstants.dateTimeFormatterYYYYMMDDHHMMSS) + "\n\n");
    }

    public void finishProcess() {
        System.out.println("\n\nProcess " + this.processName + " stopped at: " + new DateTime().toString(HMConstants.dateTimeFormatterYYYYMMDDHHMMSS));
        this.stopButton.setEnabled(false);
    }

    public void stopLogging() {
        System.setOut(System.out);
        System.setErr(System.err);
    }

    public JComponent asJComponent() {
        return this;
    }

    public IHMProgressMonitor getProgressMonitor() {
        return this.pm;
    }
}

