/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils;

import com.jcraft.jsch.Session;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.hortonmachine.gears.ui.progress.ProgressUpdate;
import org.hortonmachine.gears.utils.PreferencesHandler;
import org.hortonmachine.gui.utils.DefaultGuiBridgeImpl;
import org.hortonmachine.gui.utils.GuiUtilities;
import org.hortonmachine.gui.utils.SshTesterView;
import org.hortonmachine.gui.utils.executor.ExecutorIndeterminateGui;
import org.hortonmachine.ssh.HMSshSession;
import org.hortonmachine.ssh.SshTunnelHandler;
import org.hortonmachine.ssh.SshUtilities;

public class SshTesterController
extends SshTesterView
implements GuiUtilities.IOnCloseListener {
    private SshTunnelHandler sshTunnel;

    public SshTesterController() {
        String sshKeyCheck;
        this.setPreferredSize(new Dimension(900, 800));
        String host = SshUtilities.getPreference((String)"HM_SSH_TOOLS_HOST", (String)"");
        String port = SshUtilities.getPreference((String)"HM_SSH_TOOLS_PORT", (String)"22");
        String user = SshUtilities.getPreference((String)"HM_SSH_TOOLS_USER", (String)"");
        String pwd = SshUtilities.getPreference((String)"HM_SSH_TOOLS_PWD", (String)"");
        this._hostField.setText(host);
        this._portField.setText(port);
        this._userField.setText(user);
        this._passwordField.setText(pwd);
        String thost = SshUtilities.getPreference((String)"HM_SSH_TOOLS_TUNNELHOST", (String)"");
        String tport_remote = SshUtilities.getPreference((String)"HM_SSH_TOOLS_TUNNELPORT_REMOTE", (String)"22");
        String tport_local = SshUtilities.getPreference((String)"HM_SSH_TOOLS_TUNNELPORT_LOCAL", (String)"22");
        String tuser = SshUtilities.getPreference((String)"HM_SSH_TOOLS_TUNNELUSER", (String)"");
        String tpwd = SshUtilities.getPreference((String)"HM_SSH_TOOLS_TUNNELPWD", (String)"");
        this._remoteTunnelHostField.setText(thost);
        this._tunnelPasswordField.setText(tpwd);
        this._tunnelUserField.setText(tuser);
        this._remoteTunnelPortField.setText(tport_remote);
        this._localTunnelPortField.setText(tport_local);
        this._toggleTunnelButton.addActionListener(e -> {
            try {
                if (!this._toggleTunnelButton.isSelected()) {
                    if (this.sshTunnel != null) {
                        this.sshTunnel.close();
                        this.sshTunnel = null;
                    }
                    this._toggleTunnelButton.setText("create tunnel");
                } else {
                    String h = this._remoteTunnelHostField.getText();
                    String u = this._tunnelUserField.getText();
                    String p = this._tunnelPasswordField.getText();
                    int localPort = Integer.parseInt(this._localTunnelPortField.getText());
                    int remotePort = Integer.parseInt(this._remoteTunnelPortField.getText());
                    this.sshTunnel = SshTunnelHandler.openTunnel((String)h, (String)u, (String)p, (int)localPort, (int)remotePort);
                    this._toggleTunnelButton.setText("disconnect tunnel");
                }
            }
            catch (Exception e1) {
                GuiUtilities.showErrorMessage(this._commandButton, e1.getMessage());
            }
        });
        String proxyCheck = PreferencesHandler.getPreference((String)"hm_pref_proxycheck", (String)"false");
        if (Boolean.parseBoolean(proxyCheck)) {
            String proxyHost = PreferencesHandler.getPreference((String)"hm_pref_proxyhost", (String)"");
            String proxyPort = PreferencesHandler.getPreference((String)"hm_pref_proxyport", (String)"");
            String proxyUser = PreferencesHandler.getPreference((String)"hm_pref_proxyuser", (String)"");
            this._proxyLabel.setText("Using proxy: " + proxyUser + "@" + proxyHost + ":" + proxyPort);
        }
        if ((sshKeyCheck = SshUtilities.getPreference((String)"HM_SSH_TOOLS_SSHKEYPATH", (String)"")).trim().length() > 0) {
            this._proxyLabel.setText("Using key: " + sshKeyCheck);
        }
        this._commandField.setText("ls -l");
        this._commandButton.addActionListener(e -> {
            final String ho = this._hostField.getText().trim();
            final String po = this._portField.getText().trim();
            final String u = this._userField.getText().trim();
            final String p = this._passwordField.getText().trim();
            final String c = this._commandField.getText().trim();
            new ExecutorIndeterminateGui(){

                @Override
                public void backGroundWork() throws Exception {
                    this.publish(new ProgressUpdate("Executing command on remote host...", 0));
                    if (ho.length() > 0 && po.length() > 0) {
                        try (HMSshSession session = new HMSshSession(ho, Integer.parseInt(po), u, p);){
                            String res = SshUtilities.runShellCommand((Session)session.getSession(), (String)c);
                            SshTesterController.this._outputArea.setText(res);
                        }
                        catch (Exception e1) {
                            SshTesterController.this._outputArea.setText("ERROR: " + e1.getMessage());
                        }
                    }
                }
            }.execute();
        });
    }

    @Override
    public void onClose() {
        String h = this._remoteTunnelHostField.getText();
        String u = this._tunnelUserField.getText();
        String p = this._tunnelPasswordField.getText();
        String localPort = this._localTunnelPortField.getText();
        String remotePort = this._remoteTunnelPortField.getText();
        SshUtilities.setPreference((String)"HM_SSH_TOOLS_TUNNELHOST", (String)h);
        SshUtilities.setPreference((String)"HM_SSH_TOOLS_TUNNELPORT_REMOTE", (String)String.valueOf(remotePort));
        SshUtilities.setPreference((String)"HM_SSH_TOOLS_TUNNELPORT_LOCAL", (String)String.valueOf(localPort));
        SshUtilities.setPreference((String)"HM_SSH_TOOLS_TUNNELUSER", (String)u);
        SshUtilities.setPreference((String)"HM_SSH_TOOLS_TUNNELPWD", (String)p);
        h = this._hostField.getText().trim();
        String port = this._portField.getText().trim();
        u = this._userField.getText().trim();
        p = this._passwordField.getText().trim();
        SshUtilities.setPreference((String)"HM_SSH_TOOLS_HOST", (String)h);
        SshUtilities.setPreference((String)"HM_SSH_TOOLS_PORT", (String)port);
        SshUtilities.setPreference((String)"HM_SSH_TOOLS_USER", (String)u);
        SshUtilities.setPreference((String)"HM_SSH_TOOLS_PWD", (String)p);
        if (this.sshTunnel != null) {
            try {
                this.sshTunnel.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.sshTunnel = null;
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public boolean canCloseWithoutPrompt() {
        return true;
    }

    public static void main(String[] args) {
        GuiUtilities.setDefaultLookAndFeel();
        DefaultGuiBridgeImpl gBridge = new DefaultGuiBridgeImpl();
        SshTesterController controller = new SshTesterController();
        JFrame frame = gBridge.showWindow(controller.asJComponent(), "HortonMachine Ssh Utils");
        Class<SshTesterController> class1 = SshTesterController.class;
        ImageIcon icon = new ImageIcon(class1.getResource("/org/hortonmachine/images/hm150.png"));
        frame.setIconImage(icon.getImage());
        GuiUtilities.addClosingListener(frame, controller);
    }
}

