/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils.monitor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.hortonmachine.gui.utils.monitor.ProgressDialog;
import org.hortonmachine.gui.utils.monitor.ProgressMonitor;

public class ProgressUtil {
    public static ProgressMonitor createModalProgressMonitor(Component owner, int total, boolean indeterminate, int milliSecondsToWait) {
        ProgressMonitor monitor = new ProgressMonitor(total, indeterminate, milliSecondsToWait);
        Window window = owner instanceof Window ? (Window)owner : SwingUtilities.getWindowAncestor(owner);
        monitor.addChangeListener(new MonitorListener(window, monitor));
        return monitor;
    }

    static class MonitorListener
    implements ChangeListener,
    ActionListener {
        ProgressMonitor monitor;
        Window owner;
        Timer timer;

        public MonitorListener(Window owner, ProgressMonitor monitor) {
            this.owner = owner;
            this.monitor = monitor;
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            ProgressMonitor monitor = (ProgressMonitor)ce.getSource();
            if (monitor.getCurrent() != monitor.getTotal()) {
                if (this.timer == null) {
                    this.timer = new Timer(monitor.getMilliSecondsToWait(), this);
                    this.timer.setRepeats(false);
                    this.timer.start();
                }
            } else if (this.timer != null && this.timer.isRunning()) {
                this.timer.stop();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.monitor.removeChangeListener(this);
            ProgressDialog dlg = this.owner instanceof Frame ? new ProgressDialog((Frame)this.owner, this.monitor) : new ProgressDialog((Dialog)this.owner, this.monitor);
            dlg.pack();
            dlg.setLocationRelativeTo(null);
            dlg.setVisible(true);
        }
    }
}

