/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.hortonmachine.gears.utils.images.ImageUtilities;
import org.hortonmachine.gui.utils.GuiUtilities;
import org.hortonmachine.gui.utils.ImageCache;

public class ImageViewer
extends JComponent {
    private BufferedImage image = null;
    private BufferedImage originalImage;
    private int imageWidth;
    private int imageHeight;
    private int currentAngle = 0;

    public ImageViewer(BufferedImage image) {
        this.image = image;
        this.originalImage = image;
        this.imageHeight = image.getHeight();
        this.imageWidth = image.getWidth();
        this.setPreferredSize(new Dimension(this.imageWidth, this.imageHeight));
        this.addContextMenu();
    }

    @Override
    public void paintComponent(Graphics g) {
        int newHeight = this.getHeight();
        int newWidth = this.imageWidth * newHeight / this.imageHeight;
        g.drawImage(this.image, this.getWidth() / 2 - newWidth / 2, this.getHeight() / 2 - newHeight / 2, newWidth, newHeight, null);
    }

    private void addContextMenu() {
        final JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new BevelBorder(0));
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JMenuItem item = new JMenuItem(new AbstractAction("Rotate clockwise"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ImageViewer.this.currentAngle = ImageViewer.this.currentAngle + 90;
                        if (ImageViewer.this.currentAngle == 360) {
                            ImageViewer.this.currentAngle = 0;
                        }
                        ImageViewer.this.image = ImageUtilities.rotateImageByDegrees((BufferedImage)ImageViewer.this.originalImage, (double)ImageViewer.this.currentAngle);
                        ImageViewer.this.imageWidth = ImageViewer.this.image.getWidth();
                        ImageViewer.this.imageHeight = ImageViewer.this.image.getHeight();
                        ImageViewer.this.repaint();
                    }
                });
                item.setHorizontalTextPosition(4);
                popupMenu.add(item);
                JMenuItem item1 = new JMenuItem(new AbstractAction("Rotate counter clockwise"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ImageViewer.this.currentAngle = ImageViewer.this.currentAngle - 90;
                        if (ImageViewer.this.currentAngle == 0) {
                            ImageViewer.this.currentAngle = 360;
                        }
                        ImageViewer.this.image = ImageUtilities.rotateImageByDegrees((BufferedImage)ImageViewer.this.originalImage, (double)ImageViewer.this.currentAngle);
                        ImageViewer.this.imageWidth = ImageViewer.this.image.getWidth();
                        ImageViewer.this.imageHeight = ImageViewer.this.image.getHeight();
                        ImageViewer.this.repaint();
                    }
                });
                item1.setHorizontalTextPosition(4);
                popupMenu.add(item1);
                JMenuItem item2 = new JMenuItem(new AbstractAction("Save image"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        File saveFile = GuiUtilities.showSaveFileDialog(popupMenu, "Save image", GuiUtilities.getLastFile());
                        String name = saveFile.getName().toLowerCase();
                        String format = "png";
                        if (name.endsWith("jpg") || name.endsWith("jpeg")) {
                            format = "jpg";
                        }
                        try {
                            ImageIO.write((RenderedImage)ImageViewer.this.image, format, saveFile);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                            GuiUtilities.showErrorMessage(popupMenu, e1.getLocalizedMessage());
                        }
                    }
                });
                item2.setHorizontalTextPosition(4);
                popupMenu.add(item2);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                popupMenu.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                popupMenu.removeAll();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public static void show(BufferedImage image, String title, boolean modal) {
        JDialog f = new JDialog();
        f.add((Component)new ImageViewer(image), "Center");
        f.setTitle(title);
        f.setIconImage(ImageCache.getInstance().getBufferedImage("hm150.png"));
        f.setModal(modal);
        f.pack();
        int h = image.getHeight();
        int w = image.getWidth();
        if (h > w) {
            f.setSize(new Dimension(600, 800));
        } else {
            f.setSize(new Dimension(800, 600));
        }
        f.setLocationRelativeTo(null);
        f.setVisible(true);
        f.setDefaultCloseOperation(2);
        f.getRootPane().registerKeyboardAction(e -> f.dispose(), KeyStroke.getKeyStroke(27, 0), 2);
    }
}

