/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils.executor;

import javax.swing.SwingUtilities;
import org.hortonmachine.gui.utils.executor.ExecutorIndeterminateGui;
import org.hortonmachine.gui.utils.executor.ExecutorProgressGui;
import org.hortonmachine.gui.utils.executor.ExecutorProgressPrintStream;
import org.hortonmachine.gui.utils.executor.HMExecutor;

public class ExecutorExamples {
    public static void main(String[] args) {
        ExecutorExamples.runWithProgress();
    }

    public static void runIndeterminate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ExecutorIndeterminateGui(){

                    @Override
                    public void backGroundWork() throws Exception {
                        for (int i = 0; i < 15; ++i) {
                            this.publish(new HMExecutor.Update("Working...", i + 1));
                            Thread.sleep(300L);
                        }
                    }
                }.execute();
            }
        });
    }

    public static void runWithProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final int max = 15;
                new ExecutorProgressGui(max){

                    @Override
                    public void backGroundWork() throws Exception {
                        for (int i = 0; i < max; ++i) {
                            int workDone = i + 1;
                            this.publish(new HMExecutor.Update("Working " + workDone + "...", workDone));
                            Thread.sleep(300L);
                        }
                    }
                }.execute();
            }
        });
    }

    public static void runWithProgressException() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final int max = 15;
                new ExecutorProgressGui(max){

                    @Override
                    public void backGroundWork() throws Exception {
                        for (int i = 0; i < max; ++i) {
                            int workDone = i + 1;
                            this.publish(new HMExecutor.Update("Working " + workDone + "...", workDone));
                            Thread.sleep(300L);
                            if (i != 3) continue;
                            throw new RuntimeException("Exiting due to error");
                        }
                    }
                }.execute();
            }
        });
    }

    public static void runWithProgressSysout() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final int max = 15;
                new ExecutorProgressPrintStream(System.out, max){

                    @Override
                    public void backGroundWork() throws Exception {
                        for (int i = 0; i < max; ++i) {
                            int workDone = i + 1;
                            this.publish(new HMExecutor.Update("Working " + workDone + "...", workDone));
                            Thread.sleep(300L);
                        }
                    }
                }.execute();
            }
        });
    }
}

