/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils.executor;

import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

public abstract class HMExecutor
extends SwingWorker<Void, Update> {
    protected int w = 600;
    protected int h = 120;
    protected ProgressPrinter progress;

    public void setProgressPrinter(ProgressPrinter progress) {
        this.progress = progress;
    }

    @Override
    protected void process(List<Update> chunks) {
        Update update = chunks.get(chunks.size() - 1);
        this.progress.publish(update);
    }

    @Override
    protected Void doInBackground() {
        try {
            this.backGroundWork();
        }
        catch (Exception e) {
            this.publish(new Update(e.getMessage()));
        }
        return null;
    }

    public abstract void backGroundWork() throws Exception;

    @Override
    protected void done() {
        try {
            this.get();
            this.progress.done();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static interface ProgressPrinter {
        public void publish(Update var1);

        public void done();
    }

    public static class Update {
        public String errorMessage;
        public String updateString;
        public int workDone;

        public Update(String updateString, int workDone) {
            this.updateString = updateString;
            this.workDone = workDone;
        }

        public Update(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }
}

