/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.spatialtoolbox.core;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.JGrassGears;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gui.spatialtoolbox.core.FieldData;
import org.hortonmachine.gui.spatialtoolbox.core.ModuleDescription;
import org.hortonmachine.gui.spatialtoolbox.core.TypeCheck;
import org.hortonmachine.gui.utils.GuiBridgeHandler;
import org.hortonmachine.gui.utils.GuiUtilities;
import org.hortonmachine.hmachine.HortonMachine;

public class ParametersPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private static final String PM_VAR_NAME = "pm";
    private String[] rasterLayers;
    private String[] vectorLayers;
    private List<JTextField> eastingListeningFields = new ArrayList<JTextField>();
    private List<JTextField> northingListeningFields = new ArrayList<JTextField>();
    private LinkedHashMap<String, Object> fieldName2ValueHolderMap = new LinkedHashMap();
    private List<String> outputFieldNames = new ArrayList<String>();
    private List<JComboBox<String>> rasterComboList = new ArrayList<JComboBox<String>>();
    private List<JComboBox<String>> vectorComboList = new ArrayList<JComboBox<String>>();
    private ModuleDescription module;
    private GuiBridgeHandler guiBridge;
    private Class<?> parentClass;

    public ParametersPanel(GuiBridgeHandler guiBridge) {
        this.guiBridge = guiBridge;
    }

    public ModuleDescription getModule() {
        return this.module;
    }

    public HashMap<String, Object> getFieldName2ValueHolderMap() {
        return this.fieldName2ValueHolderMap;
    }

    public List<String> getOutputFieldNames() {
        return this.outputFieldNames;
    }

    public void setVectorRasterLayers(String[] vectorLayers, String[] rasterLayers) {
        this.vectorLayers = vectorLayers;
        this.rasterLayers = rasterLayers;
        for (JComboBox<String> rasterCombo : this.rasterComboList) {
            try {
                Object selectedRaster = rasterCombo.getSelectedItem();
                if (rasterLayers != null) {
                    String[] tmpRasterLayers = new String[rasterLayers.length + 1];
                    tmpRasterLayers[0] = "";
                    System.arraycopy(rasterLayers, 0, tmpRasterLayers, 1, rasterLayers.length);
                    rasterCombo.setModel(new DefaultComboBoxModel<String>(tmpRasterLayers));
                }
                if (selectedRaster == null) continue;
                rasterCombo.setSelectedItem(selectedRaster);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (JComboBox<String> vectorCombo : this.vectorComboList) {
            try {
                Object selectedVector = vectorCombo.getSelectedItem();
                if (vectorLayers != null) {
                    String[] tmpVectorLayers = new String[vectorLayers.length + 1];
                    tmpVectorLayers[0] = "";
                    System.arraycopy(vectorLayers, 0, tmpVectorLayers, 1, vectorLayers.length);
                    vectorCombo.setModel(new DefaultComboBoxModel<String>(tmpVectorLayers));
                }
                if (selectedVector == null) continue;
                vectorCombo.setSelectedItem(selectedVector);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setModule(ModuleDescription module) {
        this.module = module;
        this.clear();
        if (module == null) {
            return;
        }
        this.parentClass = this.getParentClass(module);
        List<FieldData> inputsList = module.getInputsList();
        int allRows = inputsList.size();
        String rowsEnc = "";
        for (int i = 0; i < allRows; ++i) {
            rowsEnc = i == 0 ? "pref" : rowsEnc + ", 3dlu, max(50dlu;pref)";
        }
        this.setLayout((LayoutManager)new FormLayout("fill:250px:grow(.35), fill:5px, fill:250px:grow(.55)", rowsEnc));
        this.addInputs(inputsList);
    }

    private Class<?> getParentClass(ModuleDescription module) {
        Class parentOmsClass = null;
        try {
            Class<?> moduleClass = module.getModuleClass();
            String simpleName = "Oms" + moduleClass.getSimpleName();
            Class pClass = (Class)HortonMachine.getInstance().moduleName2Class.get(simpleName);
            if (pClass == null) {
                pClass = (Class)JGrassGears.getInstance().moduleName2Class.get(simpleName);
            }
            if (pClass != null) {
                parentOmsClass = pClass;
            }
        }
        catch (Exception e) {
            return null;
        }
        return parentOmsClass;
    }

    private void addInputs(List<FieldData> inputsList) {
        this.rasterComboList = new ArrayList<JComboBox<String>>();
        this.vectorComboList = new ArrayList<JComboBox<String>>();
        CellConstraints cc = new CellConstraints();
        int row = 1;
        for (FieldData inputField : inputsList) {
            String fieldDescription;
            if (inputField.fieldName.equals(PM_VAR_NAME)) continue;
            String fieldLabel = fieldDescription = inputField.fieldDescription;
            String fieldTooltip = fieldDescription;
            JTextArea nameLabel = new JTextArea();
            nameLabel.setOpaque(false);
            nameLabel.setLineWrap(true);
            nameLabel.setWrapStyleWord(true);
            nameLabel.setText(fieldLabel);
            nameLabel.setToolTipText(fieldTooltip);
            nameLabel.setEditable(false);
            TypeCheck fileCheck = this.getFileCheck(inputField);
            if (fileCheck.isOutput) {
                Font font = nameLabel.getFont();
                Font boldFont = new Font(font.getFontName(), 1, font.getSize());
                nameLabel.setFont(boldFont);
            }
            this.add((Component)nameLabel, cc.xy(1, row));
            int col = 3;
            if (this.isAtLeastOneAssignable(inputField.fieldType, String.class)) {
                if (inputField.guiHints != null && inputField.guiHints.startsWith("multiline")) {
                    this.handleTextArea(inputField, row, col, cc);
                } else if (inputField.guiHints != null && inputField.guiHints.startsWith("combo")) {
                    this.handleComboField(inputField, row, col, cc);
                } else {
                    this.handleTextField(inputField, row, col, cc, false, fileCheck);
                }
            } else if (this.isAtLeastOneAssignable(inputField.fieldType, Double.class, Double.TYPE)) {
                this.handleTextField(inputField, row, col, cc, true, fileCheck);
            } else if (this.isAtLeastOneAssignable(inputField.fieldType, Float.class, Float.TYPE)) {
                this.handleTextField(inputField, row, col, cc, true, fileCheck);
            } else if (this.isAtLeastOneAssignable(inputField.fieldType, Integer.class, Integer.TYPE)) {
                this.handleTextField(inputField, row, col, cc, true, fileCheck);
            } else if (this.isAtLeastOneAssignable(inputField.fieldType, Short.class, Short.TYPE)) {
                this.handleTextField(inputField, row, col, cc, true, fileCheck);
            } else if (this.isAtLeastOneAssignable(inputField.fieldType, Boolean.class, Boolean.TYPE)) {
                this.handleBooleanField(inputField, row, col, cc);
            }
            this.add((Component)new JSeparator(0), cc.xy(1, ++row));
            this.add((Component)new JSeparator(0), cc.xy(2, row));
            this.add((Component)new JSeparator(0), cc.xy(3, row));
            ++row;
        }
    }

    private TypeCheck getFileCheck(FieldData inputField) {
        TypeCheck f = new TypeCheck();
        String guiHints = inputField.guiHints;
        if (guiHints != null) {
            if (guiHints.contains("infile")) {
                f.isFile = true;
            } else if (guiHints.contains("outfile")) {
                f.isFile = true;
                f.isOutput = true;
            } else if (guiHints.contains("infolder")) {
                f.isFile = true;
                f.isFolder = true;
            } else if (guiHints.contains("outfolder")) {
                f.isFile = true;
                f.isFolder = true;
                f.isOutput = true;
            } else if (guiHints.contains("crs")) {
                f.isCrs = true;
            } else if (guiHints.contains("mapcalc")) {
                f.isMapcalc = true;
            } else if (guiHints.contains("grassfile")) {
                f.isGrassfile = true;
            } else if (guiHints.contains("process_north")) {
                f.isProcessingNorth = true;
            } else if (guiHints.contains("process_south")) {
                f.isProcessingSouth = true;
            } else if (guiHints.contains("process_west")) {
                f.isProcessingWest = true;
            } else if (guiHints.contains("process_east")) {
                f.isProcessingEast = true;
            } else if (guiHints.contains("process_cols")) {
                f.isProcessingCols = true;
            } else if (guiHints.contains("process_rows")) {
                f.isProcessingRows = true;
            } else if (guiHints.contains("process_xres")) {
                f.isProcessingXres = true;
            } else if (guiHints.contains("process_yres")) {
                f.isProcessingYres = true;
            } else if (guiHints.contains("northing")) {
                f.isNorthing = true;
            } else if (guiHints.contains("easting")) {
                f.isEasting = true;
            } else if (guiHints.contains("eastnorth")) {
                f.isEastingNorthing = true;
            }
        }
        return f;
    }

    private void handleTextField(FieldData inputField, int row, int col, CellConstraints cc, boolean onlyNumbers, TypeCheck typeCheck) {
        String defaultFieldValue = inputField.fieldValue;
        if (!typeCheck.isFile) {
            JTextField textField;
            if (!onlyNumbers) {
                textField = new JTextField();
            } else {
                NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
                DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
                decimalFormat.setGroupingUsed(false);
                textField = new JFormattedTextField(decimalFormat);
            }
            if (typeCheck.isEasting) {
                this.eastingListeningFields.add(textField);
                this.add((Component)textField, cc.xy(col, row));
                this.fieldName2ValueHolderMap.put(inputField.fieldName, textField);
            } else if (typeCheck.isNorthing) {
                this.northingListeningFields.add(textField);
                this.add((Component)textField, cc.xy(col, row));
                this.fieldName2ValueHolderMap.put(inputField.fieldName, textField);
            } else if (typeCheck.isCrs && this.guiBridge.supportsMapContext()) {
                JPanel subPanel = new JPanel();
                subPanel.setLayout(new BorderLayout());
                subPanel.add((Component)textField, "Center");
                this.fieldName2ValueHolderMap.put(inputField.fieldName, textField);
                final JTextField fTextField = textField;
                JButton crsButton = new JButton("...");
                subPanel.add((Component)crsButton, "East");
                crsButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String epsg = ParametersPanel.this.guiBridge.promptForCrs();
                        if (epsg != null) {
                            fTextField.setText(epsg);
                        }
                    }
                });
                this.add((Component)subPanel, cc.xy(col, row));
            } else {
                this.add((Component)textField, cc.xy(col, row));
                this.fieldName2ValueHolderMap.put(inputField.fieldName, textField);
            }
            textField.setText(defaultFieldValue);
        } else {
            JComboBox<String> comboBox;
            boolean isVector = false;
            boolean isRaster = false;
            boolean isLas = false;
            String guiHints = inputField.guiHints;
            if (guiHints.contains("infile_raster")) {
                isRaster = true;
            } else if (guiHints.contains("infile_vector")) {
                isVector = true;
            } else if (guiHints.contains("infile_las")) {
                isLas = true;
            } else if (guiHints.contains("outfile") && this.parentClass != null) {
                try {
                    Field field = this.parentClass.getField(inputField.fieldName);
                    if (field != null) {
                        Class<Object> clazz = field.getType();
                        if (clazz.isAssignableFrom(GridCoverage2D.class)) {
                            isRaster = true;
                        } else if (clazz.isAssignableFrom(SimpleFeatureCollection.class)) {
                            isVector = true;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (isVector && this.vectorLayers != null && !typeCheck.isOutput) {
                String[] tmpVectorLayers = new String[this.vectorLayers.length + 1];
                tmpVectorLayers[0] = "";
                System.arraycopy(this.vectorLayers, 0, tmpVectorLayers, 1, this.vectorLayers.length);
                comboBox = new JComboBox<String>(tmpVectorLayers);
                this.add(comboBox, cc.xy(col, row));
                this.vectorComboList.add(comboBox);
                this.fieldName2ValueHolderMap.put(inputField.fieldName, comboBox);
            } else if (isRaster && this.rasterLayers != null && !typeCheck.isOutput) {
                String[] tmpRasterLayers = new String[this.rasterLayers.length + 1];
                tmpRasterLayers[0] = "";
                System.arraycopy(this.rasterLayers, 0, tmpRasterLayers, 1, this.rasterLayers.length);
                comboBox = new JComboBox<String>(tmpRasterLayers);
                this.add(comboBox, cc.xy(col, row));
                this.rasterComboList.add(comboBox);
                this.fieldName2ValueHolderMap.put(inputField.fieldName, comboBox);
            } else {
                JPanel subPanel = new JPanel();
                this.add((Component)subPanel, cc.xy(col, row));
                subPanel.setLayout(new BorderLayout());
                final JTextField textField = new JTextField();
                subPanel.add((Component)textField, "Center");
                this.fieldName2ValueHolderMap.put(inputField.fieldName, textField);
                JButton browseButton = new JButton("...");
                subPanel.add((Component)browseButton, "East");
                FileFilter fileFilter = null;
                if (isRaster) {
                    fileFilter = HMConstants.rasterFileFilter;
                } else if (isVector) {
                    fileFilter = HMConstants.vectorFileFilter;
                } else if (isLas) {
                    fileFilter = HMConstants.lasFileFilter;
                }
                final FileFilter _fileFilter = fileFilter;
                if (!typeCheck.isFolder && !typeCheck.isOutput) {
                    browseButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            File[] files = ParametersPanel.this.guiBridge.showOpenFileDialog("Select input file", GuiUtilities.getLastFile(), _fileFilter);
                            ParametersPanel.this.setSelectedFile(textField, files);
                        }
                    });
                } else if (!typeCheck.isFolder && typeCheck.isOutput) {
                    this.outputFieldNames.add(inputField.fieldName);
                    browseButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            File[] files = ParametersPanel.this.guiBridge.showSaveFileDialog("Select file to save", GuiUtilities.getLastFile(), _fileFilter);
                            ParametersPanel.this.setSelectedFile(textField, files);
                        }
                    });
                } else if (typeCheck.isFolder && !typeCheck.isOutput) {
                    browseButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            File[] files = ParametersPanel.this.guiBridge.showOpenDirectoryDialog("Select folder", GuiUtilities.getLastFile());
                            ParametersPanel.this.setSelectedFile(textField, files);
                        }
                    });
                } else if (typeCheck.isFolder && typeCheck.isOutput) {
                    this.outputFieldNames.add(inputField.fieldName);
                    browseButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            File[] files = ParametersPanel.this.guiBridge.showOpenDirectoryDialog("Select folder", GuiUtilities.getLastFile());
                            ParametersPanel.this.setSelectedFile(textField, files);
                        }
                    });
                }
                textField.setText(defaultFieldValue);
            }
        }
    }

    private void setSelectedFile(JTextField textField, File[] files) {
        if (files != null && files.length > 0) {
            File gpapFile = files[0];
            GuiUtilities.setLastPath(gpapFile.getAbsolutePath());
            textField.setText(gpapFile.getAbsolutePath());
        }
    }

    private void handleTextArea(FieldData inputField, int row, int col, CellConstraints cc) {
        String hint = this.extractSingleGuiHint("multiline", inputField.guiHints);
        String rowsStr = hint.replaceFirst("multiline", "");
        int areaRows = Integer.parseInt(rowsStr);
        JTextArea textArea = new JTextArea();
        textArea.setRows(areaRows);
        this.add((Component)textArea, cc.xy(col, row));
        this.fieldName2ValueHolderMap.put(inputField.fieldName, textArea);
        textArea.setText(inputField.fieldValue);
    }

    private void handleBooleanField(FieldData inputField, int row, int col, CellConstraints cc) {
        JCheckBox checkBox = new JCheckBox("");
        this.add((Component)checkBox, cc.xy(col, row));
        this.fieldName2ValueHolderMap.put(inputField.fieldName, checkBox);
        boolean select = inputField.fieldValue.equalsIgnoreCase("true");
        checkBox.setSelected(select);
    }

    private void handleComboField(FieldData inputField, int row, int col, CellConstraints cc) {
        String[] guiHintsSplit = inputField.guiHints.split(";");
        String[] imtemsSplit = new String[]{" - "};
        for (String guiHint : guiHintsSplit) {
            if (!guiHint.startsWith("combo")) continue;
            String items = guiHint.replaceFirst("combo", "").replaceFirst(":", "").trim();
            imtemsSplit = items.split(",");
            break;
        }
        JComboBox<String> comboBox = new JComboBox<String>(imtemsSplit);
        this.add(comboBox, cc.xy(col, row));
        this.fieldName2ValueHolderMap.put(inputField.fieldName, comboBox);
        if (inputField.fieldValue.length() > 0) {
            comboBox.setSelectedItem(inputField.fieldValue);
        }
    }

    private boolean isAtLeastOneAssignable(String main, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.getCanonicalName().equals(main)) continue;
            return true;
        }
        return false;
    }

    private String extractSingleGuiHint(String pattern, String guiHints) {
        String[] split;
        for (String hint : split = guiHints.split(",")) {
            if (!(hint = hint.trim()).contains(pattern)) continue;
            return hint;
        }
        return null;
    }

    public void clear() {
        this.removeAll();
        this.eastingListeningFields.clear();
        this.northingListeningFields.clear();
        this.fieldName2ValueHolderMap.clear();
        this.outputFieldNames.clear();
        this.rasterComboList.clear();
        this.vectorComboList.clear();
    }

    public void freeResources() {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int y;
        if (!this.guiBridge.supportsMapContext()) {
            return;
        }
        int x = e.getX();
        Point2D mapPoint = this.guiBridge.getWorldPoint(x, y = e.getY());
        if (mapPoint != null) {
            for (JTextField textField : this.eastingListeningFields) {
                textField.setText("" + mapPoint.getX());
            }
            for (JTextField textField : this.northingListeningFields) {
                textField.setText("" + mapPoint.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

