/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.spatialtoolbox.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.hortonmachine.gui.spatialtoolbox.core.ModuleDescription;
import org.hortonmachine.gui.spatialtoolbox.core.ViewerModule;

public class ViewerFolder {
    private final String name;
    private List<ViewerFolder> subFolders = new ArrayList<ViewerFolder>();
    private List<ViewerModule> modules = new ArrayList<ViewerModule>();
    private ViewerFolder parentFolder;

    public ViewerFolder(String name) {
        this.name = name;
    }

    public void setParentFolder(ViewerFolder parentFolder) {
        this.parentFolder = parentFolder;
    }

    public ViewerFolder getParentFolder() {
        return this.parentFolder;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name.replaceFirst("/", "");
    }

    public void addSubFolder(ViewerFolder subFolder) {
        if (!this.subFolders.contains(subFolder)) {
            subFolder.setParentFolder(this);
            this.subFolders.add(subFolder);
        }
    }

    public void addModule(ViewerModule module) {
        if (!this.modules.contains(module)) {
            module.setParentFolder(this);
            this.modules.add(module);
        }
    }

    public List<ViewerFolder> getSubFolders() {
        return this.subFolders;
    }

    public List<ViewerModule> getModules() {
        return this.modules;
    }

    public static List<ViewerFolder> hashmap2ViewerFolders(TreeMap<String, List<ModuleDescription>> availableModules, String filterText, boolean loadExperimental) {
        ArrayList<ViewerFolder> folders = new ArrayList<ViewerFolder>();
        HashMap<String, ViewerFolder> tmpFoldersMap = new HashMap<String, ViewerFolder>();
        Set<Map.Entry<String, List<ModuleDescription>>> entrySet = availableModules.entrySet();
        for (Map.Entry<String, List<ModuleDescription>> entry : entrySet) {
            int from;
            String key = entry.getKey();
            List<ModuleDescription> md = entry.getValue();
            String separator = "/";
            String[] keySplit = key.split(separator);
            int lastSlash = key.lastIndexOf(separator);
            String base = lastSlash == -1 ? key : key.substring(0, lastSlash);
            String mainKey = base + separator;
            ViewerFolder mainFolder = (ViewerFolder)tmpFoldersMap.get(mainKey);
            if (mainFolder == null) {
                mainFolder = new ViewerFolder(mainKey);
                folders.add(mainFolder);
                tmpFoldersMap.put(mainKey, mainFolder);
            }
            if ((from = keySplit.length - 1) == 0) {
                from = 1;
            }
            for (int i = from; i < keySplit.length; ++i) {
                ViewerFolder tmpFolder = (ViewerFolder)tmpFoldersMap.get(keySplit[i]);
                if (tmpFolder == null) {
                    tmpFolder = new ViewerFolder(keySplit[i]);
                    StringBuilder keyB = new StringBuilder();
                    for (int j = 0; j <= i; ++j) {
                        keyB.append(keySplit[j]).append(separator);
                    }
                    tmpFoldersMap.put(keyB.toString(), tmpFolder);
                }
                mainFolder.addSubFolder(tmpFolder);
                mainFolder = tmpFolder;
            }
            for (ModuleDescription moduleDescription : md) {
                String moduleNameLC = moduleDescription.getName().toLowerCase();
                if (filterText != null && filterText.length() > 0 && !moduleNameLC.contains(filterText.toLowerCase()) || moduleDescription.getStatus() == ModuleDescription.Status.experimental && !loadExperimental) continue;
                mainFolder.addModule(new ViewerModule(moduleDescription));
            }
        }
        Iterator folderIterator = folders.iterator();
        while (folderIterator.hasNext()) {
            ViewerFolder folder = (ViewerFolder)folderIterator.next();
            List<ViewerFolder> subFoldersList = folder.getSubFolders();
            Iterator<ViewerFolder> subFoldersIterator = subFoldersList.iterator();
            while (subFoldersIterator.hasNext()) {
                ViewerFolder subFolder = subFoldersIterator.next();
                List<ViewerFolder> subSubFoldersList = subFolder.getSubFolders();
                if (!subFolder.getModules().isEmpty() || !subSubFoldersList.isEmpty()) continue;
                subFoldersIterator.remove();
            }
            if (!folder.getModules().isEmpty() || !subFoldersList.isEmpty()) continue;
            folderIterator.remove();
        }
        return folders;
    }
}

