/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils.executor;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.hortonmachine.gui.utils.GuiUtilities;
import org.hortonmachine.gui.utils.ImageCache;
import org.hortonmachine.gui.utils.executor.HMExecutor;

public abstract class ExecutorIndeterminateGui
extends HMExecutor {
    private JFrame frame = new JFrame();

    public ExecutorIndeterminateGui() {
        final JLabel label = new JLabel("Loading...");
        JProgressBar jpb = new JProgressBar();
        jpb.setIndeterminate(true);
        final JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)label, "North");
        panel.add((Component)jpb, "Center");
        this.frame.add(panel);
        this.frame.pack();
        this.frame.setSize(this.w, this.h);
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        this.frame.setIconImage(ImageCache.getBuffered("hm150.png"));
        this.frame.setDefaultCloseOperation(0);
        this.progress = new HMExecutor.ProgressPrinter(){

            @Override
            public void publish(HMExecutor.Update update) {
                if (update.errorMessage != null) {
                    ExecutorIndeterminateGui.this.frame.dispose();
                    GuiUtilities.showErrorMessage(panel, update.errorMessage);
                } else {
                    label.setText(update.updateString);
                }
            }

            @Override
            public void done() {
                if (ExecutorIndeterminateGui.this.frame != null && ExecutorIndeterminateGui.this.frame.isVisible()) {
                    ExecutorIndeterminateGui.this.frame.dispose();
                }
            }
        };
    }
}

