/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils.monitor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hortonmachine.gui.utils.monitor.ProgressMonitor;
import org.hortonmachine.gui.utils.monitor.ProgressUtil;

public abstract class ActionWithProgress
extends AbstractAction {
    protected Component parent;
    private int total;
    private boolean indeterminate;
    private String progressTitle;
    protected List<AbstractAction> connectedActions = new ArrayList<AbstractAction>();

    public ActionWithProgress(Component parent, String progressTitle, int total, boolean indeterminate) {
        this.parent = parent;
        this.progressTitle = progressTitle;
        this.total = total;
        this.indeterminate = indeterminate;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.setEnabled(false);
        for (AbstractAction abstractAction : this.connectedActions) {
            abstractAction.setEnabled(false);
        }
        new Thread(() -> {
            ProgressMonitor monitor = null;
            try {
                monitor = ProgressUtil.createModalProgressMonitor(this.parent, this.total, this.indeterminate, 100);
                monitor.start(this.progressTitle);
                this.backGroundWork(monitor);
                for (AbstractAction abstractAction : this.connectedActions) {
                    abstractAction.setEnabled(true);
                }
                this.postWork();
            }
            catch (Exception e) {
                this.onError(e);
            }
            finally {
                this.setEnabled(true);
                if (monitor != null && monitor.getCurrent() != monitor.getTotal()) {
                    monitor.setCurrent(null, monitor.getTotal());
                }
            }
        }, "ActionWithPogress -> " + this.progressTitle).start();
    }

    public abstract void backGroundWork(ProgressMonitor var1) throws Exception;

    public void postWork() throws Exception {
    }

    public void addConnectedAction(AbstractAction action) {
        if (!this.connectedActions.contains(action)) {
            this.connectedActions.add(action);
        }
    }

    public void onError(Exception e) {
        e.printStackTrace();
        String localizedMessage = e.getLocalizedMessage();
        if (localizedMessage == null) {
            localizedMessage = e.getMessage();
        }
        if (localizedMessage == null || localizedMessage.trim().length() == 0) {
            localizedMessage = "An undefined error was thrown. Please send the below trace to your technical contact:\n";
            localizedMessage = localizedMessage + ExceptionUtils.getStackTrace((Throwable)e);
        }
        final String _localizedMessage = localizedMessage;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(ActionWithProgress.this.parent, _localizedMessage, "ERROR", 0);
            }
        });
    }
}

