/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;

public class ProgressMonitor
implements IHMProgressMonitor {
    int total;
    int current = -1;
    boolean indeterminate;
    int milliSecondsToWait = 500;
    String status;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final ReentrantLock lock = new ReentrantLock();
    private ChangeEvent ce = new ChangeEvent(this);

    public ProgressMonitor(int total, boolean indeterminate, int milliSecondsToWait) {
        this.total = total;
        this.indeterminate = indeterminate;
        this.milliSecondsToWait = milliSecondsToWait;
    }

    public ProgressMonitor(int total, boolean indeterminate) {
        this.total = total;
        this.indeterminate = indeterminate;
    }

    public int getTotal() {
        return this.total;
    }

    public void start(String status) {
        if (this.current != -1) {
            throw new IllegalStateException("not started yet");
        }
        this.status = status;
        this.current = 0;
        this.fireChangeEvent();
    }

    public void beginTask(String name, int totalWork) {
        this.total = totalWork;
        this.start(name);
    }

    public int getMilliSecondsToWait() {
        return this.milliSecondsToWait;
    }

    public int getCurrent() {
        return this.current;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void setCurrent(String status, int current) {
        if (current == -1) {
            throw new IllegalStateException("not started yet");
        }
        this.current = current;
        if (status != null) {
            this.status = status;
        }
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener listener) {
        this.lock.lock();
        try {
            this.listeners.add(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.lock.lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    private synchronized void fireChangeEvent() {
        this.lock.lock();
        try {
            for (ChangeListener changeListener : this.listeners) {
                changeListener.stateChanged(this.ce);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void message(String message) {
        if (message != null) {
            this.status = message;
            this.fireChangeEvent();
        }
    }

    public void errorMessage(String message) {
    }

    public void exceptionThrown(String message) {
        if (message != null) {
            this.status = message;
            this.fireChangeEvent();
        }
    }

    public void done() {
        this.setCurrent("Done.", this.total);
    }

    public void internalWorked(double work) {
        throw new RuntimeException("Not implemented yet...");
    }

    public boolean isCanceled() {
        return false;
    }

    public void setCanceled(boolean value) {
        throw new RuntimeException("Not implemented yet...");
    }

    public void setTaskName(String name) {
        throw new RuntimeException("Not implemented yet...");
    }

    public void subTask(String name) {
        throw new RuntimeException("Not implemented yet...");
    }

    public void worked(int work) {
        this.current += work;
        this.fireChangeEvent();
    }

    public <T> T adapt(Class<T> adaptee) {
        throw new RuntimeException("Not implemented yet...");
    }

    public void onModuleExit() {
        throw new RuntimeException("Not implemented yet...");
    }
}

