/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.settings;

import com.jcraft.jsch.JSchException;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.nio.charset.Charset;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.hortonmachine.dbs.log.Logger;
import org.hortonmachine.gears.utils.PreferencesHandler;
import org.hortonmachine.gui.settings.SettingsView;
import org.hortonmachine.gui.utils.DefaultGuiBridgeImpl;
import org.hortonmachine.gui.utils.GuiUtilities;
import org.hortonmachine.gui.utils.ImageCache;
import org.hortonmachine.ssh.ProxyEnabler;
import org.hortonmachine.ssh.TunnelSingleton;

public class SettingsController
extends SettingsView
implements GuiUtilities.IOnCloseListener {
    public SettingsController() {
        this.setPreferredSize(new Dimension(900, 400));
        this.fillFromPreferences();
    }

    private void fillFromPreferences() {
        String proxyCheck = PreferencesHandler.getPreference((String)"hm_pref_proxycheck", (String)"false");
        String proxyHost = PreferencesHandler.getPreference((String)"hm_pref_proxyhost", (String)"");
        String proxyPort = PreferencesHandler.getPreference((String)"hm_pref_proxyport", (String)"");
        String proxyUser = PreferencesHandler.getPreference((String)"hm_pref_proxyuser", (String)"");
        String proxyPwd = PreferencesHandler.getPreference((String)"hm_pref_proxypwd", (String)"");
        this._proxyCheckbox.setSelected(Boolean.parseBoolean(proxyCheck));
        this._proxyHostField.setText(proxyHost);
        this._proxyPortField.setText(proxyPort);
        this._proxyUserField.setText(proxyUser);
        this._proxyPasswordField.setText(proxyPwd);
        String tunnelCheck = PreferencesHandler.getPreference((String)"hm_pref_tunnelcheck", (String)"false");
        String tunnelHost = PreferencesHandler.getPreference((String)"hm_pref_tunnelhost", (String)"");
        String tunnelUser = PreferencesHandler.getPreference((String)"hm_pref_tunneluser", (String)"");
        String tunnelPwd = PreferencesHandler.getPreference((String)"hm_pref_tunnelpwd", (String)"");
        String tunnelLocalPort = PreferencesHandler.getPreference((String)"hm_pref_tunnellocalport", (String)"");
        String tunnelRemotePort = PreferencesHandler.getPreference((String)"hm_pref_tunnelremoteport", (String)"");
        this._sshTunnelCheckbox.setSelected(Boolean.parseBoolean(tunnelCheck));
        this._tunnelHostField.setText(tunnelHost);
        this._tunnelUserField.setText(tunnelUser);
        this._tunnelPasswordField.setText(tunnelPwd);
        this._tunnelLocalPortField.setText(tunnelLocalPort);
        this._tunnelRemotePortField.setText(tunnelRemotePort);
        String shpCharset = PreferencesHandler.getPreference((String)"hm_pref_shp_charset", (String)"");
        this._charsetTextField.setText(shpCharset);
        ComponentOrientation co = PreferencesHandler.getComponentOrientation();
        this._orientationCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"LEFT_TO_RIGHT", "RIGHT_TO_LEFT"}));
        this._orientationCombo.setSelectedItem(co.isLeftToRight() ? "LEFT_TO_RIGHT" : "RIGHT_TO_LEFT");
        this._orientationCombo.addActionListener(e -> {
            String selection = (String)this._orientationCombo.getSelectedItem();
            if (selection != null) {
                PreferencesHandler.saveComponentOrientation((String)selection);
            }
        });
    }

    private void applySettingsAndSavePreferences() throws Exception {
        boolean tunnelSelected;
        String pwd;
        String user;
        boolean proxySelected;
        String charset = this._charsetTextField.getText();
        if (charset.trim().length() != 0) {
            if (!Charset.isSupported(charset)) {
                GuiUtilities.showWarningMessage(this, "Unsupported charset: " + charset);
            } else {
                PreferencesHandler.setPreference((String)"hm_pref_shp_charset", (String)charset);
            }
        }
        PreferencesHandler.setPreference((String)"hm_pref_proxycheck", (String)((proxySelected = this._proxyCheckbox.isSelected()) ? "true" : "false"));
        if (proxySelected) {
            String host = this._proxyHostField.getText();
            String port = this._proxyPortField.getText();
            user = this._proxyUserField.getText();
            pwd = this._proxyPasswordField.getText();
            PreferencesHandler.setPreference((String)"hm_pref_proxyhost", (String)host);
            PreferencesHandler.setPreference((String)"hm_pref_proxyport", (String)port);
            PreferencesHandler.setPreference((String)"hm_pref_proxyuser", (String)user);
            PreferencesHandler.setPreference((String)"hm_pref_proxypwd", (String)pwd);
        }
        PreferencesHandler.setPreference((String)"hm_pref_tunnelcheck", (String)((tunnelSelected = this._sshTunnelCheckbox.isSelected()) ? "true" : "false"));
        if (tunnelSelected) {
            String host = this._tunnelHostField.getText();
            user = this._tunnelUserField.getText();
            pwd = this._tunnelPasswordField.getText();
            String localPort = this._tunnelLocalPortField.getText();
            String remotePort = this._tunnelRemotePortField.getText();
            PreferencesHandler.setPreference((String)"hm_pref_tunnelhost", (String)host);
            PreferencesHandler.setPreference((String)"hm_pref_tunneluser", (String)user);
            PreferencesHandler.setPreference((String)"hm_pref_tunnelpwd", (String)pwd);
            PreferencesHandler.setPreference((String)"hm_pref_tunnellocalport", (String)localPort);
            PreferencesHandler.setPreference((String)"hm_pref_tunnelremoteport", (String)remotePort);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public boolean canCloseWithoutPrompt() {
        return true;
    }

    @Override
    public void onClose() {
        try {
            this.applySettingsAndSavePreferences();
        }
        catch (Exception e) {
            Logger.INSTANCE.insertError("SettingsController", "An error occurred while saving the settings", (Throwable)e);
        }
    }

    public static void applySettings(Component component) {
        String pwd;
        String user;
        String doProxy = PreferencesHandler.getPreference((String)"hm_pref_proxycheck", (String)"false");
        if (Boolean.parseBoolean(doProxy)) {
            String host = PreferencesHandler.getPreference((String)"hm_pref_proxyhost", (String)"");
            String port = PreferencesHandler.getPreference((String)"hm_pref_proxyport", (String)"");
            user = PreferencesHandler.getPreference((String)"hm_pref_proxyuser", (String)"");
            pwd = PreferencesHandler.getPreference((String)"hm_pref_proxypwd", (String)"");
            ProxyEnabler.enableProxy((String)host, (String)port, (String)user, (String)pwd, (String)"");
        }
        if (component != null) {
            String doTunneling = PreferencesHandler.getPreference((String)"hm_pref_tunnelcheck", (String)"false");
            if (Boolean.parseBoolean(doTunneling)) {
                String host = PreferencesHandler.getPreference((String)"hm_pref_tunnelhost", (String)"");
                user = PreferencesHandler.getPreference((String)"hm_pref_tunneluser", (String)"");
                pwd = PreferencesHandler.getPreference((String)"hm_pref_tunnelpwd", (String)"");
                String localPort = PreferencesHandler.getPreference((String)"hm_pref_tunnellocalport", (String)"");
                String remotePort = PreferencesHandler.getPreference((String)"hm_pref_tunnelremoteport", (String)"");
                int remote = Integer.parseInt(remotePort);
                int local = Integer.parseInt(localPort);
                try {
                    TunnelSingleton.INSTANCE.setTunnelObject(host, user, pwd, local, remote);
                }
                catch (JSchException e) {
                    Logger.INSTANCE.insertError("SettingsController", "An error occurred while opening tunnel", (Throwable)e);
                }
            }
            ComponentOrientation co = PreferencesHandler.getComponentOrientation();
            GuiUtilities.applyComponentOrientation(component, co);
        }
    }

    public static void onCloseHandleSettings() {
        TunnelSingleton.INSTANCE.disconnectTunnel();
    }

    public static void main(String[] args) throws Exception {
        GuiUtilities.setDefaultLookAndFeel();
        DefaultGuiBridgeImpl gBridge = new DefaultGuiBridgeImpl();
        SettingsController controller = new SettingsController();
        SettingsController.applySettings(controller);
        JFrame frame = gBridge.showWindow(controller.asJComponent(), "HortonMachine Settings");
        frame.setIconImage(ImageCache.getBuffered("hm150.png"));
        GuiUtilities.addClosingListener(frame, controller);
    }
}

