/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils.executor;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.hortonmachine.gears.ui.progress.IProgressPrinter;
import org.hortonmachine.gears.ui.progress.ProgressUpdate;
import org.hortonmachine.gui.utils.GuiUtilities;
import org.hortonmachine.gui.utils.ImageCache;
import org.hortonmachine.gui.utils.executor.HMExecutor;

public abstract class ExecutorProgressGui
extends HMExecutor {
    private JFrame frame = new JFrame();

    public ExecutorProgressGui(int max) {
        final JLabel label = new JLabel("Loading...");
        final JProgressBar jpb = new JProgressBar(0, max);
        jpb.setIndeterminate(false);
        final JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)label, "North");
        panel.add((Component)jpb, "Center");
        this.frame.add(panel);
        this.frame.pack();
        this.frame.setSize(this.w, this.h);
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        this.frame.setIconImage(ImageCache.getBuffered("hm150.png"));
        this.frame.setDefaultCloseOperation(0);
        this.progress = new IProgressPrinter(){

            public void publish(ProgressUpdate update) {
                if (update.errorMessage != null) {
                    ExecutorProgressGui.this.frame.dispose();
                    GuiUtilities.showErrorMessage(panel, update.errorMessage);
                } else {
                    label.setText(update.updateString);
                    jpb.setValue(update.workDone);
                }
            }

            public void done() {
                if (ExecutorProgressGui.this.frame != null && ExecutorProgressGui.this.frame.isVisible()) {
                    ExecutorProgressGui.this.frame.dispose();
                }
            }
        };
    }
}

