/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gui.utils;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JToolBar;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.event.MapLayerListEvent;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.swing.JMapFrame;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.osm.OSMService;
import org.geotools.tile.util.TileLayer;
import org.hortonmachine.gears.io.rasterreader.OmsRasterReader;
import org.hortonmachine.gears.io.vectorreader.OmsVectorReader;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.utils.PreferencesHandler;
import org.hortonmachine.gears.utils.SldUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gears.utils.style.StyleUtilities;
import org.hortonmachine.gui.settings.SettingsController;
import org.hortonmachine.gui.utils.GuiUtilities;
import org.hortonmachine.gui.utils.ImageCache;
import org.opengis.feature.type.FeatureType;

public class HMMapframe
extends JMapFrame {
    private MapContent content = new MapContent();

    public HMMapframe(String title) {
        this.content.setTitle(title);
        this.setMapContent(this.content);
    }

    public void addLayer(SimpleFeatureCollection featureCollection) {
        FeatureLayer fl = this.makeFeatureLayer(featureCollection);
        this.addLayer((Layer)fl);
    }

    public void setLayer(SimpleFeatureCollection featureCollection) {
        FeatureLayer fl = this.makeFeatureLayer(featureCollection);
        this.setLayer((Layer)fl);
    }

    public void addLayer(SimpleFeatureCollection featureCollection, Style style) {
        FeatureLayer fl = new FeatureLayer((FeatureCollection)featureCollection, style);
        this.addLayer((Layer)fl);
    }

    public void setLayer(SimpleFeatureCollection featureCollection, Style style) {
        FeatureLayer fl = new FeatureLayer((FeatureCollection)featureCollection, style);
        this.setLayer((Layer)fl);
    }

    public void addLayer(Layer layer) {
        this.content.addLayer(layer);
    }

    public void addLayerBottom(Layer layer) {
        this.content.addLayer(layer);
        int index = this.content.layers().indexOf(layer);
        this.content.moveLayer(index, 0);
        this.getMapPane().layerMoved(new MapLayerListEvent(this.content, layer, 0));
    }

    public void setLayer(Layer layer) {
        List layers = this.content.layers();
        for (Layer l : layers) {
            this.content.removeLayer(l);
        }
        this.content.addLayer(layer);
    }

    private FeatureLayer makeFeatureLayer(SimpleFeatureCollection featureCollection) {
        Style style = StyleUtilities.createDefaultStyle((SimpleFeatureCollection)featureCollection);
        FeatureLayer fl = new FeatureLayer((FeatureCollection)featureCollection, style);
        return fl;
    }

    public static HMMapframe openFolder(File folder) {
        GridCoverageLayer layer;
        Style style;
        File styleFile;
        String title = "HM Viewer of folder: " + folder.getAbsolutePath();
        HMMapframe mapFrame = HMMapframe.getBaseFrame(title, false);
        Object[] rasterFiles = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return HMConstants.isRaster((File)new File(dir, name));
            }
        });
        Arrays.sort(rasterFiles);
        Object[] vectorFiles = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return HMConstants.isVector((File)new File(dir, name));
            }
        });
        Arrays.sort(vectorFiles);
        if (rasterFiles != null && rasterFiles.length > 0) {
            for (Object rasterFile : rasterFiles) {
                try {
                    GridCoverage2D raster = OmsRasterReader.readRaster((String)((File)rasterFile).getAbsolutePath());
                    styleFile = FileUtilities.substituteExtention((File)rasterFile, (String)"sld");
                    style = styleFile.exists() ? SldUtilities.getStyleFromFile((File)styleFile) : SldUtilities.getStyleFromRasterFile((File)rasterFile);
                    layer = new GridCoverageLayer(raster, style);
                    mapFrame.addLayer((Layer)layer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (vectorFiles != null && vectorFiles.length > 0) {
            for (Object vectorFile : vectorFiles) {
                try {
                    SimpleFeatureCollection fc = OmsVectorReader.readVector((String)((File)vectorFile).getAbsolutePath());
                    styleFile = FileUtilities.substituteExtention((File)vectorFile, (String)"sld");
                    style = styleFile.exists() ? SldUtilities.getStyleFromFile((File)styleFile) : SLD.createSimpleStyle((FeatureType)fc.getSchema());
                    layer = new FeatureLayer((FeatureCollection)fc, style);
                    mapFrame.addLayer((Layer)layer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return mapFrame;
    }

    private static HMMapframe getBaseFrame(String title, boolean exitOnClose) {
        ImageIcon icon = new ImageIcon(ImageCache.getInstance().getBufferedImage("hm150.png"));
        final HMMapframe mapFrame = new HMMapframe(title);
        mapFrame.setIconImage(icon.getImage());
        mapFrame.enableToolBar(true);
        mapFrame.enableStatusBar(true);
        mapFrame.enableLayerTable(true);
        mapFrame.enableTool(new JMapFrame.Tool[]{JMapFrame.Tool.PAN, JMapFrame.Tool.ZOOM, JMapFrame.Tool.RESET, JMapFrame.Tool.INFO});
        if (exitOnClose) {
            mapFrame.setDefaultCloseOperation(3);
        } else {
            mapFrame.setDefaultCloseOperation(2);
        }
        mapFrame.setSize(1200, 900);
        mapFrame.setVisible(true);
        JToolBar toolBar = mapFrame.getToolBar();
        toolBar.add(new AbstractAction("Add OSM background", ImageCache.getInstance().getImage("globe.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                String baseURL = "http://tile.openstreetmap.org/";
                OSMService service = new OSMService("OpenStreetMap", baseURL);
                TileLayer layer = new TileLayer((TileService)service);
                layer.setTitle("OpenStreetMap");
                mapFrame.addLayerBottom((Layer)layer);
            }
        });
        return mapFrame;
    }

    public static HMMapframe openFrame(boolean exitOnClose) {
        return HMMapframe.getBaseFrame("HM Viewer", exitOnClose);
    }

    public static void main(String[] args) {
        GuiUtilities.setDefaultLookAndFeel();
        File openFile = null;
        if (args.length > 0 && new File(args[0]).exists()) {
            openFile = new File(args[0]);
            if (!openFile.isDirectory()) {
                openFile = openFile.getParentFile();
            }
        } else {
            File[] openFolder = GuiUtilities.showOpenFolderDialog(null, "Select folder to show", false, PreferencesHandler.getLastFile());
            if (openFolder != null && openFolder.length > 0) {
                openFile = openFolder[0];
            }
        }
        if (openFile != null) {
            HMMapframe mf = HMMapframe.openFolder(openFile);
            SettingsController.applySettings((Component)((Object)mf));
            mf.setDefaultCloseOperation(3);
        } else {
            GuiUtilities.showWarningMessage(null, "No data folder supplied!");
        }
    }
}

