/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.buildings;

import java.awt.Point;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.ALasDataManager;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.rasterreader.OmsRasterReader;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.monitor.LogProgressMonitor;
import org.hortonmachine.gears.modules.r.morpher.OmsMorpher;
import org.hortonmachine.gears.modules.v.smoothing.OmsLineSmootherMcMaster;
import org.hortonmachine.gears.modules.v.vectorize.OmsVectorizer;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="A simple buildings extractor module")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="las, buildings")
@Label(value="Lesto/buildings")
@Name(value="lasondembuildingsextractor")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LasOnDtmBuildingsExtractor
extends HMModel {
    @Description(value="The las file")
    @UI(value="infile_las")
    @In
    public String inLas;
    @Description(value="The dtm raster")
    @UI(value="infile_raster")
    @In
    public String inDtm;
    @Description(value="The dtm threshold to use.")
    @Unit(value="m")
    @In
    public double pDtmThres = 1.8;
    @Description(value="The minimum building area allowed.")
    @Unit(value="m2")
    @In
    public double pMinArea = 25.0;
    @Description(value="The raster resolution to force. If null, the dtm resolution will be used.")
    @Unit(value="m")
    @In
    public Double pRasterResolution;
    @Description(value="If true, some smoothing and cleanups will be performed.")
    @In
    public boolean doSmoothing;
    @Description(value="The densification resolution to use for smoothing.")
    @Unit(value="m")
    @In
    public double pDensifyResolution = 0.5;
    @Description(value="The negative buildings buffer used to check internal points without border problems.")
    @Unit(value="m")
    @In
    public double pBuildingsBuffer = -0.5;
    @Description(value="The output vector buildings.")
    @UI(value="outfile")
    @In
    public String outBuildings;
    @Description(value="The optional cleaned-up output vector buildings.")
    @UI(value="outfile")
    @In
    public String outCleanBuildings;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLas, this.inDtm, this.outBuildings});
        SimpleFeatureCollection buildingsFC = null;
        GridCoverage2D inDtmGC = null;
        try (ALasDataManager lasHandler = ALasDataManager.getDataManager((File)new File(this.inLas), inDtmGC, (double)0.0, null);){
            double minAreaInCells;
            lasHandler.open();
            ReferencedEnvelope3D e = lasHandler.getEnvelope3D();
            if (this.pRasterResolution != null) {
                OmsRasterReader reader = new OmsRasterReader();
                reader.file = this.inDtm;
                reader.pNorth = e.getMaxY();
                reader.pSouth = e.getMinY();
                reader.pWest = e.getMinX();
                reader.pEast = e.getMaxX();
                reader.pXres = this.pRasterResolution;
                reader.pYres = this.pRasterResolution;
                reader.process();
                inDtmGC = reader.outRaster;
            } else {
                inDtmGC = this.getRaster(this.inDtm);
                RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)inDtmGC);
                this.pRasterResolution = regionMap.getXres();
            }
            Envelope2D envelope2d = inDtmGC.getEnvelope2D();
            Polygon regionPolygon = FeatureUtilities.envelopeToPolygon((Envelope2D)envelope2d);
            WritableRaster[] buildingsHolder = new WritableRaster[1];
            GridCoverage2D newBuildingsRaster = CoverageUtilities.createCoverageFromTemplate((GridCoverage2D)inDtmGC, (Double)1.0, (WritableRaster[])buildingsHolder);
            GridGeometry2D gridGeometry = newBuildingsRaster.getGridGeometry();
            Point p = new Point();
            LogProgressMonitor pm = new LogProgressMonitor();
            pm.beginTask("Reading points...", -1);
            List pointsInGeometry = lasHandler.getPointsInGeometry((Geometry)regionPolygon, true);
            pm.done();
            pm.beginTask("Buildings filtering...", pointsInGeometry.size());
            for (LasRecord dot : pointsInGeometry) {
                Coordinate c = new Coordinate(dot.x, dot.y);
                if (!envelope2d.contains(dot.x, dot.y)) continue;
                double dtmValue = CoverageUtilities.getValue((GridCoverage2D)inDtmGC, (Coordinate)c);
                double height = Math.abs(dot.z - dtmValue);
                CoverageUtilities.colRowFromCoordinate((Coordinate)c, (GridGeometry2D)gridGeometry, (Point)p);
                if (height < this.pDtmThres) {
                    buildingsHolder[0].setSample(p.x, p.y, 0, -9999.0);
                }
                pm.worked(1);
            }
            pm.done();
            OmsMorpher morpher = new OmsMorpher();
            morpher.pm = pm;
            morpher.inMap = newBuildingsRaster;
            morpher.pMode = "open";
            morpher.process();
            newBuildingsRaster = morpher.outMap;
            OmsVectorizer buildingsVectorizer = new OmsVectorizer();
            buildingsVectorizer.pm = pm;
            buildingsVectorizer.inRaster = newBuildingsRaster;
            buildingsVectorizer.doRemoveHoles = true;
            buildingsVectorizer.pThres = minAreaInCells = this.pMinArea / this.pRasterResolution / this.pRasterResolution;
            buildingsVectorizer.fDefault = "rast";
            buildingsVectorizer.process();
            buildingsFC = buildingsVectorizer.outVector;
            this.dumpVector(buildingsFC, this.outBuildings);
            if (this.doSmoothing && this.outCleanBuildings != null) {
                SimpleFeatureCollection smoothedFC = this.smoothBuildings(this.pDensifyResolution, buildingsFC);
                DefaultFeatureCollection removedAndSmoothedFC = this.removeNonBuildings(lasHandler, smoothedFC, inDtmGC, this.pBuildingsBuffer);
                this.dumpVector((SimpleFeatureCollection)removedAndSmoothedFC, this.outCleanBuildings);
            }
        }
    }

    private DefaultFeatureCollection removeNonBuildings(ALasDataManager lasHandler, SimpleFeatureCollection buildingsFC, GridCoverage2D dem, double buildingsBuffer) throws Exception {
        List buildingsList = FeatureUtilities.featureCollectionToList((SimpleFeatureCollection)buildingsFC);
        ArrayList<SimpleFeature> checkedBuildings = new ArrayList<SimpleFeature>();
        this.pm.beginTask("Removing buildings...", buildingsList.size());
        for (int i = 0; i < buildingsList.size(); ++i) {
            SimpleFeature building = (SimpleFeature)buildingsList.get(i);
            Geometry buildingGeom = (Geometry)building.getDefaultGeometry();
            Geometry bufferedGeom = buildingGeom.buffer(buildingsBuffer);
            List points = lasHandler.getPointsInGeometry(bufferedGeom, false);
            int percOfOnes = this.checkReturnNum(points, bufferedGeom);
            if (percOfOnes >= 96) {
                checkedBuildings.add(building);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        DefaultFeatureCollection fc = new DefaultFeatureCollection();
        fc.addAll(checkedBuildings);
        return fc;
    }

    private int checkReturnNum(List<LasRecord> points, Geometry bufferedGeom) {
        int count = 0;
        for (LasRecord l : points) {
            if (l.returnNumber != 1) continue;
            ++count;
        }
        double perc = (double)count * 100.0 / (double)points.size();
        return (int)Math.round(perc);
    }

    private SimpleFeatureCollection smoothBuildings(double densifyResolution, SimpleFeatureCollection buildingsFC) throws Exception {
        List buildingsList = FeatureUtilities.featureCollectionToList((SimpleFeatureCollection)buildingsFC);
        ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
        this.pm.beginTask("Smoothing buildings...", buildingsList.size());
        for (SimpleFeature building : buildingsList) {
            Geometry buildingGeom = (Geometry)building.getDefaultGeometry();
            buildingGeom = Densifier.densify((Geometry)buildingGeom, (double)densifyResolution);
            Coordinate[] coordinates = buildingGeom.getCoordinates();
            ArrayList<Coordinate> newCoords = new ArrayList<Coordinate>();
            for (int i = 0; i < coordinates.length - 1; ++i) {
                Coordinate from = coordinates[i];
                Coordinate to = coordinates[i + 1];
                LineSegment l = new LineSegment(from, to);
                Coordinate newCoord = l.pointAlong(0.5);
                newCoords.add(newCoord);
            }
            newCoords.add((Coordinate)newCoords.get(0));
            Polygon newPolygon = this.gf.createPolygon(newCoords.toArray(new Coordinate[0]));
            newPolygons.add(newPolygon);
            this.pm.worked(1);
        }
        this.pm.done();
        SimpleFeatureCollection fc = FeatureUtilities.featureCollectionFromGeometry((CoordinateReferenceSystem)buildingsFC.getBounds().getCoordinateReferenceSystem(), (Geometry[])((Geometry[])newPolygons.toArray(GeometryUtilities.TYPE_POLYGON)));
        OmsLineSmootherMcMaster smoother = new OmsLineSmootherMcMaster();
        smoother.pm = this.pm;
        smoother.pLimit = 10;
        smoother.inVector = fc;
        smoother.pLookahead = 5;
        smoother.process();
        fc = smoother.outVector;
        List geomsList = FeatureUtilities.featureCollectionToGeometriesList((SimpleFeatureCollection)fc, (boolean)true, null);
        ArrayList<Polygon> newGeomsList = new ArrayList<Polygon>();
        for (Geometry geometry : geomsList) {
            Polygon polygon = this.gf.createPolygon(geometry.getCoordinates());
            polygon = (Polygon)TopologyPreservingSimplifier.simplify((Geometry)polygon, (double)0.4);
            newGeomsList.add(polygon);
        }
        fc = FeatureUtilities.featureCollectionFromGeometry((CoordinateReferenceSystem)buildingsFC.getBounds().getCoordinateReferenceSystem(), (Geometry[])((Geometry[])newGeomsList.toArray(GeometryUtilities.TYPE_POLYGON)));
        return fc;
    }
}

