/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.hortonmachine.gears.io.las.core.ALasWriter;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.las.index.LasIndexer;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.CrsUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Converts XYZ data exported from FARO TLS to las.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="las, tls, convert")
@Label(value="Lesto/utilities")
@Name(value="lasfromfarotlsxyz")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LasFromFaroTlsXyz
extends HMModel {
    @Description(value="The xyz file to convert.")
    @UI(value="infile")
    @In
    public String inFile;
    @Description(value="The reference longitude in a metric projection.")
    @In
    public Double pLongitude;
    @Description(value="The reference latitude in a metric projection.")
    @In
    public Double pLatitude;
    @Description(value="The maximum allowed distance from the center.")
    @Unit(value="m")
    @In
    public Double pMaxDistance;
    @Description(value="The code defining the data coordinate reference system.")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The converted las output file.")
    @UI(value="outfile")
    @In
    public String outLas;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inFile, this.outLas, this.pCode, this.pLatitude, this.pLongitude});
        CoordinateReferenceSystem crs = CrsUtilities.getCrsFromEpsg((String)this.pCode);
        double latitude = this.pLatitude;
        double longitude = this.pLongitude;
        ArrayList<LasRecord> readRecords = new ArrayList<LasRecord>();
        File inXyzFile = new File(this.inFile);
        double xMin = Double.POSITIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double zMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        double zMax = Double.NEGATIVE_INFINITY;
        double maxDistance = Double.POSITIVE_INFINITY;
        if (this.pMaxDistance != null) {
            maxDistance = this.pMaxDistance;
        }
        int ignoredCount = 0;
        this.pm.beginTask("Reading xyz and creating bounds...", -1);
        try (BufferedReader xyzReader = new BufferedReader(new FileReader(inXyzFile));){
            String line;
            int count = 0;
            while ((line = xyzReader.readLine()) != null) {
                if (count++ % 1000000 == 0) {
                    this.pm.message("processed lines: " + (count - 1) + " of which ignored: " + ignoredCount);
                }
                if ((line = line.trim()).length() == 0) continue;
                String[] lineSplit = line.split("\\s+");
                if (lineSplit.length != 8) {
                    String msg = "Wrong data format. The data are supposed to be exported from the SCENE software as scan points.\nThe data format in the XYZ file is: rowNum, colNum, xDeltaMeters, yDeltaMeters, elev, R, G, B";
                    throw new ModelsIllegalargumentException(msg, (Object)this);
                }
                int index = 2;
                double deltaX = Double.parseDouble(lineSplit[index++]);
                int n = index++;
                double deltaY = Double.parseDouble(lineSplit[n]);
                double distanceFromCenter = NumericsUtilities.pythagoras((double)deltaX, (double)deltaY);
                if (distanceFromCenter > maxDistance) {
                    ++ignoredCount;
                    continue;
                }
                double x = longitude + deltaX;
                double y = latitude + deltaY;
                double elev = Double.parseDouble(lineSplit[index++]);
                int r = Integer.parseInt(lineSplit[index++]);
                int g = Integer.parseInt(lineSplit[index++]);
                int b = Integer.parseInt(lineSplit[index++]);
                xMin = Math.min(xMin, x);
                yMin = Math.min(yMin, y);
                zMin = Math.min(zMin, elev);
                xMax = Math.max(xMax, x);
                yMax = Math.max(yMax, y);
                zMax = Math.max(zMax, elev);
                LasRecord dot = new LasRecord();
                dot.x = x;
                dot.y = y;
                dot.z = elev;
                dot.color = new short[]{(short)r, (short)g, (short)b};
                dot.gpsTime = System.currentTimeMillis();
                readRecords.add(dot);
            }
        }
        this.pm.done();
        this.pm.message("Keeping point: " + readRecords.size());
        File outFile = new File(this.outLas);
        try (ALasWriter writer = ALasWriter.getWriter((File)outFile, (CoordinateReferenceSystem)crs);){
            writer.setBounds(xMin, xMax, yMin, yMax, zMin, zMax);
            writer.setPointFormat(3);
            writer.open();
            this.pm.beginTask("Writing las...", readRecords.size());
            for (LasRecord dot : readRecords) {
                writer.addPoint(dot);
                this.pm.worked(1);
            }
            this.pm.done();
        }
    }

    public static void main(String[] args) throws Exception {
        String inFile = "/home/hydrologis/data/rilievo_tls/capriana_punti_scansione_lowres.xyz";
        double lon = 681269.8905;
        double lat = 5127117.2439;
        String outFolder = "/home/hydrologis/data/rilievo_tls/lowres/";
        String outFile = outFolder + "capriana_lowres.las";
        double maxDistance = 16.0;
        LasFromFaroTlsXyz x = new LasFromFaroTlsXyz();
        x.inFile = inFile;
        x.pLongitude = lon;
        x.pLatitude = lat;
        x.pMaxDistance = maxDistance;
        x.pCode = "EPSG:32632";
        x.outLas = outFile;
        x.process();
        LasIndexer in = new LasIndexer();
        in.inFolder = outFolder;
        in.pCellsize = 0.5;
        in.process();
    }
}

