/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.utilities;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Create an overview shapefile of a folder of las files.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="overview, vector, lidar, las")
@Label(value="Lesto/utilities")
@Name(value="lasoverviewcreator")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class LasOverviewCreator
extends HMModel {
    @Description(value="Las file or folder path.")
    @UI(value="infile_las")
    @In
    public String inLas = null;
    @Description(value="Output overview shapefile.")
    @UI(value="outfile")
    @In
    public String outOverview = null;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLas, this.outOverview});
        File[] lasFiles = null;
        File inLasFile = new File(this.inLas);
        lasFiles = inLasFile.isDirectory() ? inLasFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".las");
            }
        }) : new File[]{inLasFile};
        CoordinateReferenceSystem crs = null;
        this.pm.beginTask("Creating overviews...", lasFiles.length);
        ArrayList<Polygon> overviewPolygons = new ArrayList<Polygon>();
        for (File file : lasFiles) {
            try (ALasReader lasReader = ALasReader.getReader((File)file, null);){
                lasReader.open();
                ILasHeader header = lasReader.getHeader();
                if (crs == null) {
                    crs = header.getCrs();
                }
                ReferencedEnvelope3D dataEnvelope = header.getDataEnvelope();
                Polygon polygon = FeatureUtilities.envelopeToPolygon((Envelope)dataEnvelope);
                polygon.setUserData((Object)file.getName());
                overviewPolygons.add(polygon);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        SimpleFeatureCollection overviewFC = FeatureUtilities.featureCollectionFromGeometry(crs, (Geometry[])((Geometry[])overviewPolygons.toArray(GeometryUtilities.TYPE_POLYGON)));
        this.dumpVector(overviewFC, this.outOverview);
    }
}

