/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.utilities;

import java.io.File;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.vectorwriter.OmsVectorWriter;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.clustering.GvmClusters;
import org.hortonmachine.gears.utils.clustering.GvmKeyer;
import org.hortonmachine.gears.utils.clustering.GvmResult;
import org.hortonmachine.gears.utils.clustering.GvmSpace;
import org.hortonmachine.gears.utils.clustering.GvmVectorSpace;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.lesto.modules.utilities.cluster.LasClusterElevationKeyer;
import org.hortonmachine.lesto.modules.utilities.cluster.ShpClusterElevationKeyer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Clustering of point data.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="cluster, lidar, las")
@Label(value="Lesto/utilities")
@Name(value="lasinfo")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class PointClusterer
extends HMModel {
    @Description(value="Input las or shp file to be clustered.")
    @UI(value="infile_vector")
    @In
    public String inFile = null;
    @Description(value="Number of clusters.")
    @In
    public int pClusterCount = 1000;
    @Description(value="Shapefile field containing the value to cluster.")
    @In
    public String fClusterName = "elev";
    @Description(value="Clustered output shapefile.")
    @UI(value="outfile")
    @In
    public String outShp = null;
    private final GvmVectorSpace space = new GvmVectorSpace(2);

    public PointClusterer() throws Exception {
        this.checkNull(new Object[]{this.inFile, this.outShp});
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        if (this.inFile.toLowerCase().endsWith(".las")) {
            try (ALasReader lasReader = ALasReader.getReader((File)new File(this.inFile), null);){
                lasReader.open();
                ILasHeader header = lasReader.getHeader();
                CoordinateReferenceSystem crs = header.getCrs();
                GvmClusters clusters = new GvmClusters((GvmSpace)this.space, this.pClusterCount);
                clusters.setKeyer((GvmKeyer)new LasClusterElevationKeyer());
                double[] vector = ((GvmVectorSpace)clusters.getSpace()).newOrigin();
                this.pm.beginTask("Clustering...", (int)header.getRecordsCount());
                while (lasReader.hasNextPoint()) {
                    LasRecord dot = lasReader.getNextPoint();
                    vector[0] = dot.x;
                    vector[1] = dot.y;
                    clusters.add(dot.z, (Object)vector, (Object)dot);
                    this.pm.worked(1);
                }
                this.pm.done();
                SimpleFeatureBuilder builder = this.getfeatureBuilder(crs);
                List results = clusters.results();
                for (GvmResult gvmResult : results) {
                    int count = gvmResult.getCount();
                    double mass = gvmResult.getMass();
                    double variance = gvmResult.getVariance();
                    double stdev = gvmResult.getStdDeviation();
                    double[] point = (double[])gvmResult.getPoint();
                    double avgElev = mass / (double)count;
                    Point p = this.gf.createPoint(new Coordinate(point[0], point[1]));
                    Object[] values = new Object[]{p, count, mass, variance, stdev, avgElev};
                    builder.addAll(values);
                    SimpleFeature feature = builder.buildFeature(null);
                    newCollection.add(feature);
                }
            }
        } else if (this.inFile.toLowerCase().endsWith(".shp")) {
            SimpleFeatureCollection inPointsFC = this.getVector(this.inFile);
            this.fClusterName = FeatureUtilities.findAttributeName((SimpleFeatureType)((SimpleFeatureType)inPointsFC.getSchema()), (String)this.fClusterName);
            if (this.fClusterName == null) {
                throw new ModelsIllegalargumentException("No field found by the name: " + this.fClusterName, (Object)this);
            }
            CoordinateReferenceSystem crs = inPointsFC.getBounds().getCoordinateReferenceSystem();
            List pointsList = FeatureUtilities.featureCollectionToList((SimpleFeatureCollection)inPointsFC);
            GvmClusters clusters = new GvmClusters((GvmSpace)this.space, this.pClusterCount);
            clusters.setKeyer((GvmKeyer)new ShpClusterElevationKeyer());
            double[] vector = ((GvmVectorSpace)clusters.getSpace()).newOrigin();
            this.pm.beginTask("Clustering...", pointsList.size());
            for (SimpleFeature point : pointsList) {
                double elev;
                Geometry geometry = (Geometry)point.getDefaultGeometry();
                Coordinate dot = geometry.getCoordinate();
                vector[0] = dot.x;
                vector[1] = dot.y;
                dot.z = elev = ((Double)point.getAttribute(this.fClusterName)).doubleValue();
                clusters.add(elev, (Object)vector, (Object)dot);
                this.pm.worked(1);
            }
            this.pm.done();
            SimpleFeatureBuilder builder = this.getfeatureBuilder(crs);
            double delta = 1.0E-4;
            List results = clusters.results();
            for (GvmResult gvmResult : results) {
                int count = gvmResult.getCount();
                double mass = gvmResult.getMass();
                double variance = gvmResult.getVariance();
                double stdev = gvmResult.getStdDeviation();
                if (variance < delta || stdev < delta) continue;
                double[] point = (double[])gvmResult.getPoint();
                double avgElev = mass / (double)count;
                Point p = this.gf.createPoint(new Coordinate(point[0], point[1]));
                Object[] values = new Object[]{p, count, mass, variance, stdev, avgElev};
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(null);
                newCollection.add(feature);
            }
        } else {
            throw new ModelsIllegalargumentException("Can't process input file: " + this.inFile, (Object)this);
        }
        OmsVectorWriter.writeVector((String)this.outShp, (SimpleFeatureCollection)newCollection);
    }

    private SimpleFeatureBuilder getfeatureBuilder(CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("cluster");
        b.setCRS(crs);
        b.add("the_geom", Point.class);
        b.add("count", Integer.class);
        b.add("mass", Double.class);
        b.add("variance", Double.class);
        b.add("stdev", Double.class);
        b.add("elev", Double.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        return builder;
    }
}

