/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.filter;

import java.io.File;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.chart.CategoryHistogram;
import org.hortonmachine.gears.utils.chart.IChart;
import org.hortonmachine.gears.utils.chart.PlotFrame;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="A module that creates a histogram from a las file.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="las, histogram ")
@Label(value="Lesto/filter")
@Name(value="lashistogram")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LasHistogram
extends HMModel {
    @Description(value="A las file to analyze.")
    @UI(value="infile_las")
    @In
    public String inLas;
    @Description(value="Number of bins to use.")
    @In
    public int pBin = 100;
    @Description(value="Do plot.")
    @In
    public boolean doPlot = true;
    @Description(value="The value to analyze.")
    @UI(value="combo:intensity,elev,classificazione")
    @In
    public String pType = "intensity";

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLas});
        boolean doIntensity = false;
        boolean doClassification = false;
        DecimalFormat formatter = new DecimalFormat("0.0");
        if (this.pType.equals("intensity")) {
            doIntensity = true;
            formatter = new DecimalFormat("0");
        }
        if (this.pType.equals("classificazione")) {
            doClassification = true;
            formatter = new DecimalFormat("0");
        }
        CoordinateReferenceSystem crs = null;
        File lasFile = new File(this.inLas);
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        int recordsCount = 0;
        try (ALasReader reader = ALasReader.getReader((File)lasFile, crs);){
            reader.open();
            ILasHeader header = reader.getHeader();
            recordsCount = (int)header.getRecordsCount();
            this.pm.beginTask(MessageFormat.format("Calculating range of {0} points...", recordsCount), recordsCount);
            while (reader.hasNextPoint()) {
                LasRecord readNextLasDot = reader.getNextPoint();
                double value = readNextLasDot.z;
                if (doIntensity) {
                    value = readNextLasDot.intensity;
                }
                if (doClassification) {
                    value = readNextLasDot.classification;
                }
                min = Math.min(min, value);
                max = Math.max(max, value);
                this.pm.worked(1);
            }
        }
        this.pm.done();
        this.pm.message("Max: " + max);
        this.pm.message("Min: " + min);
        if (!Double.isFinite(max) || !Double.isFinite(min)) {
            this.pm.errorMessage("A problem occurred while reading the data, exiting...");
            return;
        }
        double range = max - min;
        double step = range / (double)this.pBin;
        double[] count = new double[this.pBin];
        double[] markers = new double[this.pBin];
        for (int i = 0; i < markers.length; ++i) {
            markers[i] = min + step * (double)(i + 1);
        }
        this.pm.beginTask("Creating histogram...", recordsCount);
        try (ALasReader reader = ALasReader.getReader((File)lasFile, crs);){
            reader.open();
            while (reader.hasNextPoint()) {
                LasRecord readNextLasDot = reader.getNextPoint();
                double value = readNextLasDot.z;
                if (doIntensity) {
                    value = readNextLasDot.intensity;
                }
                if (doClassification) {
                    value = readNextLasDot.classification;
                }
                for (int j = 0; j < markers.length; ++j) {
                    if (!(value <= markers[j])) continue;
                    count[j] = count[j] + 1.0;
                    break;
                }
                this.pm.worked(1);
            }
        }
        this.pm.done();
        this.pm.message("value, \tcount");
        String[] markersLabels = new String[this.pBin];
        for (int i = 0; i < markersLabels.length; ++i) {
            double center = markers[i] - step / 2.0;
            markersLabels[i] = formatter.format(center);
            this.pm.message(markersLabels[i] + ",\t" + count[i]);
        }
        if (this.doPlot) {
            CategoryHistogram hi = new CategoryHistogram(markersLabels, count);
            PlotFrame frame = new PlotFrame((IChart)hi);
            frame.plot();
        }
    }
}

