/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.filter;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ALasWriter;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="A module that applies threshold and filters on a value inside the las")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="las, threshold, filter")
@Label(value="Lesto/filter")
@Name(value="lasthreshold")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LasThresholder
extends HMModel {
    @Description(value="A las file to filter.")
    @UI(value="infile_las")
    @In
    public String inLas;
    @Description(value="Lower threshold.")
    @In
    public Double pLower;
    @Description(value="Upper threshold.")
    @In
    public Double pUpper;
    @Description(value="The value to analyze.")
    @UI(value="combo:intensity,elev")
    @In
    public String pType = "intensity";
    @Description(value="Output las file.")
    @UI(value="outfile")
    @In
    public String outLas;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLas, this.outLas});
        boolean doIntensity = false;
        if (this.pType.equals("intensity")) {
            doIntensity = true;
        }
        CoordinateReferenceSystem crs = null;
        File lasFile = new File(this.inLas);
        File outFile = new File(this.outLas);
        try (ALasReader reader = ALasReader.getReader((File)lasFile, crs);
             ALasWriter writer = ALasWriter.getWriter((File)outFile, crs);){
            reader.open();
            ILasHeader header = reader.getHeader();
            long recordsNum = header.getRecordsCount();
            writer.setBounds(header);
            writer.open();
            this.pm.beginTask("Filtering", (int)recordsNum);
            double min = Double.NEGATIVE_INFINITY;
            if (this.pLower != null) {
                min = this.pLower;
            }
            double max = Double.POSITIVE_INFINITY;
            if (this.pUpper != null) {
                max = this.pUpper;
            }
            while (reader.hasNextPoint()) {
                LasRecord readNextLasDot = reader.getNextPoint();
                double value = readNextLasDot.z;
                if (doIntensity) {
                    value = readNextLasDot.intensity;
                }
                if (value < min) {
                    this.pm.worked(1);
                    continue;
                }
                if (value > max) {
                    this.pm.worked(1);
                    continue;
                }
                writer.addPoint(readNextLasDot);
                this.pm.worked(1);
            }
        }
        this.pm.done();
    }
}

