/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.raster;

import java.awt.image.WritableRaster;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Bibliography;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hortonmachine.gears.io.las.ALasDataManager;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.las.utils.LasRecordElevationComparator;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.modules.ThreadedRunnable;
import org.hortonmachine.gears.modules.v.grids.OmsGridsGenerator;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.hortonmachine.lesto.modules.raster.adaptivetinfilter.TinHandler;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Tool for DEM generation from laser scanner data using adaptive tin models .")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="tin, filter, lidar")
@Label(value="Lesto/raster")
@Name(value="adaptivetinfilter")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
@Bibliography(value={"Dem generation from laser scanner data using adaptive tin models - 01/2000 - P.Axelsson"})
public class AdaptiveTinFilter
extends HMModel {
    @Description(value="The las folder index file")
    @UI(value="infile_las")
    @In
    public String inLas;
    @Description(value="Input raster to use as output grid template.")
    @UI(value="infile_raster")
    @In
    public String inTemplate;
    @Description(value="Number of iterations permitted.")
    @In
    public int pIterations = 20;
    @Description(value="Support grid resolution in meters (will be recalculated/corrected on grid template).")
    @In
    public double pSecRes = 50.0;
    @Description(value="Minimum distance threshold.")
    @In
    public double pDistThres = 0.5;
    @Description(value="Final cleanup distance.")
    @In
    public double pFinalCleanupDist = 1.0;
    @Description(value="Minimum angle threshold.")
    @In
    public double pAngleThres = 10.0;
    @Description(value="Tin triangle edge limit (if null, ignored).")
    @In
    public Double pEdgeThres = null;
    @Description(value="If true the vector files of tin and nonground are dumped to shapefile.")
    @In
    public boolean doTin = false;
    @Description(value="The start seed triangles.")
    @UI(value="outfile")
    @In
    public String outSeeds;
    @Description(value="Final output tin.")
    @UI(value="outfile")
    @In
    public String outTin;
    @Description(value="Output non ground points.")
    @UI(value="outfile")
    @In
    public String outNonGround;
    @Description(value="Output tiles.")
    @UI(value="outfile")
    @In
    public String outTiles;
    @Description(value="The interpolated output raster.")
    @UI(value="outfile")
    @In
    public String outDem;
    private GridCoverage2D inTemplateGC;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLas, this.inTemplate, this.outDem});
        this.inTemplateGC = this.getRaster(this.inTemplate);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)this.inTemplateGC);
        double newCols = Math.ceil(regionMap.getWidth() / this.pSecRes);
        double newRows = Math.ceil(regionMap.getHeight() / this.pSecRes);
        OmsGridsGenerator gridGenerator = new OmsGridsGenerator();
        gridGenerator.inRaster = this.inTemplateGC;
        gridGenerator.pCols = (int)newCols;
        gridGenerator.pRows = (int)newRows;
        gridGenerator.process();
        SimpleFeatureCollection outTilesFC = gridGenerator.outMap;
        if (this.outTiles != null) {
            this.dumpVector(outTilesFC, this.outTiles);
        }
        List secGridGeoms = FeatureUtilities.featureCollectionToGeometriesList((SimpleFeatureCollection)outTilesFC, (boolean)true, null);
        List<Coordinate> seedsList = this.getSeeds(secGridGeoms);
        int defaultThreadsNum = AdaptiveTinFilter.getDefaultThreadsNum();
        TinHandler tinHandler = new TinHandler(this.pm, this.inTemplateGC.getCoordinateReferenceSystem(), this.pAngleThres, this.pDistThres, this.pEdgeThres, defaultThreadsNum);
        tinHandler.setStartCoordinates(seedsList);
        if (this.outSeeds != null) {
            SimpleFeatureCollection outSeedsFC = tinHandler.toFeatureCollection();
            this.dumpVector(outSeedsFC, this.outSeeds);
        }
        try (ALasDataManager lasHandler = ALasDataManager.getDataManager((File)new File(this.inLas), null, (double)0.0, (CoordinateReferenceSystem)this.inTemplateGC.getCoordinateReferenceSystem());){
            lasHandler.open();
            tinHandler.filterOnAllData(lasHandler);
            int iteration = 1;
            boolean firstRound = true;
            do {
                this.pm.message("Iteration N." + iteration);
                int tinBefore = tinHandler.getCurrentGroundPointsNum();
                if (firstRound) {
                    tinHandler.filterOnAllData(lasHandler);
                    firstRound = false;
                } else {
                    tinHandler.filterOnLeftOverData();
                }
                int tinAfter = tinHandler.getCurrentGroundPointsNum();
                int addedPoints = tinAfter - tinBefore;
                this.pm.message("Points added to the next iteration: " + addedPoints);
                tinHandler.resetTin();
                if (addedPoints != 0) continue;
                break;
            } while (++iteration <= this.pIterations);
        }
        tinHandler.getTriangles();
        tinHandler.finalCleanup(this.pFinalCleanupDist);
        double[] minMaxElev = tinHandler.getMinMaxElev();
        this.pm.message("Tin triangles min and max elevation:" + Arrays.toString(minMaxElev));
        if (this.doTin) {
            if (this.outTin != null) {
                SimpleFeatureCollection outTinFC = tinHandler.toFeatureCollection();
                this.dumpVector(outTinFC, this.outTin);
            }
            if (this.outNonGround != null) {
                SimpleFeatureCollection outNonGroundFC = tinHandler.toFeatureCollectionOthers();
                this.dumpVector(outNonGroundFC, this.outNonGround);
            }
        }
        double[] minMaxElev0 = tinHandler.getMinMaxElev();
        this.doRaster(tinHandler, regionMap, minMaxElev0, 0);
    }

    private void doRaster(TinHandler tinHandler, RegionMap regionMap, final double[] minMaxElev, int iteration) throws Exception {
        final WritableRaster[] rasterHandler = new WritableRaster[1];
        GridCoverage2D outDemGC = CoverageUtilities.createCoverageFromTemplate((GridCoverage2D)this.inTemplateGC, (Double)-9999.0, (WritableRaster[])rasterHandler);
        final STRtree tinTree = tinHandler.generateTinIndex(null);
        final GridGeometry2D gridGeometry = this.inTemplateGC.getGridGeometry();
        ThreadedRunnable tRun = new ThreadedRunnable(AdaptiveTinFilter.getDefaultThreadsNum(), null);
        for (int r = 0; r < regionMap.getRows(); ++r) {
            int c = 0;
            while (c < regionMap.getCols()) {
                final int col = c++;
                final int row = r;
                tRun.executeRunnable(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        try {
                            double z;
                            SimplePointInAreaLocator pointLoc;
                            DirectPosition directPosition = gridGeometry.gridToWorld(new GridCoordinates2D(col, row));
                            double[] coord = directPosition.getCoordinate();
                            Coordinate coordinate = new Coordinate(coord[0], coord[1]);
                            Envelope e = new Envelope(coordinate);
                            e.expandBy(0.1);
                            List nearTinGeoms = tinTree.query(e);
                            if (nearTinGeoms.size() == 0) {
                                return;
                            }
                            Geometry tinGeom = null;
                            for (int i = 0; i < nearTinGeoms.size() && (pointLoc = new SimplePointInAreaLocator(tinGeom = (Geometry)nearTinGeoms.get(i))).locate(coordinate) != 0; ++i) {
                            }
                            if (tinGeom == null) {
                                AdaptiveTinFilter.this.pm.errorMessage("Didn't find a matching triangle...");
                                return;
                            }
                            Coordinate c1 = new Coordinate(coordinate.x, coordinate.y, 1000000.0);
                            Coordinate c2 = new Coordinate(coordinate.x, coordinate.y, -1000000.0);
                            Coordinate[] tinCoords = tinGeom.getCoordinates();
                            Coordinate intersection = GeometryUtilities.getLineWithPlaneIntersection((Coordinate)c1, (Coordinate)c2, (Coordinate)tinCoords[0], (Coordinate)tinCoords[1], (Coordinate)tinCoords[2]);
                            if (intersection == null || !((z = intersection.z) >= minMaxElev[0]) || !(z <= minMaxElev[1])) return;
                            WritableRaster[] writableRasterArray = rasterHandler;
                            synchronized (rasterHandler) {
                                rasterHandler[0].setSample(col, row, 0, z);
                                // ** MonitorExit[var13_14] (shouldn't be in output)
                                return;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        tRun.waitAndClose();
        this.pm.done();
        this.dumpRaster(outDemGC, this.outDem);
    }

    private SimpleFeatureCollection featureCollectionFromNonGroundCoordinates(CoordinateReferenceSystem crs, List<Coordinate> nonGroundCoordinateList) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("nongroundpoints");
        b.setCRS(crs);
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        b.add("the_geom", Point.class);
        b.add("elev", Double.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        for (Coordinate c : nonGroundCoordinateList) {
            Point g = this.gf.createPoint(c);
            Object[] values = new Object[]{g, c.z};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(null);
            newCollection.add(feature);
        }
        return newCollection;
    }

    private List<Coordinate> getSeeds(List<Geometry> secGridGeoms) throws Exception {
        final ArrayList<Coordinate> seedsList = new ArrayList<Coordinate>();
        try (final ALasDataManager lasHandler = ALasDataManager.getDataManager((File)new File(this.inLas), null, (double)0.0, (CoordinateReferenceSystem)this.inTemplateGC.getCoordinateReferenceSystem());){
            lasHandler.open();
            int defaultThreadsNum = AdaptiveTinFilter.getDefaultThreadsNum();
            this.pm.beginTask("Extracting seed points on " + secGridGeoms.size() + " tiles... (cores = " + defaultThreadsNum + ")", secGridGeoms.size());
            ThreadedRunnable tRun = new ThreadedRunnable(defaultThreadsNum, null);
            for (final Geometry secGridGeom : secGridGeoms) {
                tRun.executeRunnable(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            List pointsInGeom = lasHandler.getPointsInGeometry(secGridGeom, true);
                            if (pointsInGeom.size() != 0) {
                                Collections.sort(pointsInGeom, new LasRecordElevationComparator());
                                LasRecord seedPoint = (LasRecord)pointsInGeom.get(0);
                                seedsList.add(new Coordinate(seedPoint.x, seedPoint.y, seedPoint.z));
                            } else {
                                AdaptiveTinFilter.this.pm.errorMessage("No points in: " + secGridGeom);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        AdaptiveTinFilter.this.pm.worked(1);
                    }
                });
            }
            tRun.waitAndClose();
            this.pm.done();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return seedsList;
    }
}

