/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.raster.adaptivetinfilter;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hortonmachine.gears.io.las.ALasDataManager;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.modules.ThreadedRunnable;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.hortonmachine.lesto.modules.raster.adaptivetinfilter.PointsToCoordinateComparator;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class TinHandler {
    public static final double POINTENVELOPE_EXPAND = 0.1;
    private List<Coordinate> tinCoordinateList = new ArrayList<Coordinate>();
    private List<Coordinate> leftOverCoordinateList = new ArrayList<Coordinate>();
    private Geometry[] tinGeometries = null;
    private GeometryFactory gf = GeometryUtilities.gf();
    private final IHMProgressMonitor pm;
    private boolean didInitialize = false;
    private boolean isFirstStatsCalculation = true;
    private final CoordinateReferenceSystem crs;
    private final double distanceThreshold;
    private final int threadsNum;
    private double calculatedAngleThreshold;
    private double calculatedDistanceThreshold;
    private final ReadWriteLock monitor = new ReentrantReadWriteLock();
    private final Double maxEdgeLength;
    private double maxEdgeLengthThreshold;
    private final double angleThreshold;

    public TinHandler(IHMProgressMonitor pm, CoordinateReferenceSystem crs, double angleThreshold, double distanceThreshold, Double maxEdgeLength, int threadsNum) {
        this.pm = pm;
        this.crs = crs;
        this.angleThreshold = angleThreshold;
        this.distanceThreshold = distanceThreshold;
        this.maxEdgeLength = maxEdgeLength;
        this.threadsNum = threadsNum;
    }

    public void setStartCoordinates(List<Coordinate> coordinateList) {
        this.generateTin(coordinateList);
        for (int i = 0; i < this.tinGeometries.length; ++i) {
            Coordinate[] coordinates = this.tinGeometries[i].getCoordinates();
            if (!this.tinCoordinateList.contains(coordinates[0])) {
                this.tinCoordinateList.add(coordinates[0]);
            }
            if (!this.tinCoordinateList.contains(coordinates[1])) {
                this.tinCoordinateList.add(coordinates[1]);
            }
            if (this.tinCoordinateList.contains(coordinates[2])) continue;
            this.tinCoordinateList.add(coordinates[2]);
        }
        this.didInitialize = true;
    }

    public Geometry[] getTriangles() {
        this.checkTinGeometries();
        return this.tinGeometries;
    }

    public int getCurrentGroundPointsNum() {
        return this.tinCoordinateList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentNonGroundPointsNum() {
        List<Coordinate> list = this.leftOverCoordinateList;
        synchronized (list) {
            return this.leftOverCoordinateList.size();
        }
    }

    public void filterOnAllData(final ALasDataManager lasHandler) throws Exception {
        final ConcurrentSkipListSet<Double> angleSet = new ConcurrentSkipListSet<Double>();
        final ConcurrentSkipListSet<Double> distanceSet = new ConcurrentSkipListSet<Double>();
        if (this.isFirstStatsCalculation) {
            this.pm.beginTask("Calculating initial statistics...", this.tinGeometries.length);
        } else {
            this.pm.beginTask("Filtering all data on seeds tin...", this.tinGeometries.length);
        }
        try {
            final ArrayList<Coordinate> newTotalLeftOverCoordinateList = new ArrayList<Coordinate>();
            if (this.threadsNum > 1) {
                ThreadedRunnable tRun = new ThreadedRunnable(this.threadsNum, null);
                for (final Geometry tinGeom : this.tinGeometries) {
                    tRun.executeRunnable(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<Coordinate> leftOverList = TinHandler.this.runFilterOnAllData(lasHandler, angleSet, distanceSet, tinGeom);
                            List list = newTotalLeftOverCoordinateList;
                            synchronized (list) {
                                newTotalLeftOverCoordinateList.addAll(leftOverList);
                            }
                        }
                    });
                }
                tRun.waitAndClose();
            } else {
                for (Geometry tinGeom : this.tinGeometries) {
                    List<Coordinate> leftOverList = this.runFilterOnAllData(lasHandler, angleSet, distanceSet, tinGeom);
                    newTotalLeftOverCoordinateList.addAll(leftOverList);
                }
            }
            this.pm.done();
            this.leftOverCoordinateList.clear();
            this.leftOverCoordinateList.addAll(newTotalLeftOverCoordinateList);
            if (angleSet.size() > 1) {
                this.calculatedAngleThreshold = this.getMedianFromSet(angleSet);
                this.pm.message("Calculated angle threshold: " + this.calculatedAngleThreshold + " (range: " + angleSet.first() + " to " + angleSet.last() + ")");
            } else {
                if (angleSet.size() == 0) {
                    return;
                }
                this.calculatedAngleThreshold = angleSet.first();
                this.pm.message("Single angle left: " + this.calculatedAngleThreshold);
            }
            if (distanceSet.size() > 1) {
                this.calculatedDistanceThreshold = this.getMedianFromSet(distanceSet);
                this.pm.message("Calculated distance threshold: " + this.calculatedDistanceThreshold + " (range: " + distanceSet.first() + " to " + distanceSet.last() + ")");
            } else {
                if (distanceSet.size() == 0) {
                    return;
                }
                this.calculatedDistanceThreshold = distanceSet.first();
                this.pm.message("Single distance left: " + this.calculatedDistanceThreshold);
            }
            if (this.isFirstStatsCalculation) {
                this.isFirstStatsCalculation = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Coordinate> runFilterOnAllData(ALasDataManager lasHandler, ConcurrentSkipListSet<Double> angleSet, ConcurrentSkipListSet<Double> distanceSet, Geometry tinGeom) {
        ArrayList<Coordinate> newTotalLeftOverCoordinateList = new ArrayList<Coordinate>();
        try {
            Coordinate[] tinCoords = tinGeom.getCoordinates();
            Coordinate triangleCentroid = GeometryUtilities.getTriangleCentroid((Coordinate)tinCoords[0], (Coordinate)tinCoords[1], (Coordinate)tinCoords[2]);
            List pointsInGeom = lasHandler.getPointsInGeometry(tinGeom, false);
            TreeSet<Coordinate> centroidNearestSet = new TreeSet<Coordinate>(new PointsToCoordinateComparator(triangleCentroid));
            for (LasRecord pointInGeom : pointsInGeom) {
                Coordinate c = new Coordinate(pointInGeom.x, pointInGeom.y, pointInGeom.z);
                if (c.equals((Object)tinCoords[0]) || c.equals((Object)tinCoords[1]) || c.equals((Object)tinCoords[2])) continue;
                centroidNearestSet.add(c);
            }
            boolean foundOne = false;
            for (Coordinate c : centroidNearestSet) {
                if (foundOne && !this.isFirstStatsCalculation) {
                    if (newTotalLeftOverCoordinateList.contains(c)) continue;
                    newTotalLeftOverCoordinateList.add(c);
                    continue;
                }
                Coordinate[] nodes = this.getOrderedNodes(c, tinCoords[0], tinCoords[1], tinCoords[2]);
                double nearestDistance = GeometryUtilities.distance3d((Coordinate)nodes[0], (Coordinate)c, null);
                if (!this.isFirstStatsCalculation && nearestDistance > this.calculatedDistanceThreshold) {
                    if (newTotalLeftOverCoordinateList.contains(c)) continue;
                    newTotalLeftOverCoordinateList.add(c);
                    continue;
                }
                double angle = GeometryUtilities.getAngleBetweenLinePlane((Coordinate)c, (Coordinate)nodes[0], (Coordinate)nodes[1], (Coordinate)nodes[2]);
                if (Double.isNaN(angle)) {
                    this.pm.errorMessage("Found NaN angle, set to 0...");
                    angle = 0.0;
                }
                if (!this.isFirstStatsCalculation) {
                    if (angle > this.calculatedAngleThreshold) {
                        if (newTotalLeftOverCoordinateList.contains(c)) continue;
                        newTotalLeftOverCoordinateList.add(c);
                        continue;
                    }
                    List<Coordinate> list = this.tinCoordinateList;
                    synchronized (list) {
                        if (!this.tinCoordinateList.contains(c)) {
                            this.tinCoordinateList.add(c);
                            foundOne = true;
                            angleSet.add(angle);
                            distanceSet.add(nearestDistance);
                        }
                        continue;
                    }
                }
                angleSet.add(angle);
                distanceSet.add(nearestDistance);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pm.worked(1);
        return newTotalLeftOverCoordinateList;
    }

    public void filterOnLeftOverData() {
        if (this.isFirstStatsCalculation) {
            throw new IllegalArgumentException("The first round needs to be filtered on all data.");
        }
        this.pm.beginTask("Creating points indexes...", this.leftOverCoordinateList.size());
        final STRtree leftOverCoordinatesTree = new STRtree(this.leftOverCoordinateList.size());
        for (Coordinate c : this.leftOverCoordinateList) {
            leftOverCoordinatesTree.insert(new Envelope(c), (Object)c);
        }
        this.pm.done();
        if (this.maxEdgeLength != null) {
            this.maxEdgeLengthThreshold = this.maxEdgeLength;
        }
        Geometry[] triangles = this.getTriangles();
        final ConcurrentSkipListSet<Double> angleSet = new ConcurrentSkipListSet<Double>();
        final ConcurrentSkipListSet<Double> distanceSet = new ConcurrentSkipListSet<Double>();
        final ArrayList<Coordinate> newTotalLeftOverCoordinateList = new ArrayList<Coordinate>();
        this.pm.beginTask("Filtering leftover coordinates on previous tin...", triangles.length);
        if (this.threadsNum > 1) {
            ThreadedRunnable tRun = new ThreadedRunnable(this.threadsNum, null);
            for (int i = 0; i < triangles.length; ++i) {
                final Geometry triangle = triangles[i];
                tRun.executeRunnable(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (TinHandler.this.maxEdgeLength != null && triangle.getLength() < TinHandler.this.maxEdgeLengthThreshold * 3.0) {
                            return;
                        }
                        List<Coordinate> leftOverList = TinHandler.this.runfilterOnLeftOverData(leftOverCoordinatesTree, angleSet, distanceSet, triangle);
                        List list = newTotalLeftOverCoordinateList;
                        synchronized (list) {
                            newTotalLeftOverCoordinateList.addAll(leftOverList);
                        }
                    }
                });
            }
            tRun.waitAndClose();
        } else {
            for (int i = 0; i < triangles.length; ++i) {
                Geometry triangle = triangles[i];
                List<Coordinate> leftOverList = this.runfilterOnLeftOverData(leftOverCoordinatesTree, angleSet, distanceSet, triangle);
                newTotalLeftOverCoordinateList.addAll(leftOverList);
            }
        }
        this.pm.done();
        this.leftOverCoordinateList.clear();
        this.leftOverCoordinateList.addAll(newTotalLeftOverCoordinateList);
        if (angleSet.size() > 1) {
            this.calculatedAngleThreshold = this.getMedianFromSet(angleSet);
            this.pm.message("Calculated angle threshold: " + this.calculatedAngleThreshold + " (range: " + angleSet.first() + " to " + angleSet.last() + ")");
        } else {
            if (angleSet.size() == 0) {
                return;
            }
            this.calculatedAngleThreshold = angleSet.first();
            this.pm.message("Single angle left: " + this.calculatedAngleThreshold);
        }
        if (distanceSet.size() > 1) {
            this.calculatedDistanceThreshold = this.getMedianFromSet(distanceSet);
            this.pm.message("Calculated distance threshold: " + this.calculatedDistanceThreshold + " (range: " + distanceSet.first() + " to " + distanceSet.last() + ")");
        } else {
            if (distanceSet.size() == 0) {
                return;
            }
            this.calculatedDistanceThreshold = distanceSet.first();
            this.pm.message("Single distance left: " + this.calculatedDistanceThreshold);
        }
        if (this.calculatedDistanceThreshold < this.distanceThreshold) {
            this.calculatedDistanceThreshold = this.distanceThreshold;
            this.pm.message("Corrected calculated distance threshold to be: " + this.calculatedDistanceThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Coordinate> runfilterOnLeftOverData(STRtree leftOverCoordsTree, ConcurrentSkipListSet<Double> angleSet, ConcurrentSkipListSet<Double> distanceSet, Geometry triangle) {
        ArrayList<Coordinate> newLeftOverCoordinateList = new ArrayList<Coordinate>();
        Coordinate[] tinCoords = triangle.getCoordinates();
        Coordinate triangleCentroid = GeometryUtilities.getTriangleCentroid((Coordinate)tinCoords[0], (Coordinate)tinCoords[1], (Coordinate)tinCoords[2]);
        List triangleCoordinates = null;
        this.monitor.readLock().lock();
        try {
            triangleCoordinates = leftOverCoordsTree.query(triangle.getEnvelopeInternal());
        }
        finally {
            this.monitor.readLock().unlock();
        }
        TreeSet<Coordinate> centroidNearestSet = new TreeSet<Coordinate>(new PointsToCoordinateComparator(triangleCentroid));
        for (Object coordinateObj : triangleCoordinates) {
            int loc;
            Coordinate c = (Coordinate)coordinateObj;
            if (c.equals((Object)tinCoords[0]) || c.equals((Object)tinCoords[1]) || c.equals((Object)tinCoords[2]) || (loc = SimplePointInAreaLocator.locate((Coordinate)c, (Geometry)triangle)) != 0) continue;
            centroidNearestSet.add(c);
        }
        boolean foundOne = false;
        for (Coordinate c : centroidNearestSet) {
            if (foundOne && !this.isFirstStatsCalculation) {
                if (newLeftOverCoordinateList.contains(c)) continue;
                newLeftOverCoordinateList.add(c);
                continue;
            }
            Coordinate[] nodes = this.getOrderedNodes(c, tinCoords[0], tinCoords[1], tinCoords[2]);
            double nearestDistance = GeometryUtilities.distance3d((Coordinate)nodes[0], (Coordinate)c, null);
            if (nearestDistance > this.calculatedDistanceThreshold) {
                if (newLeftOverCoordinateList.contains(c)) continue;
                newLeftOverCoordinateList.add(c);
                continue;
            }
            double angle = GeometryUtilities.getAngleBetweenLinePlane((Coordinate)c, (Coordinate)nodes[0], (Coordinate)nodes[1], (Coordinate)nodes[2]);
            if (Double.isNaN(angle)) {
                this.pm.errorMessage("Found NaN angle, set to 0...");
                angle = 0.0;
            }
            if (angle > this.calculatedAngleThreshold && angle > this.angleThreshold) {
                if (newLeftOverCoordinateList.contains(c)) continue;
                newLeftOverCoordinateList.add(c);
                continue;
            }
            List<Coordinate> list = this.tinCoordinateList;
            synchronized (list) {
                if (!this.tinCoordinateList.contains(c)) {
                    this.tinCoordinateList.add(c);
                    foundOne = true;
                    angleSet.add(angle);
                    distanceSet.add(nearestDistance);
                }
            }
        }
        this.pm.worked(1);
        return newLeftOverCoordinateList;
    }

    public void finalCleanup(final double pFinalCleanupDist) {
        if (this.isFirstStatsCalculation) {
            throw new IllegalArgumentException("The first round needs to be filtered on all data.");
        }
        this.pm.beginTask("Creating points indexes...", this.leftOverCoordinateList.size());
        final STRtree leftOverCoordinatesTree = new STRtree(this.leftOverCoordinateList.size());
        for (Coordinate c : this.leftOverCoordinateList) {
            leftOverCoordinatesTree.insert(new Envelope(c), (Object)c);
        }
        this.pm.done();
        final AtomicInteger removedCount = new AtomicInteger();
        Geometry[] triangles = this.getTriangles();
        final ArrayList newLeftOverCoordinateList = new ArrayList();
        this.pm.beginTask("Final cleanup through triangle to point distance filter...", triangles.length);
        ThreadedRunnable tRun = new ThreadedRunnable(this.threadsNum, null);
        for (int i = 0; i < triangles.length; ++i) {
            final Geometry triangle = triangles[i];
            tRun.executeRunnable(new Runnable(){

                @Override
                public void run() {
                    TinHandler.this.runFinalFilter(leftOverCoordinatesTree, newLeftOverCoordinateList, triangle, pFinalCleanupDist, removedCount);
                }
            });
        }
        tRun.waitAndClose();
        this.pm.done();
        this.pm.message("Final points removed from non ground: " + removedCount.get());
        this.pm.message("Final points left as non ground: " + newLeftOverCoordinateList.size());
        this.leftOverCoordinateList.clear();
        this.leftOverCoordinateList.addAll(newLeftOverCoordinateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFinalFilter(STRtree leftOverCoordsTree, List<Coordinate> newLeftOverCoordinateList, Geometry triangle, double pFinalCleanupDist, AtomicInteger removedCount) {
        Coordinate[] tinCoords = triangle.getCoordinates();
        List triangleCoordinates = null;
        this.monitor.readLock().lock();
        try {
            triangleCoordinates = leftOverCoordsTree.query(triangle.getEnvelopeInternal());
        }
        finally {
            this.monitor.readLock().unlock();
        }
        int count = 0;
        for (Object coordinateObj : triangleCoordinates) {
            Coordinate c2;
            Coordinate c1;
            Coordinate intersection;
            double distance;
            Coordinate c = (Coordinate)coordinateObj;
            int loc = SimplePointInAreaLocator.locate((Coordinate)c, (Geometry)triangle);
            if (loc != 0 || !((distance = GeometryUtilities.distance3d((Coordinate)(intersection = GeometryUtilities.getLineWithPlaneIntersection((Coordinate)(c1 = new Coordinate(c.x, c.y, 1000000.0)), (Coordinate)(c2 = new Coordinate(c.x, c.y, -1000000.0)), (Coordinate)tinCoords[0], (Coordinate)tinCoords[1], (Coordinate)tinCoords[2])), (Coordinate)c, null)) > pFinalCleanupDist)) continue;
            ++count;
            List<Coordinate> list = newLeftOverCoordinateList;
            synchronized (list) {
                newLeftOverCoordinateList.add(c);
            }
        }
        removedCount.addAndGet(count);
        this.pm.worked(1);
    }

    public void resetTin() {
        this.tinGeometries = null;
    }

    private void generateTin(List<Coordinate> coordinateList) {
        this.pm.beginTask("Generate tin...", -1);
        DelaunayTriangulationBuilder b = new DelaunayTriangulationBuilder();
        b.setSites(coordinateList);
        Geometry tinTriangles = b.getTriangles(this.gf);
        this.tinGeometries = new Geometry[tinTriangles.getNumGeometries()];
        for (int i = 0; i < tinTriangles.getNumGeometries(); ++i) {
            this.tinGeometries[i] = tinTriangles.getGeometryN(i);
        }
        this.pm.done();
    }

    public STRtree generateTinIndex(Double maxEdgeLength) {
        double maxEdge = maxEdgeLength != null ? maxEdgeLength : 0.0;
        this.pm.beginTask("Creating tin indexes...", this.tinGeometries.length);
        STRtree tinTree = new STRtree(this.tinGeometries.length);
        for (Geometry geometry : this.tinGeometries) {
            if (maxEdgeLength != null) {
                Coordinate[] coordinates = geometry.getCoordinates();
                double maxLength = GeometryUtilities.distance3d((Coordinate)coordinates[0], (Coordinate)coordinates[1], null);
                double tmpLength = GeometryUtilities.distance3d((Coordinate)coordinates[1], (Coordinate)coordinates[2], null);
                if (tmpLength > maxLength) {
                    maxLength = tmpLength;
                }
                if ((tmpLength = GeometryUtilities.distance3d((Coordinate)coordinates[2], (Coordinate)coordinates[0], null)) > maxLength) {
                    maxLength = tmpLength;
                }
                if (maxLength < maxEdge) continue;
            }
            tinTree.insert(geometry.getEnvelopeInternal(), (Object)geometry);
        }
        this.pm.done();
        return tinTree;
    }

    private void checkTinGeometries() {
        if (!this.didInitialize) {
            throw new IllegalArgumentException("Not initialized properly. Did you call setStartCoordinates?");
        }
        if (this.tinGeometries == null) {
            this.generateTin(this.tinCoordinateList);
        }
    }

    private Coordinate[] getOrderedNodes(Coordinate c, Coordinate coordinate1, Coordinate coordinate2, Coordinate coordinate3) {
        double d3;
        double d = GeometryUtilities.distance3d((Coordinate)c, (Coordinate)coordinate1, null);
        Coordinate nearest = coordinate1;
        Coordinate c2 = coordinate2;
        Coordinate c3 = coordinate3;
        double d2 = GeometryUtilities.distance3d((Coordinate)c, (Coordinate)coordinate2, null);
        if (d2 < d) {
            nearest = coordinate2;
            d = d2;
            c2 = coordinate1;
            c3 = coordinate3;
        }
        if ((d3 = GeometryUtilities.distance3d((Coordinate)c, (Coordinate)coordinate3, null)) < d) {
            nearest = coordinate3;
            c2 = coordinate1;
            c3 = coordinate2;
        }
        return new Coordinate[]{nearest, c2, c3};
    }

    private double getMedianFromSet(ConcurrentSkipListSet<Double> set) {
        double threshold = 0.0;
        int halfNum = set.size() / 2;
        int count = 0;
        for (double value : set) {
            if (count == halfNum) {
                threshold = value;
                break;
            }
            ++count;
        }
        return threshold;
    }

    private double getAverageFromSet(ConcurrentSkipListSet<Double> set) {
        double sum = 0.0;
        int count = 0;
        for (double value : set) {
            sum += value;
            ++count;
        }
        return sum / (double)count;
    }

    private double getCenterFromSet(ConcurrentSkipListSet<Double> set) {
        return (set.last() - set.first()) / 2.0;
    }

    public SimpleFeatureCollection toFeatureCollection() {
        this.checkTinGeometries();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("triangle");
        b.setCRS(this.crs);
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        b.add("the_geom", Polygon.class);
        b.add("elev0", Double.class);
        b.add("elev1", Double.class);
        b.add("elev2", Double.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        for (Geometry g : this.tinGeometries) {
            Coordinate[] coordinates = g.getCoordinates();
            int windingRule = GeometryUtilities.getTriangleWindingRule((Coordinate)coordinates[0], (Coordinate)coordinates[1], (Coordinate)coordinates[2]);
            Object[] values = windingRule > 0 ? new Object[]{g, coordinates[0].z, coordinates[2].z, coordinates[1].z} : new Object[]{g, coordinates[0].z, coordinates[1].z, coordinates[2].z};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(null);
            newCollection.add(feature);
        }
        return newCollection;
    }

    public SimpleFeatureCollection toFeatureCollectionOthers() {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("points");
        b.setCRS(this.crs);
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        b.add("the_geom", Point.class);
        b.add("elev", Double.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        for (Coordinate c : this.leftOverCoordinateList) {
            Object[] values = new Object[]{this.gf.createPoint(c), c.z};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(null);
            newCollection.add(feature);
        }
        return newCollection;
    }

    public SimpleFeatureCollection toFeatureCollectionTinPoints() {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("points");
        b.setCRS(this.crs);
        DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
        b.add("the_geom", Point.class);
        b.add("elev", Double.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        for (Coordinate c : this.tinCoordinateList) {
            Object[] values = new Object[]{this.gf.createPoint(c), c.z};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(null);
            newCollection.add(feature);
        }
        return newCollection;
    }

    public double[] getMinMaxElev() {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (Coordinate coordinate : this.tinCoordinateList) {
            max = Math.max(max, coordinate.z);
            min = Math.min(min, coordinate.z);
        }
        return new double[]{min, max};
    }
}

