/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.utilities;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.ALasDataManager;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.exceptions.ModelsIOException;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.chart.Scatter;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.jfree.data.xy.XYSeries;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Creates vertical slices of a las file. The resulting raster will have the slice height value as valid pixel value.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="slices, lidar, las")
@Label(value="Lesto/utilities")
@Name(value="lasslicer")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class LasSlicer
extends HMModel {
    @Description(value="Las file or folder path.")
    @UI(value="infile_las")
    @In
    public String inLas = null;
    @Description(value="The slicing interval.")
    @In
    @Unit(value="m")
    public double pInterval = 1.0;
    @Description(value="The slice thickness.")
    @In
    @Unit(value="m")
    public double pThickness = 0.8;
    @Description(value="Threshold from ground (-1 means no threshold).")
    @In
    @Unit(value="m")
    public double pGroundThreshold = 0.5;
    @Description(value="Type of output to use.")
    @UI(value="combo: chart, raster")
    @In
    public String pMode = "raster";
    @Description(value="Raster resolution in case of raster mode..")
    @In
    @Unit(value="m")
    public double pResolution = 0.5;
    private WritableRandomIter outIter;
    private GridGeometry2D gridGeometry;
    private WritableRaster outWR;
    private boolean doRaster = true;

    @Execute
    public void process() throws Exception {
        File lasFile;
        File parentFile;
        File outputFolder;
        this.checkNull(new Object[]{this.inLas});
        if (this.pMode.equals("chart")) {
            this.doRaster = false;
        }
        if (!(outputFolder = new File(parentFile = (lasFile = new File(this.inLas)).getParentFile(), "vertical_slices")).exists() && !outputFolder.mkdir()) {
            throw new ModelsIOException("Can't create folder: " + outputFolder, (Object)this);
        }
        try (ALasDataManager dataManager = ALasDataManager.getDataManager((File)lasFile, null, (double)this.pGroundThreshold, null);){
            dataManager.open();
            ReferencedEnvelope3D dataEnvelope = dataManager.getEnvelope3D();
            CoordinateReferenceSystem crs = dataEnvelope.getCoordinateReferenceSystem();
            double minX = dataEnvelope.getMinX();
            double minY = dataEnvelope.getMinY();
            double minZ = dataEnvelope.getMinZ();
            double maxX = dataEnvelope.getMaxX();
            double maxY = dataEnvelope.getMaxY();
            double maxZ = dataEnvelope.getMaxZ();
            double xDelta = maxX - minX;
            double yDelta = maxY - minY;
            int chartWidth = 1600;
            int chartHeigth = (int)((double)chartWidth * yDelta / xDelta);
            if (!this.doRaster) {
                this.pm.message("Generating charts of " + chartWidth + "x" + chartHeigth);
            }
            double[] xRange = NumericsUtilities.range2Bins((double)minX, (double)maxX, (double)3.0, (boolean)false);
            double[] yRange = NumericsUtilities.range2Bins((double)minY, (double)maxY, (double)3.0, (boolean)false);
            for (double z = minZ + this.pInterval; z < maxZ; z += this.pInterval) {
                double low = z - this.pThickness / 2.0;
                double high = z + this.pThickness / 2.0;
                Predicate<LasRecord> checkHeight = p -> p.z > low && p.z <= high;
                XYSeries xySeries = new XYSeries((Comparable)((Object)"planimetry"));
                this.pm.beginTask("Working on slice of elevation " + z, xRange.length - 1);
                for (int x = 0; x < xRange.length - 1; ++x) {
                    for (int y = 0; y < yRange.length - 1; ++y) {
                        Envelope currentTileEnvelope = new Envelope(xRange[x], xRange[x + 1], yRange[y], yRange[y + 1]);
                        Polygon currentTilePolygon = GeometryUtilities.createPolygonFromEnvelope((Envelope)currentTileEnvelope);
                        List pointsInCurrentTile = dataManager.getPointsInGeometry((Geometry)currentTilePolygon, true);
                        if (pointsInCurrentTile.size() == 0) continue;
                        double _z = z;
                        if (this.doRaster) {
                            pointsInCurrentTile.parallelStream().filter(checkHeight).forEach(p -> {
                                if (this.outIter == null) {
                                    int rows = (int)Math.round((maxY - minY) / this.pResolution);
                                    int cols = (int)Math.round((maxX - minX) / this.pResolution);
                                    this.gridGeometry = CoverageUtilities.gridGeometryFromRegionValues((double)maxY, (double)minY, (double)maxX, (double)minX, (int)cols, (int)rows, (CoordinateReferenceSystem)crs);
                                    this.outWR = CoverageUtilities.createWritableRaster((int)cols, (int)rows, null, null, (Object)-9999.0);
                                    this.outIter = CoverageUtilities.getWritableRandomIterator((WritableRaster)this.outWR);
                                }
                                Point point = new Point();
                                CoverageUtilities.colRowFromCoordinate((Coordinate)new Coordinate(p.x, p.y), (GridGeometry2D)this.gridGeometry, (Point)point);
                                this.outIter.setSample(point.x, point.y, 0, _z);
                            });
                            continue;
                        }
                        pointsInCurrentTile.stream().filter(checkHeight).forEach(p -> {
                            try {
                                xySeries.add(p.x, p.y);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    }
                    this.pm.worked(1);
                }
                this.pm.done();
                if (this.doRaster && this.outIter != null) {
                    this.outIter.done();
                    File rasterFile = new File(outputFolder, "slice_" + z + ".asc");
                    RegionMap regionMap = CoverageUtilities.gridGeometry2RegionParamsMap((GridGeometry2D)this.gridGeometry);
                    GridCoverage2D outRaster = CoverageUtilities.buildCoverage((String)rasterFile.getName(), (WritableRaster)this.outWR, (HashMap)regionMap, (CoordinateReferenceSystem)crs);
                    this.dumpRaster(outRaster, rasterFile.getAbsolutePath());
                    this.outIter = null;
                    continue;
                }
                int size = xySeries.getItemCount();
                if (size > 0) {
                    File chartFile = new File(outputFolder, "slice_" + z + ".png");
                    this.pm.message("Generate chart with points: " + size);
                    Scatter scatterPlanim = new Scatter("Slice " + z);
                    scatterPlanim.addSeries(xySeries);
                    scatterPlanim.setShowLines(Arrays.asList(false));
                    scatterPlanim.setXLabel("longitude");
                    scatterPlanim.setYLabel("latitude");
                    scatterPlanim.setXRange(minX, maxX);
                    scatterPlanim.setYRange(minY, maxY);
                    BufferedImage imagePlanim = scatterPlanim.getImage(chartWidth, chartHeigth);
                    ImageIO.write((RenderedImage)imagePlanim, "png", chartFile);
                    continue;
                }
                this.pm.message("No points in slice.");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        LasSlicer ls = new LasSlicer();
        ls.inLas = "/media/hydrologis/Samsung_T3/UNIBZ/monticolo_tls/monticolo2018_point_cloud_02.sqlite";
        ls.pInterval = 0.5;
        ls.pThickness = 0.5;
        ls.pMode = "raster";
        ls.process();
    }
}

