/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.vector;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.hortonmachine.gears.io.las.ALasDataManager;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.las.index.LasIndexer;
import org.hortonmachine.gears.io.las.utils.LasUtils;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module that creates a CHM triangulation from point clouds.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="triangulation, lidar, chm")
@Label(value="Lesto/vector")
@Name(value="laschmtriangulation")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
@UI(value="hide")
public class LasChmTriangulation
extends HMModel {
    @Description(value="Las file or folder index path.")
    @In
    public String inLasFile = null;
    @Description(value="A dtm raster to use for the area of interest.")
    @In
    public GridCoverage2D inDtm;
    @Description(value="Elevation threshold for triangles.")
    @In
    public Double pElevThres = 0.5;
    @Description(value="The filtered triangles.")
    @Out
    public List<Geometry> trianglesList;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLasFile});
        CoordinateReferenceSystem crs = null;
        Polygon polygon = null;
        if (this.inDtm != null) {
            polygon = CoverageUtilities.getRegionPolygon((GridCoverage2D)this.inDtm);
            crs = this.inDtm.getCoordinateReferenceSystem();
        }
        try (ALasDataManager lasData = ALasDataManager.getDataManager((File)new File(this.inLasFile), (GridCoverage2D)this.inDtm, (double)0.0, (CoordinateReferenceSystem)crs);){
            this.pm.beginTask("Reading data...", -1);
            lasData.open();
            if (polygon == null) {
                ReferencedEnvelope overallEnvelope = lasData.getOverallEnvelope();
                polygon = LasIndexer.envelopeToPolygon((Envelope)overallEnvelope);
            }
            List lasPoints = lasData.getPointsInGeometry((Geometry)polygon, false);
            this.pm.done();
            this.trianglesList = LasUtils.triangulate((List)lasPoints, (Double)this.pElevThres, (this.inDtm != null ? 1 : 0) != 0, (IHMProgressMonitor)this.pm);
        }
    }

    public List<Geometry> blanket(List<LasRecord> lasPoints, boolean useGround, IHMProgressMonitor pm) {
        pm.beginTask("Triangulation...", -1);
        ArrayList<Coordinate> lasCoordinates = new ArrayList<Coordinate>();
        for (LasRecord lasRecord : lasPoints) {
            lasCoordinates.add(new Coordinate(lasRecord.x, lasRecord.y, useGround ? lasRecord.groundElevation : lasRecord.z));
        }
        DelaunayTriangulationBuilder triangulationBuilder = new DelaunayTriangulationBuilder();
        triangulationBuilder.setSites(lasCoordinates);
        Geometry triangles = triangulationBuilder.getTriangles(this.gf);
        pm.done();
        ArrayList<Geometry> trianglesList = new ArrayList<Geometry>();
        int numTriangles = triangles.getNumGeometries();
        for (int i = 0; i < numTriangles; ++i) {
            Geometry geometryN = triangles.getGeometryN(i);
            trianglesList.add(geometryN);
        }
        STRtree tree = GeometryUtilities.geometriesToSRTree(trianglesList);
        boolean[] toRemove = new boolean[numTriangles];
        pm.beginTask("Blanket creation...", toRemove.length);
        int i = 0;
        if (i < toRemove.length) {
            Geometry triangle = (Geometry)trianglesList.get(i);
            Coordinate[] coordinates = triangle.getCoordinates();
            double minZ = Math.min(coordinates[0].z, Math.min(coordinates[1].z, coordinates[2].z));
            Coordinate c = new Coordinate(725740.0, 5205762.0);
            Envelope env = new Envelope(c);
            env.expandBy(3.0);
            List result = tree.query(env);
            return result;
        }
        pm.done();
        ArrayList<Geometry> finalTrianglesList = new ArrayList<Geometry>();
        for (int i2 = 0; i2 < toRemove.length; ++i2) {
            if (toRemove[i2]) continue;
            Geometry triangle = (Geometry)trianglesList.get(i2);
            finalTrianglesList.add(triangle);
        }
        System.out.println("Triangles: " + trianglesList.size());
        System.out.println("Final Triangles: " + finalTrianglesList.size());
        return finalTrianglesList;
    }
}

