/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.utilities;

import java.io.File;
import java.io.FilenameFilter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.las.utils.LasUtils;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Print out information of a las file or las data folder.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="info, lidar, las")
@Label(value="Lesto/utilities")
@Name(value="lasinfo")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class LasInfo
extends HMModel {
    @Description(value="Las file or folder path.")
    @UI(value="infile_las")
    @In
    public String inLas = null;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLas});
        File[] lasFiles = null;
        File inLasFile = new File(this.inLas);
        lasFiles = inLasFile.isDirectory() ? inLasFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".las");
            }
        }) : new File[]{inLasFile};
        for (File file : lasFiles) {
            this.pm.message("***********************************************");
            this.pm.message("*   " + file.toString());
            this.pm.message("***********************************************");
            try (ALasReader lasReader = ALasReader.getReader((File)file, null);){
                lasReader.open();
                ILasHeader header = lasReader.getHeader();
                this.pm.message("*   HEADER");
                this.pm.message("**************");
                this.pm.message(header.toString());
                CoordinateReferenceSystem crs = header.getCrs();
                this.pm.message("**************");
                this.pm.message("*   CRS");
                this.pm.message("**************");
                if (crs != null) {
                    this.pm.message(crs.toString());
                } else {
                    this.pm.message("No CRS information.");
                }
                this.pm.message("****************");
                this.pm.message("*   SAMPLE DATA");
                this.pm.message("****************");
                int i = 1;
                while (lasReader.hasNextPoint()) {
                    LasRecord dot = lasReader.getNextPoint();
                    this.pm.message("Point " + i);
                    this.pm.message(LasUtils.lasRecordToString((LasRecord)dot));
                    if (++i <= 3) continue;
                    break;
                }
            }
            this.pm.message("***********************************************");
        }
    }

    public static void printInfo(String filePath) throws Exception {
        LasInfo lasInfo = new LasInfo();
        lasInfo.inLas = filePath;
        lasInfo.process();
    }
}

