/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.vegetation;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.List;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.lesto.modules.vegetation.watershed.WatershedFIFO;
import org.hortonmachine.lesto.modules.vegetation.watershed.WatershedPixel;
import org.hortonmachine.lesto.modules.vegetation.watershed.WatershedStructure;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Calculates the watershed of a 8-bit images. It uses the immersion algorithm written by Vincent and Soille (1991)")
@Documentation(value="http://rsbweb.nih.gov/ij/plugins/watershed.html")
@Author(name="Christopher Mei, Lee Vincent and Pierre Soille 1991, Andrea Antonello (hm port)", contact="christopher.mei@sophia.inria.fr")
@Keywords(value="IMAGE-PROC SKELETON SEGMENTATION GIS")
@Label(value="Lesto/vegetation")
@Name(value="contourscrowner")
@Status(value=5)
@License(value="GPL2")
public class WatershedAlgorithm
extends HMModel {
    @Description(value="An elevation raster")
    @UI(value="infile_raster")
    @In
    public String inRaster;
    @Description(value="If true, the borders of the watershed are set, else the content.")
    @In
    public boolean doBorders = true;
    @Description(value="Watershed raster")
    @UI(value="outfile")
    @In
    public String outRaster;

    @Execute
    public void process() throws Exception {
        WatershedPixel p;
        int pixelIndex;
        this.checkNull(new Object[]{this.inRaster, this.outRaster});
        GridCoverage2D inRasterGC = this.getRaster(this.inRaster);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)inRasterGC);
        int nCols = regionMap.getCols();
        int nRows = regionMap.getRows();
        byte[] input = CoverageUtilities.renderedImage2ByteArray((RenderedImage)inRasterGC.getRenderedImage(), (boolean)true);
        WatershedStructure watershedStructure = new WatershedStructure(input, nCols, nRows, this.pm);
        WatershedFIFO queue = new WatershedFIFO();
        int curlab = 0;
        int heightIndex1 = 0;
        int heightIndex2 = 0;
        block0: for (int h = 0; h < 256; ++h) {
            WatershedPixel q;
            int i;
            List<WatershedPixel> neighbours;
            WatershedPixel p2;
            block1: for (int pixelIndex2 = heightIndex1; pixelIndex2 < watershedStructure.size(); ++pixelIndex2) {
                p2 = watershedStructure.get(pixelIndex2);
                if (p2.getIntHeight() != h) {
                    heightIndex1 = pixelIndex2;
                    break;
                }
                p2.setLabelToMASK();
                neighbours = p2.getNeighbours();
                for (i = 0; i < neighbours.size(); ++i) {
                    q = neighbours.get(i);
                    if (q.getLabel() < 0) continue;
                    p2.setDistance(1);
                    queue.fifo_add(p2);
                    continue block1;
                }
            }
            int curdist = 1;
            queue.fifo_add_FICTITIOUS();
            block3: while (true) {
                if ((p2 = queue.fifo_remove()).isFICTITIOUS()) {
                    if (queue.fifo_empty()) break;
                    queue.fifo_add_FICTITIOUS();
                    ++curdist;
                    p2 = queue.fifo_remove();
                }
                neighbours = p2.getNeighbours();
                i = 0;
                while (true) {
                    if (i >= neighbours.size()) continue block3;
                    q = neighbours.get(i);
                    if (q.getDistance() <= curdist && q.getLabel() >= 0) {
                        if (q.getLabel() > 0) {
                            if (p2.isLabelMASK()) {
                                p2.setLabel(q.getLabel());
                            } else if (p2.getLabel() != q.getLabel()) {
                                p2.setLabelToWSHED();
                            }
                        } else if (p2.isLabelMASK()) {
                            p2.setLabelToWSHED();
                        }
                    } else if (q.isLabelMASK() && q.getDistance() == 0) {
                        q.setDistance(curdist + 1);
                        queue.fifo_add(q);
                    }
                    ++i;
                }
                break;
            }
            for (pixelIndex = heightIndex2; pixelIndex < watershedStructure.size(); ++pixelIndex) {
                p = watershedStructure.get(pixelIndex);
                if (p.getIntHeight() != h) {
                    heightIndex2 = pixelIndex;
                    continue block0;
                }
                p.setDistance(0);
                if (!p.isLabelMASK()) continue;
                p.setLabel(++curlab);
                queue.fifo_add(p);
                while (!queue.fifo_empty()) {
                    WatershedPixel q2 = queue.fifo_remove();
                    List<WatershedPixel> neighbours2 = q2.getNeighbours();
                    for (int i2 = 0; i2 < neighbours2.size(); ++i2) {
                        WatershedPixel r = neighbours2.get(i2);
                        if (!r.isLabelMASK()) continue;
                        r.setLabel(curlab);
                        queue.fifo_add(r);
                    }
                }
            }
        }
        WritableRaster outWR = CoverageUtilities.createWritableRaster((int)nCols, (int)nRows, null, null, (Object)-9999.0);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        this.pm.beginTask("Setting watersheds...", watershedStructure.size());
        for (pixelIndex = 0; pixelIndex < watershedStructure.size(); ++pixelIndex) {
            p = watershedStructure.get(pixelIndex);
            int c = p.getX();
            int r = p.getY();
            if (p.isLabelWSHED() && !p.allNeighboursAreWSHED()) {
                if (this.doBorders) {
                    outIter.setSample(c, r, 0, 1.0);
                }
            } else if (!this.doBorders) {
                outIter.setSample(c, r, 0, 1.0);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        outIter.done();
        GridCoverage2D outRasterGC = CoverageUtilities.buildCoverage((String)"normalized", (WritableRaster)outWR, (RegionMap)regionMap, (CoordinateReferenceSystem)inRasterGC.getCoordinateReferenceSystem());
        this.dumpRaster(outRasterGC, this.outRaster);
    }
}

