/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.filter;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.hortonmachine.gears.io.las.ALasDataManager;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.las.utils.LasRecordGroundElevationComparator;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.filter.OmsKernelFilter;
import org.hortonmachine.gears.ui.OmsMatrixCharter;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.features.FeatureMate;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module that analyzes the height distribution of a las file and categorizes the forest type.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="las, distribution ")
@Label(value="Lesto/filter")
@Name(value="lasheightdistribution")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LasHeightDistribution
extends HMModel {
    @Description(value="Las files folder main index file path.")
    @UI(value="infile_las")
    @In
    public String inIndexFile = null;
    @Description(value="DEM to normalize heights.")
    @UI(value="infile_raster")
    @In
    public String inDem = null;
    @Description(value="Tiled region to work on.")
    @UI(value="infile_vector")
    @In
    public String inVector = null;
    @Description(value="Normalization difference threshold in meters.")
    @In
    public double pThres = 2.0;
    @Description(value="Minumin percentage of overlap that defines a multilayer.")
    @In
    public double pOverlapPerc = 80.0;
    @Description(value="Field name for tile id.")
    @In
    public String fId = "id";
    @Description(value="Optional folder to dump charts in.")
    @UI(value="outfolder")
    @In
    public String outChartsFolder = null;
    @Description(value="The output raster of forest categories.")
    @UI(value="outfile")
    @In
    public String outCats = null;
    private boolean doChart = false;
    private File outChartsFolderFile;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inIndexFile, this.inVector, this.inDem});
        if (this.outChartsFolder != null) {
            this.outChartsFolderFile = new File(this.outChartsFolder);
            if (this.outChartsFolderFile.exists()) {
                this.doChart = true;
            }
        }
        double percentageOverlap = this.pOverlapPerc / 100.0;
        File indexFile = new File(this.inIndexFile);
        SimpleFeatureCollection tilesFC = this.getVector(this.inVector);
        List tilesMates = FeatureUtilities.featureCollectionToMatesList((SimpleFeatureCollection)tilesFC);
        GridCoverage2D inDemGC = this.getRaster(this.inDem);
        CoordinateReferenceSystem crs = inDemGC.getCoordinateReferenceSystem();
        WritableRaster[] finalCoverageWRH = new WritableRaster[1];
        GridCoverage2D outCatsGC = CoverageUtilities.createCoverageFromTemplate((GridCoverage2D)inDemGC, (Double)-9999.0, (WritableRaster[])finalCoverageWRH);
        WritableRandomIter finalIter = CoverageUtilities.getWritableRandomIterator((WritableRaster)finalCoverageWRH[0]);
        try (ALasDataManager dataManager = ALasDataManager.getDataManager((File)indexFile, (GridCoverage2D)inDemGC, (double)this.pThres, null);){
            dataManager.open();
            for (int i = 0; i < tilesMates.size(); ++i) {
                this.pm.message("Processing tile: " + i + "/" + tilesMates.size());
                FeatureMate tileMate = (FeatureMate)tilesMates.get(i);
                String id = (String)tileMate.getAttribute(this.fId, String.class);
                Geometry tileGeom = tileMate.getGeometry();
                Envelope geomEnvelope = tileGeom.getEnvelopeInternal();
                ReferencedEnvelope refEnvelope = new ReferencedEnvelope(geomEnvelope, crs);
                Envelope2D tileEnvelope = new Envelope2D((org.opengis.geometry.Envelope)refEnvelope);
                WritableRaster[] tmpWrH = new WritableRaster[1];
                GridCoverage2D tmp = CoverageUtilities.createSubCoverageFromTemplate((GridCoverage2D)inDemGC, (Envelope2D)tileEnvelope, (Double)-9999.0, (WritableRaster[])tmpWrH);
                RegionMap tileRegionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)tmp);
                GridGeometry2D tileGridGeometry = tmp.getGridGeometry();
                List pointsListForTile = dataManager.getPointsInGeometry(tileGeom, true);
                if (pointsListForTile.size() == 0) {
                    this.pm.errorMessage("No points found in tile: " + id);
                    continue;
                }
                if (pointsListForTile.size() < 2) {
                    this.pm.errorMessage("Not enough points found in tile: " + id);
                    continue;
                }
                List<double[]> negativeRanges = this.analyseNegativeLayerRanges(id, pointsListForTile);
                ArrayList<GridCoverage2D> rangeCoverages = new ArrayList<GridCoverage2D>();
                for (double[] range : negativeRanges) {
                    List pointsInVerticalRange = ALasDataManager.getPointsInVerticalRange((List)pointsListForTile, (double)range[0], (double)range[1], (boolean)true);
                    WritableRaster[] wrH = new WritableRaster[1];
                    GridCoverage2D tmpCoverage = CoverageUtilities.createSubCoverageFromTemplate((GridCoverage2D)inDemGC, (Envelope2D)tileEnvelope, (Double)-9999.0, (WritableRaster[])wrH);
                    rangeCoverages.add(tmpCoverage);
                    WritableRandomIter tmpIter = CoverageUtilities.getWritableRandomIterator((WritableRaster)wrH[0]);
                    DirectPosition2D wp = new DirectPosition2D();
                    for (LasRecord lasRecord : pointsInVerticalRange) {
                        wp.setLocation(lasRecord.x, lasRecord.y);
                        GridCoordinates2D gp = tileGridGeometry.worldToGrid((DirectPosition)wp);
                        double count = tmpIter.getSampleDouble(gp.x, gp.y, 0);
                        if (HMConstants.isNovalue((double)count)) {
                            count = 0.0;
                        }
                        tmpIter.setSample(gp.x, gp.y, 0, count + 1.0);
                    }
                    tmpIter.done();
                }
                boolean isDoubleLayered = false;
                if (rangeCoverages.size() > 1) {
                    for (int j = 0; j < rangeCoverages.size() - 1; ++j) {
                        GridCoverage2D cov2;
                        GridCoverage2D cov1 = (GridCoverage2D)rangeCoverages.get(j);
                        if (!this.overlapForPercentage(cov1, cov2 = (GridCoverage2D)rangeCoverages.get(j + 1), percentageOverlap)) continue;
                        isDoubleLayered = true;
                        break;
                    }
                }
                GridGeometry2D gridGeometry = outCatsGC.getGridGeometry();
                double[] gridValue = new double[1];
                int cols = tileRegionMap.getCols();
                int rows = tileRegionMap.getRows();
                for (int c = 0; c < cols; ++c) {
                    for (int r = 0; r < rows; ++r) {
                        int value = 0;
                        GridCoordinates2D gridPosition = new GridCoordinates2D(c, r);
                        for (int j = 0; j < rangeCoverages.size(); ++j) {
                            GridCoverage2D cov = (GridCoverage2D)rangeCoverages.get(j);
                            cov.evaluate(gridPosition, gridValue);
                            if (HMConstants.isNovalue((double)gridValue[0])) continue;
                            ++value;
                        }
                        if (value > 1) {
                            value = isDoubleLayered ? 3 : 2;
                        }
                        DirectPosition worldPosition = tileGridGeometry.gridToWorld(gridPosition);
                        GridCoordinates2D worldPositionCats = gridGeometry.worldToGrid(worldPosition);
                        finalIter.setSample(worldPositionCats.x, worldPositionCats.y, 0, value);
                    }
                }
            }
        }
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)outCatsGC);
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        for (int c = 0; c < cols; ++c) {
            for (int r = 0; r < rows; ++r) {
                double value = finalIter.getSampleDouble(c, r, 0);
                if (!HMConstants.isNovalue((double)value)) continue;
                finalIter.setSample(c, r, 0, 0.0);
            }
        }
        finalIter.done();
        this.dumpRaster(outCatsGC, this.outCats);
    }

    private boolean overlapForPercentage(GridCoverage2D cov1, GridCoverage2D cov2, double forPercentage) {
        RandomIter cov1Iter = CoverageUtilities.getRandomIterator((GridCoverage2D)cov1);
        RandomIter cov2Iter = CoverageUtilities.getRandomIterator((GridCoverage2D)cov2);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)cov1);
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        int valid1 = 0;
        int valid2 = 0;
        int overlapping = 0;
        for (int c = 0; c < cols; ++c) {
            for (int r = 0; r < rows; ++r) {
                double v1 = cov1Iter.getSampleDouble(c, r, 0);
                double v2 = cov2Iter.getSampleDouble(c, r, 0);
                if (!HMConstants.isNovalue((double)v1)) {
                    ++valid1;
                }
                if (!HMConstants.isNovalue((double)v2)) {
                    ++valid2;
                }
                if (HMConstants.isNovalue((double)v1) || HMConstants.isNovalue((double)v2)) continue;
                ++overlapping;
            }
        }
        cov1Iter.done();
        cov2Iter.done();
        if (overlapping == 0) {
            return false;
        }
        double perc1 = overlapping / valid1;
        if (perc1 > forPercentage) {
            return true;
        }
        double perc2 = overlapping / valid2;
        return perc2 > forPercentage;
    }

    private List<double[]> analyseNegativeLayerRanges(String id, List<LasRecord> pointsList) throws Exception {
        Collections.sort(pointsList, new LasRecordGroundElevationComparator());
        double[] pointsArray = new double[pointsList.size()];
        for (int i = 0; i < pointsArray.length; ++i) {
            LasRecord lasRecord = pointsList.get(i);
            pointsArray[i] = lasRecord.groundElevation;
        }
        double binSize = 0.5;
        double[][] bins = LasHeightDistribution.toBins(pointsArray, binSize);
        double[] elevationsArray = bins[0];
        double[] countsArray = bins[1];
        int gaussian = 12;
        double[] paddedCountsArray = this.doPadding(countsArray, gaussian);
        double[] paddedGaussianSmoothedValues = OmsKernelFilter.gaussianSmooth((double[])paddedCountsArray, (int)gaussian);
        double[] gaussianSmoothedValues = new double[countsArray.length];
        for (int i = 0; i < gaussianSmoothedValues.length; ++i) {
            gaussianSmoothedValues[i] = paddedGaussianSmoothedValues[gaussian + i];
        }
        double[] deriv2 = new double[gaussianSmoothedValues.length];
        deriv2[0] = 0.0;
        deriv2[deriv2.length - 1] = 0.0;
        for (int i = 1; i < bins[0].length - 1; ++i) {
            double derivata2;
            double elevM1 = bins[0][i - 1];
            double elev = bins[0][i];
            double hM1 = gaussianSmoothedValues[i - 1];
            double h = gaussianSmoothedValues[i];
            double hP1 = gaussianSmoothedValues[i + 1];
            double delev = elev - elevM1;
            deriv2[i] = derivata2 = (hP1 - 2.0 * h + hM1) / (delev * delev);
        }
        this.doChart(id, bins, gaussianSmoothedValues, deriv2);
        List negativeRangesIndexes = NumericsUtilities.getNegativeRanges((double[])deriv2);
        ArrayList<double[]> negativeRanges = new ArrayList<double[]>();
        for (int[] index : negativeRangesIndexes) {
            negativeRanges.add(new double[]{elevationsArray[index[0]], elevationsArray[index[1]]});
        }
        return negativeRanges;
    }

    private void doChart(String id, double[][] bins, double[] gaussianSmoothedValues, double[] deriv2) throws Exception {
        if (this.doChart) {
            double[][] data = new double[bins[0].length][4];
            for (int i = 0; i < bins[0].length; ++i) {
                data[i][0] = bins[0][i];
                data[i][1] = bins[1][i];
                data[i][2] = gaussianSmoothedValues[i];
                data[i][3] = deriv2[i];
            }
            File chartFile = new File(this.outChartsFolderFile, "chart_" + id + ".png");
            OmsMatrixCharter charter = new OmsMatrixCharter();
            charter.doChart = false;
            charter.doDump = true;
            charter.doLegend = false;
            charter.doHorizontal = true;
            charter.pHeight = 600;
            charter.pWidth = 300;
            charter.pType = 0;
            charter.inData = data;
            charter.inTitle = "Height distribution id = " + id;
            charter.inSubTitle = "";
            charter.inChartPath = chartFile.getAbsolutePath();
            String[] labels = new String[]{"height [m]", "number of points"};
            String[] series = new String[]{"original distribution", "gaussian smoothed", "second derivative"};
            charter.inLabels = labels;
            charter.inSeries = series;
            charter.inColors = "255,0,0;0,0,255;0,0,0";
            charter.chart();
        }
    }

    private double[] doPadding(double[] countsArray, int gaussian) {
        double[] paddedCountsArray = new double[countsArray.length + 2 * gaussian];
        for (int i = 0; i < paddedCountsArray.length; ++i) {
            paddedCountsArray[i] = i < gaussian ? 0.0 : (i >= gaussian && i < paddedCountsArray.length - gaussian ? countsArray[i - gaussian] : 0.0);
        }
        return paddedCountsArray;
    }

    public static double[][] toBins(double[] values, double binSize) {
        double max = values[values.length - 1];
        double min = values[0];
        int num = (int)Math.ceil((max - min) / binSize);
        if (num == 0) {
            num = 1;
        }
        double from = min;
        double to = min + binSize;
        double[][] result = new double[2][num];
        for (int i = 0; i < num; ++i) {
            double centerValue;
            int count = 0;
            for (int j = 0; j < values.length; ++j) {
                if (!(values[j] >= from) || !(values[j] < to)) continue;
                ++count;
            }
            result[0][i] = centerValue = from + binSize / 2.0;
            result[1][i] = count;
            from += binSize;
            to += binSize;
        }
        return result;
    }
}

