/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ALasWriter;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="A module that splits a las file into smaller pieces.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="las, split")
@Label(value="Lesto/filter")
@Name(value="lassplitter")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LasSplitter
extends HMModel {
    @Description(value="A las file to split.")
    @UI(value="infile_las")
    @In
    public String inFile;
    @Description(value="The rows to split into.")
    @In
    public int pRows;
    @Description(value="The cols to split into.")
    @In
    public int pCols;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inFile});
        File inLas = new File(this.inFile);
        String lasName = FileUtilities.getNameWithoutExtention((File)inLas);
        try (ALasReader reader = ALasReader.getReader((File)inLas, null);){
            reader.open();
            ILasHeader header = reader.getHeader();
            long recordsNum = header.getRecordsCount();
            double[] xyzScale = header.getXYZScale();
            double[] xyzOffset = header.getXYZOffset();
            ReferencedEnvelope3D env = header.getDataEnvelope();
            double[] xRange = NumericsUtilities.range2Bins((double)env.getMinX(), (double)env.getMaxX(), (int)this.pCols);
            double[] yRange = NumericsUtilities.range2Bins((double)env.getMinY(), (double)env.getMaxY(), (int)this.pRows);
            STRtree envelopeTree = new STRtree();
            HashMap<Envelope, ALasWriter> env2LaswriterMap = new HashMap<Envelope, ALasWriter>();
            int fileCount = 1;
            for (int x = 0; x < xRange.length - 1; ++x) {
                double minX = xRange[x];
                double maxX = xRange[x + 1];
                for (int y = 0; y < yRange.length - 1; ++y) {
                    double minY = yRange[y];
                    double maxY = yRange[y + 1];
                    Envelope envelope = new Envelope(new Coordinate(minX, minY), new Coordinate(maxX, maxY));
                    File outLasPiece = new File(inLas.getParentFile(), lasName + "_" + fileCount + ".las");
                    ALasWriter writer = ALasWriter.getWriter((File)outLasPiece, (CoordinateReferenceSystem)env.getCoordinateReferenceSystem());
                    writer.setOffset(xyzOffset[0], xyzOffset[1], xyzOffset[2]);
                    writer.setScales(xyzScale[0], xyzScale[1], xyzScale[2]);
                    writer.setBounds(minX, maxX, minY, maxY, env.getMinZ(), env.getMaxZ());
                    writer.open();
                    envelopeTree.insert(envelope, (Object)writer);
                    env2LaswriterMap.put(envelope, writer);
                    ++fileCount;
                }
            }
            this.pm.beginTask("Split file...", (int)recordsNum);
            while (reader.hasNextPoint()) {
                LasRecord dot = reader.getNextPoint();
                Coordinate coord = new Coordinate(dot.x, dot.y);
                List result = envelopeTree.query(new Envelope(coord));
                int size = result.size();
                if (size == 0) continue;
                ALasWriter aLasWriter = (ALasWriter)result.get(0);
                aLasWriter.addPoint(dot);
                this.pm.worked(1);
            }
            this.pm.done();
            for (ALasWriter writer : env2LaswriterMap.values()) {
                writer.close();
            }
        }
    }
}

