/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.flightlines;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ALasWriter;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.io.las.utils.GpsTimeConverter;
import org.hortonmachine.gears.io.las.utils.LasUtils;
import org.hortonmachine.gears.io.vectorreader.OmsVectorReader;
import org.hortonmachine.gears.libs.exceptions.ModelsIllegalargumentException;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.features.FeatureUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="A module that normalizes flightlines based on the aircraft position.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="las, normalize, flightlines")
@Label(value="Lesto/flightlines")
@Name(value="lasflightlinesnormalization")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class FlightLinesIntensityNormalizer
extends HMModel {
    @Description(value="A las file.")
    @UI(value="infile_las")
    @In
    public String inLas;
    @Description(value="Shapefile containing the string fields of date, time, elev.")
    @UI(value="infile_vector")
    @In
    public String inFlightpoints;
    @Description(value="The square of standard range.")
    @In
    public double pStdRange = 600.0;
    @Description(value="The date and time pattern (date and time field content will be concatenated through a space).")
    @In
    public String pDateTimePattern = "yyyy-MM-dd HH:mm:ss";
    @Description(value="The gps time type used in the las file.")
    @UI(value="combo:Adjusted Standard GPS Time,Week.seconds time")
    @In
    public String pGpsTimeType = "Adjusted Standard GPS Time";
    @Description(value="Normalized output las file.")
    @UI(value="outfile")
    @In
    public String outLas;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLas, this.inFlightpoints, this.pDateTimePattern});
        int timeType = -1;
        if (this.pGpsTimeType.equals("Adjusted Standard GPS Time")) {
            timeType = 1;
        }
        if (this.pGpsTimeType.equals("Week.seconds time")) {
            timeType = 0;
        }
        SimpleFeatureCollection flightPointsFC = OmsVectorReader.readVector((String)this.inFlightpoints);
        List flightPointsList = FeatureUtilities.featureCollectionToList((SimpleFeatureCollection)flightPointsFC);
        SimpleFeatureType schema = (SimpleFeatureType)flightPointsFC.getSchema();
        String dateName = FeatureUtilities.findAttributeName((SimpleFeatureType)schema, (String)"date");
        String timeName = FeatureUtilities.findAttributeName((SimpleFeatureType)schema, (String)"time");
        String elevName = FeatureUtilities.findAttributeName((SimpleFeatureType)schema, (String)"elev");
        if (dateName == null || timeName == null || elevName == null) {
            throw new ModelsIllegalargumentException("The shapefile has to contain the fields date time and elev.", (Object)this);
        }
        this.pm.beginTask("Defining flight intervals and positions...", flightPointsList.size());
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)this.pDateTimePattern).withZone(DateTimeZone.UTC);
        TreeMap<DateTime, Coordinate> date2pointsMap = new TreeMap<DateTime, Coordinate>();
        TreeMap<Coordinate, DateTime> points2dateMap = new TreeMap<Coordinate, DateTime>();
        for (int i = 0; i < flightPointsList.size(); ++i) {
            double elev1;
            SimpleFeature flightPoint = (SimpleFeature)flightPointsList.get(i);
            Geometry g1 = (Geometry)flightPoint.getDefaultGeometry();
            Coordinate c1 = g1.getCoordinate();
            c1.z = elev1 = ((Number)flightPoint.getAttribute(elevName)).doubleValue();
            String date1 = flightPoint.getAttribute(dateName).toString();
            String time1 = flightPoint.getAttribute(timeName).toString();
            String dateTime1 = date1 + " " + time1;
            DateTime d1 = formatter.parseDateTime(dateTime1);
            date2pointsMap.put(d1, c1);
            points2dateMap.put(c1, d1);
            this.pm.worked(1);
        }
        this.pm.done();
        this.pm.beginTask("Create time index...", flightPointsList.size() - 1);
        DateTime minDate = null;
        DateTime maxDate = null;
        long minLong = Long.MAX_VALUE;
        long maxLong = -9223372036854775807L;
        STRtree tree = new STRtree(flightPointsList.size());
        Set pointsSet = date2pointsMap.entrySet();
        Map.Entry[] array = pointsSet.toArray(new Map.Entry[0]);
        for (int i = 0; i < array.length - 1; ++i) {
            DateTime d1 = (DateTime)array[i].getKey();
            Coordinate c1 = (Coordinate)array[i].getValue();
            DateTime d2 = (DateTime)array[i + 1].getKey();
            Coordinate c2 = (Coordinate)array[i + 1].getValue();
            long millis1 = d1.getMillis();
            long millis2 = d2.getMillis();
            Envelope timeEnv = new Envelope((double)millis1, (double)millis2, (double)millis1, (double)millis2);
            tree.insert(timeEnv, (Object)new Coordinate[]{c1, c2});
            if (millis1 < minLong) {
                minLong = millis1;
                minDate = d1;
            }
            if (millis2 > maxLong) {
                maxLong = millis2;
                maxDate = d2;
            }
            this.pm.worked(1);
        }
        this.pm.done();
        StringBuilder sb = new StringBuilder();
        sb.append("Flight data interval: ");
        sb.append(minDate.toString(HMConstants.dateTimeFormatterYYYYMMDDHHMMSS));
        sb.append(" to ");
        sb.append(maxDate.toString(HMConstants.dateTimeFormatterYYYYMMDDHHMMSS));
        this.pm.message(sb.toString());
        CoordinateReferenceSystem crs = null;
        File lasFile = new File(this.inLas);
        File outLasFile = new File(this.outLas);
        try (ALasReader reader = ALasReader.getReader((File)lasFile, crs);
             ALasWriter writer = ALasWriter.getWriter((File)outLasFile, crs);){
            reader.setOverrideGpsTimeType(timeType);
            ILasHeader header = reader.getHeader();
            int gpsTimeType = header.getGpsTimeType();
            writer.setBounds(header);
            writer.open();
            this.pm.beginTask("Interpolating flight points and normalizing...", (int)header.getRecordsCount());
            while (reader.hasNextPoint()) {
                short norm;
                double interpolatedElev;
                LasRecord r = reader.getNextPoint();
                DateTime gpsTimeToDateTime = timeType == 0 ? GpsTimeConverter.gpsWeekTime2DateTime((double)r.gpsTime) : LasUtils.adjustedStandardGpsTime2DateTime((double)r.gpsTime);
                long gpsMillis = gpsTimeToDateTime.getMillis();
                Coordinate lasCoordinate = new Coordinate(r.x, r.y, r.z);
                Envelope pEnv = new Envelope(new Coordinate((double)gpsMillis, (double)gpsMillis));
                List points = tree.query(pEnv);
                Coordinate[] flightCoords = (Coordinate[])points.get(0);
                long d1 = ((DateTime)points2dateMap.get(flightCoords[0])).getMillis();
                long d2 = ((DateTime)points2dateMap.get(flightCoords[1])).getMillis();
                LineSegment line = new LineSegment(flightCoords[0], flightCoords[1]);
                double fraction = (gpsMillis - d1) / (d2 - d1);
                Coordinate interpolatedFlightPoint = line.pointAlong(fraction);
                double distX = interpolatedFlightPoint.distance(flightCoords[0]);
                double dist12 = flightCoords[1].distance(flightCoords[0]);
                interpolatedFlightPoint.z = interpolatedElev = distX / dist12 * (flightCoords[1].z - flightCoords[0].z) + flightCoords[0].z;
                double distanceFlightTerrain = GeometryUtilities.distance3d((Coordinate)lasCoordinate, (Coordinate)interpolatedFlightPoint, null);
                r.intensity = norm = (short)Math.floor((double)r.intensity * Math.pow(distanceFlightTerrain, 2.0) / this.pStdRange + 0.5);
                writer.addPoint(r);
                this.pm.worked(1);
            }
            this.pm.done();
        }
    }
}

