/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.raster;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.hortonmachine.gears.io.las.ALasDataManager;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.modules.r.interpolation2d.OmsSurfaceInterpolator;
import org.hortonmachine.gears.modules.r.rastergenerator.OmsRasterGenerator;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Convert a las to a raster through IDW interpolation.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="raster, IDW, interpolation, lidar")
@Label(value="Lesto/raster")
@Name(value="las2rasterinterpolator")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class Las2RasterInterpolator
extends HMModel {
    @Description(value="Las files folder main index file path.")
    @UI(value="infile_las")
    @In
    public String inIndexFile = null;
    @Description(value="A dtm raster to use for the area of interest and to calculate the elevation threshold.")
    @UI(value="infile_raster")
    @In
    public String inDtm;
    @Description(value="Flag to normalize with the dtm.")
    @In
    public boolean doNormalize = true;
    @Description(value="New x resolution (if null, the dtm is used).")
    @In
    public Double pXres;
    @Description(value="New y resolution (if null, the dtm is used).")
    @In
    public Double pYres;
    @Description(value="The elevation threshold to apply to the chm.")
    @In
    public double pThreshold = 0.0;
    @Description(value="The impulse to use (if empty everything is used).")
    @In
    public Integer pImpulse = 1;
    @Description(value="The output raster.")
    @UI(value="outfile")
    @In
    public String outRaster = null;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inIndexFile, this.inDtm});
        GridCoverage2D inDtmGC = this.getRaster(this.inDtm);
        Polygon polygon = CoverageUtilities.getRegionPolygon((GridCoverage2D)inDtmGC);
        CoordinateReferenceSystem crs = inDtmGC.getCoordinateReferenceSystem();
        try (ALasDataManager lasData = ALasDataManager.getDataManager((File)new File(this.inIndexFile), (GridCoverage2D)inDtmGC, (double)this.pThreshold, (CoordinateReferenceSystem)crs);){
            List lasPoints;
            lasData.open();
            if (this.pImpulse != null) {
                lasData.setImpulsesConstraint(new double[]{this.pImpulse.intValue()});
            }
            if ((lasPoints = lasData.getPointsInGeometry((Geometry)polygon, false)).size() == 0) {
                this.pm.message("No points foudn in the given area. Check your input.");
                return;
            }
            RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)inDtmGC);
            double north = regionMap.getNorth();
            double south = regionMap.getSouth();
            double east = regionMap.getEast();
            double west = regionMap.getWest();
            if (this.pXres == null) {
                this.pXres = regionMap.getXres();
            }
            if (this.pYres == null) {
                this.pYres = regionMap.getYres();
            }
            int newRows = (int)Math.round((north - south) / this.pYres);
            int newCols = (int)Math.round((east - west) / this.pXres);
            DefaultFeatureCollection newCollection = new DefaultFeatureCollection();
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName("lasdata");
            b.setCRS(crs);
            b.add("the_geom", Point.class);
            b.add("elev", Double.class);
            SimpleFeatureType featureType = b.buildFeatureType();
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
            this.pm.beginTask("Prepare points collection for interpolation...", lasPoints.size());
            for (LasRecord r : lasPoints) {
                Point point = this.gf.createPoint(new Coordinate(r.x, r.y));
                Object[] values = new Object[]{point, r.z};
                builder.addAll(values);
                SimpleFeature feature = builder.buildFeature(null);
                newCollection.add(feature);
                this.pm.worked(1);
            }
            this.pm.done();
            OmsRasterGenerator omsRasterGenerator = new OmsRasterGenerator();
            omsRasterGenerator.pNorth = north;
            omsRasterGenerator.pSouth = south;
            omsRasterGenerator.pWest = west;
            omsRasterGenerator.pEast = east;
            omsRasterGenerator.pXres = (east - west) / (double)newCols;
            omsRasterGenerator.pYres = (north - south) / (double)newRows;
            omsRasterGenerator.inCrs = crs;
            omsRasterGenerator.doRandom = false;
            omsRasterGenerator.process();
            OmsSurfaceInterpolator idwInterpolator = new OmsSurfaceInterpolator();
            idwInterpolator.inVector = newCollection;
            idwInterpolator.inGrid = omsRasterGenerator.outRaster;
            idwInterpolator.inMask = null;
            idwInterpolator.fCat = "elev";
            idwInterpolator.pMode = "IDW";
            idwInterpolator.pMaxThreads = Las2RasterInterpolator.getDefaultThreadsNum();
            idwInterpolator.pBuffer = 10.0;
            idwInterpolator.pm = this.pm;
            idwInterpolator.process();
            GridCoverage2D outRasterGC = idwInterpolator.outRaster;
            this.dumpRaster(outRasterGC, this.outRaster);
        }
    }
}

