/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.raster;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Point;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.hortonmachine.gears.io.las.ALasDataManager;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module that creates a raster by mapping maximum elevation las points.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="raster, lidar")
@Label(value="Lesto/raster")
@Name(value="lasonrastermapper")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class LasOnRasterMapper
extends HMModel {
    @Description(value="Las file path.")
    @UI(value="infile_las")
    @In
    public String inLas = null;
    @Description(value="A dtm raster to use for the area of interest and lower threshold.")
    @UI(value="infile_raster")
    @In
    public String inDtm;
    @Description(value="New x resolution (if null, the dtm is used).")
    @In
    public Double pXres;
    @Description(value="New y resolution (if null, the dtm is used).")
    @In
    public Double pYres;
    @Description(value="If true, the maxima are mapped else the minima.")
    @In
    public boolean doMax = true;
    @Description(value="The output raster.")
    @UI(value="outfile")
    @In
    public String outRaster = null;
    @Description(value="The input dtm, resampled on the new resolution.")
    @UI(value="outfile")
    @In
    public String outDtm = null;

    @Execute
    public void process() throws Exception {
        double dtmValue;
        this.checkNull(new Object[]{this.inLas, this.inDtm, this.outRaster});
        GridCoverage2D inDtmGC = this.getRaster(this.inDtm);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)inDtmGC);
        double north = regionMap.getNorth();
        double south = regionMap.getSouth();
        double east = regionMap.getEast();
        double west = regionMap.getWest();
        if (this.pXres == null || this.pYres == null) {
            this.pXres = regionMap.getXres();
            this.pYres = regionMap.getYres();
        }
        CoordinateReferenceSystem crs = null;
        Polygon polygon = CoverageUtilities.getRegionPolygon((GridCoverage2D)inDtmGC);
        crs = inDtmGC.getCoordinateReferenceSystem();
        GridGeometry2D dtmGridGeometry = inDtmGC.getGridGeometry();
        int newRows = (int)Math.round((north - south) / this.pYres);
        int newCols = (int)Math.round((east - west) / this.pXres);
        GridGeometry2D newGridGeometry2D = CoverageUtilities.gridGeometryFromRegionValues((double)north, (double)south, (double)east, (double)west, (int)newCols, (int)newRows, (CoordinateReferenceSystem)crs);
        RegionMap newRegionMap = CoverageUtilities.gridGeometry2RegionParamsMap((GridGeometry2D)newGridGeometry2D);
        WritableRaster newWR = CoverageUtilities.createWritableRaster((int)newCols, (int)newRows, null, null, (Object)-9999.0);
        RandomIter dtmIter = CoverageUtilities.getRandomIterator((GridCoverage2D)inDtmGC);
        try (ALasDataManager lasData = ALasDataManager.getDataManager((File)new File(this.inLas), null, (double)0.0, (CoordinateReferenceSystem)crs);){
            lasData.open();
            this.pm.beginTask("Reading points on region...", -1);
            List lasPoints = lasData.getPointsInGeometry((Geometry)polygon, false);
            this.pm.done();
            this.pm.beginTask("Setting raster points...", lasPoints.size());
            Point gridPoint = new Point();
            Point dtmPoint = new Point();
            for (LasRecord lasRecord : lasPoints) {
                double dotZ = lasRecord.z;
                Coordinate coordinate = new Coordinate(lasRecord.x, lasRecord.y, dotZ);
                CoverageUtilities.colRowFromCoordinate((Coordinate)coordinate, (GridGeometry2D)newGridGeometry2D, (Point)gridPoint);
                double newRasterValue = newWR.getSampleDouble(gridPoint.x, gridPoint.y, 0);
                CoverageUtilities.colRowFromCoordinate((Coordinate)coordinate, (GridGeometry2D)dtmGridGeometry, (Point)dtmPoint);
                dtmValue = dtmIter.getSampleDouble(dtmPoint.x, dtmPoint.y, 0);
                if (this.doMax) {
                    if (HMConstants.isNovalue((double)newRasterValue) || newRasterValue < dotZ) {
                        if (!HMConstants.isNovalue((double)dtmValue) && dtmValue > dotZ) {
                            dotZ = dtmValue;
                        }
                        newWR.setSample(gridPoint.x, gridPoint.y, 0, dotZ);
                    }
                } else if (HMConstants.isNovalue((double)newRasterValue) || newRasterValue > dotZ) {
                    if (!HMConstants.isNovalue((double)dtmValue) && dtmValue > dotZ) {
                        dotZ = dtmValue;
                    }
                    newWR.setSample(gridPoint.x, gridPoint.y, 0, dotZ);
                }
                this.pm.worked(1);
            }
            this.pm.done();
        }
        GridCoverage2D outRasterGC = CoverageUtilities.buildCoverage((String)"outraster", (WritableRaster)newWR, (HashMap)newRegionMap, (CoordinateReferenceSystem)crs);
        this.dumpRaster(outRasterGC, this.outRaster);
        if (this.pXres != null && this.pYres != null && this.outDtm != null) {
            WritableRaster[] holder = new WritableRaster[1];
            GridCoverage2D outDtmGC = CoverageUtilities.createCoverageFromTemplate((GridCoverage2D)outRasterGC, (Double)-9999.0, (WritableRaster[])holder);
            GridGeometry2D outGridGeometry = outDtmGC.getGridGeometry();
            WritableRandomIter outIter = CoverageUtilities.getWritableRandomIterator((WritableRaster)holder[0]);
            RegionMap outRegionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)outDtmGC);
            int cols = outRegionMap.getCols();
            int rows = outRegionMap.getRows();
            Point p = new Point();
            for (int c = 0; c < cols; ++c) {
                for (int r = 0; r < rows; ++r) {
                    Coordinate coordinate = CoverageUtilities.coordinateFromColRow((int)c, (int)r, (GridGeometry2D)outGridGeometry);
                    CoverageUtilities.colRowFromCoordinate((Coordinate)coordinate, (GridGeometry2D)dtmGridGeometry, (Point)p);
                    dtmValue = dtmIter.getSampleDouble(p.x, p.y, 0);
                    outIter.setSample(c, r, 0, dtmValue);
                }
            }
            outIter.done();
            this.dumpRaster(outDtmGC, this.outDtm);
        }
        dtmIter.done();
    }
}

