/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.raster;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.triangulate.DelaunayTriangulationBuilder;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.hortonmachine.gears.io.las.ALasDataManager;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.libs.modules.ThreadedRunnable;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

@Description(value="Module that creates a DSM from the triangulation of point clouds.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="triangulation, lidar, dsm")
@Label(value="Lesto/raster")
@Name(value="lastraingulation2dsm")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class LasTriangulation2Dsm
extends HMModel {
    @Description(value="Las file path.")
    @UI(value="infile_las")
    @In
    public String inLas = null;
    @Description(value="A dtm raster to use for the area of interest.")
    @UI(value="infile_raster")
    @In
    public String inDtm;
    @Description(value="New x resolution (if null, the dtm is used).")
    @In
    public Double pXres;
    @Description(value="New y resolution (if null, the dtm is used).")
    @In
    public Double pYres;
    @Description(value="Elevation threshold for triangles.")
    @In
    public double pElevThres = 0.5;
    @Description(value="The output raster.")
    @UI(value="outfile")
    @In
    public String outRaster = null;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inLas, this.inDtm, this.outRaster});
        GridCoverage2D inDtmGC = this.getRaster(this.inDtm);
        Polygon polygon = CoverageUtilities.getRegionPolygon((GridCoverage2D)inDtmGC);
        CoordinateReferenceSystem crs = inDtmGC.getCoordinateReferenceSystem();
        ArrayList<Coordinate> lasCoordinates = new ArrayList<Coordinate>();
        this.pm.beginTask("Preparing triangulation...", -1);
        try (ALasDataManager lasData = ALasDataManager.getDataManager((File)new File(this.inLas), null, (double)0.0, (CoordinateReferenceSystem)crs);){
            lasData.open();
            List lasPoints = lasData.getPointsInGeometry((Geometry)polygon, false);
            for (LasRecord lasRecord : lasPoints) {
                lasCoordinates.add(new Coordinate(lasRecord.x, lasRecord.y, lasRecord.z));
            }
        }
        DelaunayTriangulationBuilder triangulationBuilder = new DelaunayTriangulationBuilder();
        triangulationBuilder.setSites(lasCoordinates);
        Geometry triangles = triangulationBuilder.getTriangles(this.gf);
        this.pm.done();
        int numTriangles = triangles.getNumGeometries();
        this.pm.beginTask("Extracting triangles based on threshold...", numTriangles);
        ArrayList<Geometry> trianglesList = new ArrayList<Geometry>();
        for (int i = 0; i < numTriangles; ++i) {
            double diff3;
            double diff2;
            this.pm.worked(1);
            Geometry geometryN = triangles.getGeometryN(i);
            Coordinate[] coordinates = geometryN.getCoordinates();
            double diff1 = Math.abs(coordinates[0].z - coordinates[1].z);
            if (diff1 > this.pElevThres || (diff2 = Math.abs(coordinates[0].z - coordinates[2].z)) > this.pElevThres || (diff3 = Math.abs(coordinates[1].z - coordinates[2].z)) > this.pElevThres) continue;
            trianglesList.add(geometryN);
        }
        this.pm.done();
        int newNumTriangles = trianglesList.size();
        int removedNum = numTriangles - newNumTriangles;
        this.pm.message("Original triangles: " + numTriangles);
        this.pm.message("New triangles: " + newNumTriangles);
        this.pm.message("Removed triangles: " + removedNum);
        this.pm.beginTask("Create triangles index...", newNumTriangles);
        final STRtree tree = new STRtree(trianglesList.size());
        for (Geometry triangle : trianglesList) {
            Envelope env = triangle.getEnvelopeInternal();
            tree.insert(env, (Object)triangle);
            this.pm.worked(1);
        }
        this.pm.done();
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)inDtmGC);
        double north = regionMap.getNorth();
        double south = regionMap.getSouth();
        double east = regionMap.getEast();
        double west = regionMap.getWest();
        if (this.pXres == null || this.pYres == null) {
            this.pXres = regionMap.getXres();
            this.pYres = regionMap.getYres();
        }
        final int newRows = (int)Math.round((north - south) / this.pYres);
        int newCols = (int)Math.round((east - west) / this.pXres);
        final GridGeometry2D newGridGeometry2D = CoverageUtilities.gridGeometryFromRegionValues((double)north, (double)south, (double)east, (double)west, (int)newCols, (int)newRows, (CoordinateReferenceSystem)crs);
        RegionMap newRegionMap = CoverageUtilities.gridGeometry2RegionParamsMap((GridGeometry2D)newGridGeometry2D);
        final WritableRaster newWR = CoverageUtilities.createWritableRaster((int)newCols, (int)newRows, null, null, (Object)-9999.0);
        ThreadedRunnable runner = new ThreadedRunnable(LasTriangulation2Dsm.getDefaultThreadsNum(), null);
        this.pm.beginTask("Setting raster points...", newCols);
        int c = 0;
        while (c < newCols) {
            final int fCol = c++;
            runner.executeRunnable(new Runnable(){

                @Override
                public void run() {
                    try {
                        LasTriangulation2Dsm.this.makeRow(tree, newRows, newGridGeometry2D, newWR, fCol);
                    }
                    catch (TransformException e) {
                        e.printStackTrace();
                    }
                    LasTriangulation2Dsm.this.pm.worked(1);
                }
            });
        }
        runner.waitAndClose();
        this.pm.done();
        GridCoverage2D outRasterGC = CoverageUtilities.buildCoverage((String)"outraster", (WritableRaster)newWR, (HashMap)newRegionMap, (CoordinateReferenceSystem)crs);
        this.dumpRaster(outRasterGC, this.outRaster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeRow(STRtree tree, int newRows, GridGeometry2D newGridGeometry2D, WritableRaster newWR, int c) throws TransformException {
        for (int r = 0; r < newRows; ++r) {
            DirectPosition worldPosition = newGridGeometry2D.gridToWorld(new GridCoordinates2D(c, r));
            double[] wpCoords = worldPosition.getCoordinate();
            Coordinate coordinate = new Coordinate(wpCoords[0], wpCoords[1]);
            Point point = this.gf.createPoint(coordinate);
            Envelope e = new Envelope(coordinate);
            List interceptedTriangles = tree.query(e);
            if (interceptedTriangles.size() == 0) continue;
            double newElev = -9999.0;
            for (Object object : interceptedTriangles) {
                boolean equals;
                Geometry triangle;
                if (!(object instanceof Geometry) || !(triangle = (Geometry)object).intersects((Geometry)point)) continue;
                Coordinate[] triangleCoords = triangle.getCoordinates();
                Coordinate c1 = new Coordinate(coordinate.x, coordinate.y, 10000.0);
                Coordinate c2 = new Coordinate(coordinate.x, coordinate.y, -10000.0);
                Coordinate intersection = GeometryUtilities.getLineWithPlaneIntersection((Coordinate)c1, (Coordinate)c2, (Coordinate)triangleCoords[0], (Coordinate)triangleCoords[1], (Coordinate)triangleCoords[2]);
                double maxZ = Math.max(triangleCoords[0].z, triangleCoords[1].z);
                if (intersection.z > (maxZ = Math.max(maxZ, triangleCoords[2].z)) && !(equals = NumericsUtilities.dEq((double)intersection.z, (double)maxZ, (double)1.0E-4))) {
                    this.pm.errorMessage(triangle.toText());
                    this.pm.errorMessage(this.gf.createPoint(intersection).toText());
                    throw new RuntimeException("Intersection can't be  > than the triangle.");
                }
                if (!(intersection.z > newElev)) continue;
                newElev = intersection.z;
            }
            WritableRaster writableRaster = newWR;
            synchronized (writableRaster) {
                newWR.setSample(c, r, 0, newElev);
                continue;
            }
        }
    }
}

