/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.utilities;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ALasWriter;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="A module that allows to normalize the las over an elevation model (or vice versa).")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="las, dem")
@Label(value="Lesto/utilities")
@Name(value="laselevationhandler")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LasElevationHandler
extends HMModel {
    @Description(value="The las file to handle.")
    @UI(value="infile_las")
    @In
    public String inFile;
    @Description(value="A dtm raster to use for the ellevation normlization.")
    @UI(value="infile_raster")
    @In
    public String inDtm;
    @Description(value="If set to true, the dtm value is added to the las elevation, instead of subtracted.")
    @In
    public boolean doAdd = false;
    @Description(value="The nomalized las file.")
    @UI(value="outfile")
    @In
    public String outFile;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inFile, this.inDtm});
        GridCoverage2D dtm = this.getRaster(this.inDtm);
        File inLas = new File(this.inFile);
        try (ALasReader reader = ALasReader.getReader((File)inLas, null);){
            reader.open();
            ILasHeader header = reader.getHeader();
            long recordsNum = header.getRecordsCount();
            ReferencedEnvelope3D env = header.getDataEnvelope();
            File outLas = new File(this.outFile);
            try (ALasWriter writer = ALasWriter.getWriter((File)outLas, (CoordinateReferenceSystem)env.getCoordinateReferenceSystem());){
                writer.setBounds(header);
                writer.open();
                this.pm.beginTask("Normalizing las...", (int)recordsNum);
                while (reader.hasNextPoint()) {
                    LasRecord dot = reader.getNextPoint();
                    double dtmValue = CoverageUtilities.getValue((GridCoverage2D)dtm, (double)dot.x, (double)dot.y);
                    if (HMConstants.isNovalue((double)dtmValue)) {
                        dtmValue = 0.0;
                    }
                    dot.z = this.doAdd ? (dot.z += dtmValue) : (dot.z -= dtmValue);
                    writer.addPoint(dot);
                    this.pm.worked(1);
                }
                this.pm.done();
            }
        }
    }
}

