/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.lesto.modules.utilities;

import java.io.File;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.hortonmachine.gears.io.las.core.ALasReader;
import org.hortonmachine.gears.io.las.core.ALasWriter;
import org.hortonmachine.gears.io.las.core.ILasHeader;
import org.hortonmachine.gears.io.las.core.LasRecord;
import org.hortonmachine.gears.libs.modules.HMModel;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="A module to shift las files by a given distance (given in units of the data crs).")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="las, move")
@Label(value="Lesto/utilities")
@Name(value="lasmover")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class LasMover
extends HMModel {
    @Description(value="The las file to move.")
    @UI(value="infile_las")
    @In
    public String inFile;
    @Description(value="The easting translation to apply.")
    @In
    public double pDeltaX = 0.0;
    @Description(value="The northing translation to apply.")
    @In
    public double pDeltaY = 0.0;
    @Description(value="The elevation translation to apply.")
    @In
    public double pDeltaZ = 0.0;
    @Description(value="The moved las file.")
    @UI(value="outfile")
    @In
    public String outFile;

    @Execute
    public void process() throws Exception {
        this.checkNull(new Object[]{this.inFile});
        File inLas = new File(this.inFile);
        try (ALasReader reader = ALasReader.getReader((File)inLas, null);){
            reader.open();
            ILasHeader header = reader.getHeader();
            long recordsNum = header.getRecordsCount();
            double[] xyzScale = header.getXYZScale();
            double[] xyzOffset = header.getXYZOffset();
            ReferencedEnvelope3D env = header.getDataEnvelope();
            File outLas = new File(this.outFile);
            try (ALasWriter writer = ALasWriter.getWriter((File)outLas, (CoordinateReferenceSystem)env.getCoordinateReferenceSystem());){
                writer.setOffset(xyzOffset[0], xyzOffset[1], xyzOffset[2]);
                writer.setScales(xyzScale[0], xyzScale[1], xyzScale[2]);
                writer.setBounds(env.getMinX() + this.pDeltaX, env.getMaxX() + this.pDeltaX, env.getMinY() + this.pDeltaY, env.getMaxY() + this.pDeltaY, env.getMinZ() + this.pDeltaZ, env.getMaxZ() + this.pDeltaZ);
                writer.open();
                this.pm.beginTask("Moving las...", (int)recordsNum);
                while (reader.hasNextPoint()) {
                    LasRecord dot = reader.getNextPoint();
                    dot.x += this.pDeltaX;
                    dot.y += this.pDeltaY;
                    dot.z += this.pDeltaZ;
                    writer.addPoint(dot);
                    this.pm.worked(1);
                }
                this.pm.done();
            }
        }
    }
}

